/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileContextImpl;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.FileStampStorage;
import org.jetbrains.jps.incremental.storage.MurmurHashingService;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Experimental
public class BuildTargetSourcesState
implements BuildListener {
    private static final Logger LOG = Logger.getInstance(BuildTargetSourcesState.class);
    private static final String TARGET_SOURCES_STATE_FILE_NAME = "target_sources_state.json";
    private final ExecutorService myParallelBuildExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"TargetSourcesState Executor Pool", (Executor)SharedThreadPool.getInstance(), (int)IncProjectBuilder.MAX_BUILDER_THREADS);
    private final Map<String, BuildTarget<?>> myChangedBuildTargets;
    private final Map<String, byte[]> myCalculatedHashes;
    private final PathRelativizerService myRelativizer;
    private final BuildTargetIndex myBuildTargetIndex;
    private final BuildRootIndex myBuildRootIndex;
    private final ProjectStamps myProjectStamps;
    private final CompileContextImpl myContext;
    private final String myOutputFolderPath;
    private final File myTargetStateStorage;
    private final Type myTokenType;
    private final Gson gson = new Gson();

    public BuildTargetSourcesState(@NotNull CompileContextImpl context) {
        this.myContext = context;
        this.myCalculatedHashes = new ConcurrentHashMap<String, byte[]>();
        this.myChangedBuildTargets = new ConcurrentHashMap();
        ProjectDescriptor pd = this.myContext.getProjectDescriptor();
        this.myProjectStamps = pd.getProjectStamps();
        this.myBuildRootIndex = pd.getBuildRootIndex();
        this.myBuildTargetIndex = pd.getBuildTargetIndex();
        this.myRelativizer = pd.dataManager.getRelativizer();
        this.myOutputFolderPath = BuildTargetSourcesState.getOutputFolderPath(pd.getProject());
        BuildDataPaths dataPaths = pd.getTargetsState().getDataPaths();
        this.myTargetStateStorage = new File(dataPaths.getDataStorageRoot(), TARGET_SOURCES_STATE_FILE_NAME);
        this.myTokenType = new TypeToken<Map<String, Map<String, BuildTargetState>>>(){}.getType();
        this.myContext.addBuildListener(this);
    }

    public void reportSourcesState() {
        List<BuildTarget<?>> buildTargets;
        if (this.reportStateUnavailable()) {
            return;
        }
        long start = System.nanoTime();
        Map<String, Map<String, BuildTargetState>> targetTypeHashMap = this.loadCurrentTargetState();
        if (targetTypeHashMap.isEmpty()) {
            buildTargets = this.myBuildTargetIndex.getAllTargets();
        } else {
            ArrayList changedBuildTargets = new ArrayList(this.myChangedBuildTargets.values());
            LOG.info("List of changed build targets: " + changedBuildTargets);
            buildTargets = changedBuildTargets;
        }
        ContainerUtil.map(buildTargets, target -> this.myParallelBuildExecutor.submit(() -> {
            BuildTargetType buildTargetType = target.getTargetType();
            String typeTypeId = buildTargetType.getTypeId();
            this.getBuildTargetHash((BuildTarget<?>)target, this.myContext).ifPresent(buildTargetHash -> {
                String hexString = StringUtil.toHexString((byte[])buildTargetHash);
                String relativePath = target.getOutputRoots(this.myContext).stream().map(file -> this.myRelativizer.toRelative(file.getAbsolutePath())).findFirst().orElse("");
                Map map = targetTypeHashMap;
                synchronized (map) {
                    targetTypeHashMap.computeIfAbsent(typeTypeId, key -> new HashMap()).put(target.getId(), new BuildTargetState(hexString, relativePath));
                }
            });
        })).forEach(future -> {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Unable to get the result from future", (Throwable)e);
            }
        });
        try {
            FileUtil.writeToFile((File)this.myTargetStateStorage, (String)this.gson.toJson(targetTypeHashMap));
        }
        catch (IOException e) {
            LOG.warn("Unable to save sources state", (Throwable)e);
        }
        LOG.info("Build target sources report took: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " ms");
    }

    public void clearSourcesState() {
        if (this.reportStateUnavailable()) {
            return;
        }
        if (this.myTargetStateStorage.exists()) {
            LOG.info("Clear build target sources report");
            FileUtil.delete((File)this.myTargetStateStorage);
        }
    }

    @Override
    public void filesGenerated(@NotNull FileGeneratedEvent event) {
        if (this.reportStateUnavailable()) {
            return;
        }
        BuildTarget<?> sourceTarget = event.getSourceTarget();
        String key = sourceTarget.getTargetType().getTypeId() + " " + sourceTarget.getId();
        this.myChangedBuildTargets.put(key, sourceTarget);
    }

    @Override
    public void filesDeleted(@NotNull FileDeletedEvent event) {
        if (this.reportStateUnavailable()) {
            return;
        }
        event.getFilePaths().stream().map(path -> new File(FileUtil.toSystemDependentName((String)path))).map(file -> this.myBuildRootIndex.findAllParentDescriptors((File)file, this.myContext)).flatMap(collection -> collection.stream()).forEach(buildRootDesc -> {
            BuildTarget<?> target = buildRootDesc.getTarget();
            String key = target.getTargetType().getTypeId() + target.getId();
            this.myChangedBuildTargets.put(key, target);
        });
    }

    @NotNull
    private Optional<byte[]> getBuildTargetHash(final @NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        Function<File, List> compilationOutputHashCalculationFunction = rootFile -> {
            try {
                if (!rootFile.exists()) {
                    return null;
                }
                final ArrayList targetRootHashes = new ArrayList();
                Files.walkFileTree(rootFile.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        String filePathString = path.toString();
                        if (filePathString.endsWith(".class")) {
                            byte[] calculatedHash = (byte[])BuildTargetSourcesState.this.myCalculatedHashes.get(filePathString);
                            if (calculatedHash != null) {
                                targetRootHashes.add(calculatedHash);
                            } else {
                                File file = path.toFile();
                                BuildTargetSourcesState.getOutputFileHash(file, rootFile).ifPresent(hash -> {
                                    targetRootHashes.add(hash);
                                    BuildTargetSourcesState.this.myCalculatedHashes.put(filePathString, hash);
                                });
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                return targetRootHashes;
            }
            catch (IOException e) {
                LOG.warn("Couldn't calculate build target hash for : " + target.getPresentableName(), (Throwable)e);
                return null;
            }
        };
        Function<BuildRootDescriptor, List> sourceRootHashCalculationFunction = rootDescriptor -> {
            try {
                final File rootFile = rootDescriptor.getRootFile();
                if (!rootFile.exists() || rootFile.getAbsolutePath().startsWith(this.myOutputFolderPath)) {
                    return null;
                }
                final ArrayList targetRootHashes = new ArrayList();
                Files.walkFileTree(rootFile.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return BuildTargetSourcesState.this.myBuildRootIndex.isDirectoryAccepted(dir.toFile(), rootDescriptor) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        File file = path.toFile();
                        if (!BuildTargetSourcesState.this.myBuildRootIndex.isFileAccepted(file, rootDescriptor)) {
                            return FileVisitResult.CONTINUE;
                        }
                        BuildTargetSourcesState.this.getFileHash(target, file, rootFile).ifPresent(targetRootHashes::add);
                        return FileVisitResult.CONTINUE;
                    }
                });
                return targetRootHashes;
            }
            catch (IOException e) {
                LOG.warn("Couldn't calculate build target hash for : " + target.getPresentableName(), (Throwable)e);
                return null;
            }
        };
        return Stream.concat(target.getOutputRoots(context).stream().map(compilationOutputHashCalculationFunction), this.myBuildRootIndex.getTargetRoots(target, context).stream().map(sourceRootHashCalculationFunction)).filter(it -> !ContainerUtil.isEmpty((Collection)it)).flatMap(Collection::stream).reduce(BuildTargetSourcesState::sum);
    }

    @NotNull
    private Optional<byte[]> getFileHash(@NotNull BuildTarget<?> target, @NotNull File file, @NotNull File rootPath) throws IOException {
        StampsStorage<? extends StampsStorage.Stamp> storage = this.myProjectStamps.getStampStorage();
        assert (storage instanceof FileStampStorage);
        FileStampStorage fileStampStorage = (FileStampStorage)storage;
        byte[] fileHash = fileStampStorage.getStoredFileHash(file, target);
        if (fileHash == null) {
            return Optional.empty();
        }
        byte[] stringHash = MurmurHashingService.getStringHash(BuildTargetSourcesState.toRelative(file, rootPath));
        return Optional.of(BuildTargetSourcesState.sum(stringHash, fileHash));
    }

    @NotNull
    private static Optional<byte[]> getOutputFileHash(@NotNull File file, @NotNull File rootPath) throws IOException {
        byte[] fileHash = MurmurHashingService.getFileHash(file);
        if (fileHash == null) {
            return Optional.empty();
        }
        byte[] stringHash = MurmurHashingService.getStringHash(BuildTargetSourcesState.toRelative(file, rootPath));
        return Optional.of(BuildTargetSourcesState.sum(stringHash, fileHash));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Map<String, Map<String, BuildTargetState>> loadCurrentTargetState() {
        if (!this.myTargetStateStorage.exists()) {
            return new HashMap<String, Map<String, BuildTargetState>>();
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.myTargetStateStorage));){
            Map result = (Map)this.gson.fromJson((Reader)bufferedReader, this.myTokenType);
            if (result == null) return new HashMap<String, Map<String, BuildTargetState>>();
            Map map = result;
            return map;
        }
        catch (IOException e) {
            LOG.warn("Couldn't parse current build target state", (Throwable)e);
        }
        return new HashMap<String, Map<String, BuildTargetState>>();
    }

    private boolean reportStateUnavailable() {
        return !ProjectStamps.PORTABLE_CACHES || this.myProjectStamps == null;
    }

    @NotNull
    private static String toRelative(@NotNull File target, @NotNull File rootPath) {
        return FileUtilRt.toSystemIndependentName((String)Paths.get(rootPath.getPath(), new String[0]).relativize(Paths.get(target.getPath(), new String[0])).toString());
    }

    @NotNull
    private static String getOutputFolderPath(JpsProject project) {
        JpsJavaProjectExtension projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project);
        if (projectExtension == null) {
            return "";
        }
        String url = projectExtension.getOutputUrl();
        if (StringUtil.isEmpty((String)url)) {
            return "";
        }
        return JpsPathUtil.urlToFile((String)url).getAbsolutePath();
    }

    private static byte @NotNull [] sum(byte[] firstHash, byte[] secondHash) {
        byte[] result = firstHash != null ? firstHash : new byte[16];
        for (int i = 0; i < result.length; ++i) {
            int n = i;
            result[n] = (byte)(result[n] + secondHash[i]);
        }
        return result;
    }

    private static final class BuildTargetState {
        private final String hash;
        private final String relativePath;

        private BuildTargetState(String hash, String relativePath) {
            this.hash = hash;
            this.relativePath = relativePath;
        }
    }
}

