/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.storage.BuildTargetStorages;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetRegistry;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingImpl;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class BuildDataManager
implements StorageOwner {
    private static final int VERSION = 39 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final Logger LOG = Logger.getInstance(BuildDataManager.class);
    private static final String SRC_TO_FORM_STORAGE = "src-form";
    private static final String SRC_TO_OUTPUT_STORAGE = "src-out";
    private static final String OUT_TARGET_STORAGE = "out-target";
    private static final String MAPPINGS_STORAGE = "mappings";
    private static final String SRC_TO_OUTPUT_FILE_NAME = "data";
    private final ConcurrentMap<BuildTarget<?>, BuildTargetStorages> myTargetStorages = new ConcurrentHashMap(16, 0.75f, BuildDataManager.getConcurrencyLevel());
    private final OneToManyPathsMapping mySrcToFormMap;
    private final Mappings myMappings;
    private final BuildDataPaths myDataPaths;
    private final BuildTargetsState myTargetsState;
    private final OutputToTargetRegistry myOutputToTargetRegistry;
    private final File myVersionFile;
    private final PathRelativizerService myRelativizer;
    private final StorageOwner myTargetStoragesOwner = new CompositeStorageOwner(){

        @Override
        public void clean() throws IOException {
            try {
                this.close();
            }
            finally {
                FileUtil.delete((File)BuildDataManager.this.myDataPaths.getTargetsDataRoot());
            }
        }

        protected Iterable<BuildTargetStorages> getChildStorages() {
            return () -> BuildDataManager.this.myTargetStorages.values().iterator();
        }
    };
    private final StorageProvider<SourceToOutputMappingImpl> SRC_TO_OUT_MAPPING_PROVIDER = new StorageProvider<SourceToOutputMappingImpl>(){

        @Override
        @NotNull
        public SourceToOutputMappingImpl createStorage(File targetDataDir) throws IOException {
            return this.createStorage(targetDataDir, BuildDataManager.this.myRelativizer);
        }

        @Override
        @NotNull
        public SourceToOutputMappingImpl createStorage(File targetDataDir, PathRelativizerService relativizer) throws IOException {
            return new SourceToOutputMappingImpl(new File(new File(targetDataDir, BuildDataManager.SRC_TO_OUTPUT_STORAGE), BuildDataManager.SRC_TO_OUTPUT_FILE_NAME), relativizer);
        }
    };
    private Boolean myVersionDiffers = null;

    public BuildDataManager(BuildDataPaths dataPaths, BuildTargetsState targetsState, PathRelativizerService relativizer) throws IOException {
        this.myDataPaths = dataPaths;
        this.myTargetsState = targetsState;
        this.mySrcToFormMap = new OneToManyPathsMapping(new File(this.getSourceToFormsRoot(), SRC_TO_OUTPUT_FILE_NAME), relativizer);
        this.myOutputToTargetRegistry = new OutputToTargetRegistry(new File(this.getOutputToSourceRegistryRoot(), SRC_TO_OUTPUT_FILE_NAME), relativizer);
        this.myMappings = new Mappings(BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot()), relativizer);
        this.myVersionFile = new File(this.myDataPaths.getDataStorageRoot(), "version.dat");
        this.myRelativizer = relativizer;
    }

    public BuildTargetsState getTargetsState() {
        return this.myTargetsState;
    }

    public OutputToTargetRegistry getOutputToTargetRegistry() {
        return this.myOutputToTargetRegistry;
    }

    public SourceToOutputMapping getSourceToOutputMap(BuildTarget<?> target) throws IOException {
        SourceToOutputMappingImpl map = this.getStorage(target, this.SRC_TO_OUT_MAPPING_PROVIDER);
        return new SourceToOutputMappingWrapper(map, this.myTargetsState.getBuildTargetId(target));
    }

    public SourceToOutputMappingImpl createSourceToOutputMapForStaleTarget(BuildTargetType<?> targetType, String targetId) throws IOException {
        return new SourceToOutputMappingImpl(new File(this.getSourceToOutputMapRoot(targetType, targetId), SRC_TO_OUTPUT_FILE_NAME), this.myRelativizer);
    }

    @NotNull
    public <S extends StorageOwner> S getStorage(@NotNull BuildTarget<?> target, @NotNull StorageProvider<S> provider) throws IOException {
        BuildTargetStorages targetStorages = this.myTargetStorages.computeIfAbsent(target, t -> new BuildTargetStorages((BuildTarget<?>)t, this.myDataPaths));
        return targetStorages.getOrCreateStorage(provider, this.myRelativizer);
    }

    public OneToManyPathsMapping getSourceToFormMap() {
        return this.mySrcToFormMap;
    }

    public Mappings getMappings() {
        return this.myMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTargetStorages(BuildTarget<?> target) throws IOException {
        try {
            BuildTargetStorages storages = (BuildTargetStorages)this.myTargetStorages.remove(target);
            if (storages != null) {
                storages.close();
            }
        }
        finally {
            File[] targetData = this.myDataPaths.getTargetDataRoot(target).listFiles();
            if (targetData != null) {
                File srcOutputMapRoot = this.getSourceToOutputMapRoot(target);
                for (File dataFile : targetData) {
                    if (FileUtil.filesEqual((File)dataFile, (File)srcOutputMapRoot)) continue;
                    FileUtil.delete((File)dataFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() throws IOException {
        try {
            this.myTargetStoragesOwner.clean();
            this.myTargetStorages.clear();
        }
        finally {
            try {
                BuildDataManager.wipeStorage(this.getSourceToFormsRoot(), this.mySrcToFormMap);
            }
            finally {
                try {
                    BuildDataManager.wipeStorage(this.getOutputToSourceRegistryRoot(), this.myOutputToTargetRegistry);
                }
                finally {
                    Mappings mappings = this.myMappings;
                    if (mappings != null) {
                        Mappings mappings2 = mappings;
                        synchronized (mappings2) {
                            mappings.clean();
                        }
                    } else {
                        FileUtil.delete((File)BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot()));
                    }
                }
            }
            this.myTargetsState.clean();
        }
        this.saveVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean memoryCachesOnly) {
        this.myTargetStoragesOwner.flush(memoryCachesOnly);
        this.myOutputToTargetRegistry.flush(memoryCachesOnly);
        this.mySrcToFormMap.flush(memoryCachesOnly);
        Mappings mappings = this.myMappings;
        if (mappings != null) {
            Mappings mappings2 = mappings;
            synchronized (mappings2) {
                mappings.flush(memoryCachesOnly);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.myTargetsState.save();
            try {
                this.myTargetStoragesOwner.close();
            }
            finally {
                this.myTargetStorages.clear();
            }
        }
        finally {
            try {
                this.myOutputToTargetRegistry.close();
            }
            finally {
                try {
                    BuildDataManager.closeStorage(this.mySrcToFormMap);
                }
                finally {
                    Mappings mappings = this.myMappings;
                    if (mappings != null) {
                        try {
                            mappings.close();
                        }
                        catch (BuildDataCorruptedException e) {
                            throw e.getCause();
                        }
                    }
                }
            }
        }
    }

    public void closeSourceToOutputStorages(Collection<? extends BuildTargetChunk> chunks) throws IOException {
        IOException ex = null;
        for (BuildTargetChunk buildTargetChunk : chunks) {
            for (BuildTarget<?> target : buildTargetChunk.getTargets()) {
                try {
                    BuildTargetStorages targetStorages = (BuildTargetStorages)this.myTargetStorages.get(target);
                    if (targetStorages == null) continue;
                    targetStorages.close(this.SRC_TO_OUT_MAPPING_PROVIDER);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    if (ex != null) continue;
                    ex = e;
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private File getSourceToOutputMapRoot(BuildTarget<?> target) {
        return new File(this.myDataPaths.getTargetDataRoot(target), SRC_TO_OUTPUT_STORAGE);
    }

    private File getSourceToOutputMapRoot(BuildTargetType<?> targetType, String targetId) {
        return new File(this.myDataPaths.getTargetDataRoot(targetType, targetId), SRC_TO_OUTPUT_STORAGE);
    }

    private File getSourceToFormsRoot() {
        return new File(this.myDataPaths.getDataStorageRoot(), SRC_TO_FORM_STORAGE);
    }

    private File getOutputToSourceRegistryRoot() {
        return new File(this.myDataPaths.getDataStorageRoot(), OUT_TARGET_STORAGE);
    }

    public BuildDataPaths getDataPaths() {
        return this.myDataPaths;
    }

    public PathRelativizerService getRelativizer() {
        return this.myRelativizer;
    }

    public static File getMappingsRoot(File dataStorageRoot) {
        return new File(dataStorageRoot, MAPPINGS_STORAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wipeStorage(File root, @Nullable AbstractStateStorage<?, ?> storage) {
        if (storage != null) {
            AbstractStateStorage<?, ?> abstractStateStorage = storage;
            synchronized (abstractStateStorage) {
                storage.wipe();
            }
        } else {
            FileUtil.delete((File)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeStorage(@Nullable AbstractStateStorage<?, ?> storage) throws IOException {
        if (storage != null) {
            AbstractStateStorage<?, ?> abstractStateStorage = storage;
            synchronized (abstractStateStorage) {
                storage.close();
            }
        }
    }

    public boolean versionDiffers() {
        boolean bl;
        Boolean cached = this.myVersionDiffers;
        if (cached != null) {
            return cached;
        }
        DataInputStream is = new DataInputStream(new FileInputStream(this.myVersionFile));
        try {
            boolean diff = is.readInt() != VERSION;
            this.myVersionDiffers = diff;
            bl = diff;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ignored) {
                return false;
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
                return true;
            }
        }
        is.close();
        return bl;
    }

    public void saveVersion() {
        Boolean differs = this.myVersionDiffers;
        if (differs == null || differs.booleanValue()) {
            FileUtil.createIfDoesntExist((File)this.myVersionFile);
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(this.myVersionFile));){
                os.writeInt(VERSION);
                this.myVersionDiffers = Boolean.FALSE;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reportUnhandledRelativizerPaths() {
        this.myRelativizer.reportUnhandledPaths();
    }

    public static int getConcurrencyLevel() {
        return BuildRunner.isParallelBuildEnabled() ? IncProjectBuilder.MAX_BUILDER_THREADS : 1;
    }

    private final class SourceToOutputMappingWrapper
    implements SourceToOutputMapping {
        private final SourceToOutputMapping myDelegate;
        private final int myBuildTargetId;

        SourceToOutputMappingWrapper(SourceToOutputMapping delegate, int buildTargetId) {
            this.myDelegate = delegate;
            this.myBuildTargetId = buildTargetId;
        }

        @Override
        public void setOutputs(@NotNull String srcPath, @NotNull Collection<String> outputs) throws IOException {
            try {
                this.myDelegate.setOutputs(srcPath, outputs);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputs, this.myBuildTargetId);
            }
        }

        @Override
        public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            try {
                this.myDelegate.setOutput(srcPath, outputPath);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            try {
                this.myDelegate.appendOutput(srcPath, outputPath);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void remove(@NotNull String srcPath) throws IOException {
            this.myDelegate.remove(srcPath);
        }

        @Override
        public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) throws IOException {
            this.myDelegate.removeOutput(sourcePath, outputPath);
        }

        @Override
        @NotNull
        public Collection<String> getSources() throws IOException {
            return this.myDelegate.getSources();
        }

        @Override
        @Nullable
        public Collection<String> getOutputs(@NotNull String srcPath) throws IOException {
            return this.myDelegate.getOutputs(srcPath);
        }

        @Override
        @NotNull
        public Iterator<String> getOutputsIterator(@NotNull String srcPath) throws IOException {
            return this.myDelegate.getOutputsIterator(srcPath);
        }

        @Override
        @NotNull
        public Iterator<String> getSourcesIterator() throws IOException {
            return this.myDelegate.getSourcesIterator();
        }
    }
}

