/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.incremental.relativizer.CommonPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.GradlePathRelativizer;
import org.jetbrains.jps.incremental.relativizer.JavaSdkPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.MavenPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.PathRelativizer;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.util.JpsPathUtil;

public class PathRelativizerService {
    private static final Logger LOG = Logger.getInstance(PathRelativizerService.class);
    private static final String PROJECT_DIR_IDENTIFIER = "$PROJECT_DIR$";
    private static final String BUILD_DIR_IDENTIFIER = "$BUILD_DIR$";
    private final List<PathRelativizer> myRelativizers = new SmartList();
    private final Set<String> myUnhandledPaths = Collections.synchronizedSet(new LinkedHashSet());

    public PathRelativizerService(@Nullable String projectPath) {
        this.initialize(projectPath, null, null);
    }

    public PathRelativizerService(@NotNull JpsProject project) {
        File projectBaseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsProject)project);
        Set javaSdks = project.getModules().stream().map(module -> module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE)).filter(sdk -> sdk != null && sdk.getVersionString() != null && sdk.getHomePath() != null).collect(Collectors.toSet());
        this.initialize(projectBaseDirectory != null ? projectBaseDirectory.getAbsolutePath() : null, PathRelativizerService.getBuildDirPath(project), javaSdks);
    }

    @TestOnly
    public PathRelativizerService() {
        this.initialize(null, null, null);
    }

    private void initialize(@Nullable String projectPath, @Nullable String buildDirPath, @Nullable Set<? extends JpsSdk<?>> javaSdks) {
        String normalizedProjectPath = projectPath != null ? PathRelativizerService.normalizePath(projectPath) : null;
        String normalizedBuildDirPath = buildDirPath != null ? PathRelativizerService.normalizePath(buildDirPath) : null;
        this.myRelativizers.add(new CommonPathRelativizer(normalizedBuildDirPath, BUILD_DIR_IDENTIFIER));
        this.myRelativizers.add(new CommonPathRelativizer(normalizedProjectPath, PROJECT_DIR_IDENTIFIER));
        this.myRelativizers.add(new JavaSdkPathRelativizer(javaSdks));
        this.myRelativizers.add(new MavenPathRelativizer());
        this.myRelativizers.add(new GradlePathRelativizer());
    }

    @NotNull
    public String toRelative(@NotNull String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        for (PathRelativizer relativizer : this.myRelativizers) {
            String relativePath = relativizer.toRelativePath(systemIndependentPath);
            if (relativePath == null) continue;
            return relativePath;
        }
        if (LOG.isDebugEnabled()) {
            this.myUnhandledPaths.add(path);
        }
        return systemIndependentPath;
    }

    @NotNull
    public String toFull(@NotNull String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        for (PathRelativizer relativizer : this.myRelativizers) {
            String fullPath = relativizer.toAbsolutePath(systemIndependentPath);
            if (fullPath == null) continue;
            return fullPath;
        }
        return systemIndependentPath;
    }

    public void reportUnhandledPaths() {
        if (LOG.isDebugEnabled()) {
            StringBuilder logBuilder = new StringBuilder();
            this.myUnhandledPaths.forEach(it -> logBuilder.append((String)it).append("\n"));
            LOG.debug("Unhandled by relativizer paths:\n" + logBuilder);
            this.myUnhandledPaths.clear();
        }
    }

    @NotNull
    static String normalizePath(@NotNull String path) {
        return StringUtil.trimTrailing((String)FileUtil.toSystemIndependentName((String)path), (char)'/');
    }

    @Nullable
    private static String getBuildDirPath(@NotNull JpsProject project) {
        JpsJavaProjectExtension projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project);
        if (projectExtension == null) {
            return null;
        }
        String url = projectExtension.getOutputUrl();
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        return JpsPathUtil.urlToFile((String)url).getAbsolutePath();
    }
}

