/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizer;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.model.library.sdk.JpsSdk;

class JavaSdkPathRelativizer
implements PathRelativizer {
    @Nullable
    private Map<String, String> myJavaSdkPathMap;

    JavaSdkPathRelativizer(@Nullable Set<? extends JpsSdk<?>> javaSdks) {
        if (javaSdks != null) {
            this.myJavaSdkPathMap = javaSdks.stream().collect(Collectors.toMap(sdk -> {
                JavaVersion version = JavaVersion.tryParse((String)sdk.getVersionString());
                return "$JDK_" + (version != null ? version.toString() : "0") + "$";
            }, sdk -> PathRelativizerService.normalizePath(sdk.getHomePath()), (sdk1, sdk2) -> sdk1));
        }
    }

    @Override
    @Nullable
    public String toRelativePath(@NotNull String path) {
        if (this.myJavaSdkPathMap == null || this.myJavaSdkPathMap.isEmpty()) {
            return null;
        }
        Optional<Map.Entry> optionalEntry = this.myJavaSdkPathMap.entrySet().stream().filter(entry -> FileUtil.startsWith((String)path, (String)((String)entry.getValue()))).findFirst();
        if (!optionalEntry.isPresent()) {
            return null;
        }
        Map.Entry javaSdkEntry = optionalEntry.get();
        return (String)javaSdkEntry.getKey() + path.substring(((String)javaSdkEntry.getValue()).length());
    }

    @Override
    @Nullable
    public String toAbsolutePath(@NotNull String path) {
        if (this.myJavaSdkPathMap == null || this.myJavaSdkPathMap.isEmpty()) {
            return null;
        }
        Optional<Map.Entry> optionalEntry = this.myJavaSdkPathMap.entrySet().stream().filter(it -> path.startsWith((String)it.getKey())).findFirst();
        if (!optionalEntry.isPresent()) {
            return null;
        }
        Map.Entry javaSdkEntry = optionalEntry.get();
        return (String)javaSdkEntry.getValue() + path.substring(((String)javaSdkEntry.getKey()).length());
    }
}

