/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class FileGeneratedEvent
extends BuildMessage {
    private static final Logger LOG = Logger.getInstance(FileGeneratedEvent.class);
    private final Collection<Pair<String, String>> myPaths = new ArrayList<Pair<String, String>>();
    private final BuildTarget<?> mySourceTarget;

    public FileGeneratedEvent(@NotNull BuildTarget<?> sourceTarget) {
        super("", BuildMessage.Kind.INFO);
        this.mySourceTarget = sourceTarget;
    }

    @NotNull
    public BuildTarget<?> getSourceTarget() {
        return this.mySourceTarget;
    }

    public void add(String root, String relativePath) {
        if (root != null && relativePath != null) {
            this.myPaths.add((Pair<String, String>)Pair.create((Object)FileUtil.toSystemIndependentName((String)root), (Object)FileUtil.toSystemIndependentName((String)relativePath)));
        } else {
            LOG.info("Invalid file generation event: root=" + root + "; relativePath=" + relativePath);
        }
    }

    @NotNull
    public Collection<Pair<String, String>> getPaths() {
        return Collections.unmodifiableCollection(this.myPaths);
    }
}

