/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class BuilderStatisticsMessage
extends BuildMessage {
    private final String myBuilderName;
    private final int myNumberOfProcessedSources;
    private final long myElapsedTimeMs;

    public BuilderStatisticsMessage(@Nls String builderName, int numberOfProcessedSources, long elapsedTimeMs) {
        super(BuilderStatisticsMessage.createText(builderName, numberOfProcessedSources, elapsedTimeMs), BuildMessage.Kind.INFO);
        this.myBuilderName = builderName;
        this.myNumberOfProcessedSources = numberOfProcessedSources;
        this.myElapsedTimeMs = elapsedTimeMs;
    }

    @NotNull
    private static String createText(String builderName, int srcCount, long time) {
        return "Build duration: Builder '" + StringUtil.capitalize((String)builderName) + "' took " + Utils.formatDuration(time) + "; " + srcCount + " sources processed" + (srcCount == 0 ? "" : " (" + time / (long)srcCount + " ms per file)");
    }

    public String getBuilderName() {
        return this.myBuilderName;
    }

    public int getNumberOfProcessedSources() {
        return this.myNumberOfProcessedSources;
    }

    public long getElapsedTimeMs() {
        return this.myElapsedTimeMs;
    }
}

