/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.OutboundSemiGraph;
import com.intellij.util.io.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.IncArtifactBuilder;
import org.jetbrains.jps.incremental.artifacts.impl.DependentJarsEvaluator;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.JarBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public final class JarsBuilder {
    private static final Logger LOG = Logger.getInstance(JarsBuilder.class);
    private final Set<JarInfo> myJarsToBuild;
    private final CompileContext myContext;
    private Map<JarInfo, File> myBuiltJars;
    private final BuildOutputConsumer myOutputConsumer;
    private final ArtifactOutputToSourceMapping myOutSrcMapping;
    @Nullable
    private final Long buildDateInMillis;

    public JarsBuilder(Set<JarInfo> jarsToBuild, CompileContext context, BuildOutputConsumer outputConsumer, ArtifactOutputToSourceMapping outSrcMapping) {
        this.myOutputConsumer = outputConsumer;
        this.myOutSrcMapping = outSrcMapping;
        DependentJarsEvaluator evaluator = new DependentJarsEvaluator();
        for (JarInfo jarInfo : jarsToBuild) {
            evaluator.addJarWithDependencies(jarInfo);
        }
        this.myJarsToBuild = evaluator.getJars();
        this.myContext = context;
        String buildDateInSeconds = context.getBuilderParameter("SOURCE_DATE_EPOCH");
        if (buildDateInSeconds == null) {
            buildDateInSeconds = System.getenv("SOURCE_DATE_EPOCH");
        }
        this.buildDateInMillis = buildDateInSeconds != null ? Long.valueOf(Long.parseLong(buildDateInSeconds) * 1000L) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildJars() throws IOException, ProjectBuildException {
        this.myContext.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.building.archives", new Object[0])));
        JarInfo[] sortedJars = this.sortJars();
        if (sortedJars == null) {
            return false;
        }
        this.myBuiltJars = new HashMap<JarInfo, File>();
        try {
            for (JarInfo jar : sortedJars) {
                this.myContext.checkCanceled();
                this.buildJar(jar);
            }
            this.myContext.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.copying.archives", new Object[0])));
            this.copyJars();
        }
        finally {
            this.deleteTemporaryJars();
        }
        return true;
    }

    private void deleteTemporaryJars() {
        for (File file : this.myBuiltJars.values()) {
            FileUtil.delete((File)file);
        }
    }

    private void copyJars() throws IOException {
        for (Map.Entry<JarInfo, File> entry : this.myBuiltJars.entrySet()) {
            File fromFile = entry.getValue();
            JarInfo jarInfo = entry.getKey();
            DestinationInfo destination = jarInfo.getDestination();
            if (!(destination instanceof ExplodedDestinationInfo)) continue;
            File toFile = new File(FileUtil.toSystemDependentName((String)destination.getOutputPath()));
            FileUtil.rename((File)fromFile, (File)toFile);
        }
    }

    private JarInfo @Nullable [] sortJars() {
        DFSTBuilder builder = new DFSTBuilder((OutboundSemiGraph)GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new JarsGraph())));
        if (!builder.isAcyclic()) {
            Map.Entry dependency = builder.getCircularDependency();
            String message = JpsBuildBundle.message("build.message.cannot.build.circular.dependency.found.between.0.and.1", ((JarInfo)dependency.getKey()).getPresentableDestination(), ((JarInfo)dependency.getValue()).getPresentableDestination());
            this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, message));
            return null;
        }
        Object[] jars = this.myJarsToBuild.toArray(new JarInfo[0]);
        Arrays.sort(jars, builder.comparator());
        jars = (JarInfo[])ArrayUtil.reverseArray((Object[])jars);
        return jars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildJar(JarInfo jar) throws IOException {
        block41: {
            String messageText4;
            JarOutputStream jarOutputStream;
            BufferedOutputStream outputStream;
            File jarFile;
            block39: {
                HashSet writtenPaths;
                ArrayList<String> packedFilePaths;
                String targetJarPath;
                block37: {
                    block40: {
                        block38: {
                            Manifest manifest;
                            String emptyArchiveMessage = JpsBuildBundle.message("build.message.archive.0.doesn.t.contain.files.so.it.won.t.be.created", jar.getPresentableDestination());
                            if (jar.getContent().isEmpty()) {
                                this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.WARNING, emptyArchiveMessage));
                                return;
                            }
                            this.myContext.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.building.jar.0", jar.getPresentableDestination())));
                            jarFile = FileUtil.createTempFile((String)"artifactCompiler", (String)"tmp");
                            this.myBuiltJars.put(jar, jarFile);
                            FileUtil.createParentDirs((File)jarFile);
                            targetJarPath = jar.getDestination().getOutputFilePath();
                            packedFilePaths = new ArrayList<String>();
                            Pair<Manifest, File> manifestData = this.loadManifest(jar, packedFilePaths);
                            Manifest manifest2 = manifest = manifestData != null ? (Manifest)manifestData.first : null;
                            if (manifest != null && manifest.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION) == null && manifest.getMainAttributes().getValue(Attributes.Name.SIGNATURE_VERSION) == null && !manifest.getMainAttributes().isEmpty()) {
                                String messageText2 = JpsBuildBundle.message("build.message.manifest.file.0.included.into.archive.does.not.contain.required.attribute", manifestData.second, jar.getPresentableDestination(), Attributes.Name.MANIFEST_VERSION);
                                this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.WARNING, messageText2));
                            }
                            outputStream = new BufferedOutputStream(new FileOutputStream(jarFile));
                            jarOutputStream = new JarOutputStream(outputStream);
                            writtenPaths = new HashSet();
                            try {
                                if (manifest != null) {
                                    this.addManifestEntry(jarOutputStream, manifest, writtenPaths);
                                }
                                for (Pair<String, Object> pair : jar.getContent()) {
                                    String relativePath = (String)pair.getFirst();
                                    if (pair.getSecond() instanceof ArtifactRootDescriptor) {
                                        ArtifactRootDescriptor descriptor = (ArtifactRootDescriptor)pair.getSecond();
                                        int rootIndex = descriptor.getRootIndex();
                                        if (descriptor instanceof FileBasedArtifactRootDescriptor) {
                                            this.addFileToJar(jarOutputStream, jarFile, descriptor.getRootFile(), descriptor.getFilter(), relativePath, targetJarPath, writtenPaths, packedFilePaths, rootIndex);
                                            continue;
                                        }
                                        String filePath = FileUtil.toSystemIndependentName((String)descriptor.getRootFile().getAbsolutePath());
                                        packedFilePaths.add(filePath);
                                        this.myOutSrcMapping.appendData(targetJarPath, rootIndex, filePath);
                                        this.extractFileAndAddToJar(jarOutputStream, (JarBasedArtifactRootDescriptor)descriptor, relativePath, writtenPaths);
                                        continue;
                                    }
                                    JarInfo nestedJar = (JarInfo)pair.getSecond();
                                    File nestedJarFile = this.myBuiltJars.get(nestedJar);
                                    if (nestedJarFile != null) {
                                        this.addFileToJar(jarOutputStream, jarFile, nestedJarFile, SourceFileFilter.ALL, relativePath, targetJarPath, writtenPaths, packedFilePaths, -1);
                                        continue;
                                    }
                                    LOG.debug("nested JAR file " + relativePath + " for " + jar.getPresentableDestination() + " not found");
                                }
                                if (!writtenPaths.isEmpty()) break block37;
                                this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.WARNING, emptyArchiveMessage));
                                if (!writtenPaths.isEmpty()) break block38;
                            }
                            catch (Throwable throwable) {
                                if (writtenPaths.isEmpty()) {
                                    try {
                                        jarOutputStream.close();
                                    }
                                    catch (IOException ignored) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    FileUtil.delete((File)jarFile);
                                    this.myBuiltJars.remove(jar);
                                } else {
                                    try {
                                        jarOutputStream.close();
                                    }
                                    catch (IOException e) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        FileUtil.delete((File)jarFile);
                                        String messageText3 = JpsBuildBundle.message("build.message.cannot.create.0.1", jar.getPresentableDestination(), e.getMessage());
                                        this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, messageText3));
                                        LOG.debug((Throwable)e);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                jarOutputStream.close();
                            }
                            catch (IOException ignored) {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException pair) {
                                    // empty catch block
                                }
                            }
                            FileUtil.delete((File)jarFile);
                            this.myBuiltJars.remove(jar);
                            break block40;
                        }
                        try {
                            jarOutputStream.close();
                        }
                        catch (IOException e) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException pair) {
                                // empty catch block
                            }
                            FileUtil.delete((File)jarFile);
                            messageText4 = JpsBuildBundle.message("build.message.cannot.create.0.1", jar.getPresentableDestination(), e.getMessage());
                            this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, messageText4));
                            LOG.debug((Throwable)e);
                        }
                    }
                    return;
                }
                ProjectBuilderLogger logger = this.myContext.getLoggingManager().getProjectBuilderLogger();
                if (logger.isEnabled()) {
                    logger.logCompiledPaths(packedFilePaths, "artifacts-builder", "Packing files:");
                }
                this.myOutputConsumer.registerOutputFile(new File(targetJarPath), packedFilePaths);
                if (!writtenPaths.isEmpty()) break block39;
                try {
                    jarOutputStream.close();
                }
                catch (IOException ignored) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException messageText4) {
                        // empty catch block
                    }
                }
                FileUtil.delete((File)jarFile);
                this.myBuiltJars.remove(jar);
                break block41;
            }
            try {
                jarOutputStream.close();
            }
            catch (IOException e) {
                try {
                    outputStream.close();
                }
                catch (IOException messageText4) {
                    // empty catch block
                }
                FileUtil.delete((File)jarFile);
                messageText4 = JpsBuildBundle.message("build.message.cannot.create.0.1", jar.getPresentableDestination(), e.getMessage());
                this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, messageText4));
                LOG.debug((Throwable)e);
            }
        }
    }

    @Nullable
    private Pair<Manifest, File> loadManifest(JarInfo jar, List<? super String> packedFilePaths) throws IOException {
        for (Pair<String, Object> pair : jar.getContent()) {
            String rootPath;
            if (!(pair.getSecond() instanceof ArtifactRootDescriptor) || !"META-INF/MANIFEST.MF".startsWith(rootPath = (String)pair.getFirst())) continue;
            final String manifestPath = JpsArtifactPathUtil.trimForwardSlashes("META-INF/MANIFEST.MF".substring(rootPath.length()));
            final ArtifactRootDescriptor descriptor = (ArtifactRootDescriptor)pair.getSecond();
            if (descriptor instanceof FileBasedArtifactRootDescriptor) {
                File manifestFile = new File(descriptor.getRootFile(), manifestPath);
                if (!manifestFile.exists()) continue;
                String fullManifestPath = FileUtil.toSystemIndependentName((String)manifestFile.getAbsolutePath());
                packedFilePaths.add(fullManifestPath);
                try (FileInputStream stream = new FileInputStream(manifestFile);){
                    Pair pair2 = new Pair((Object)this.createManifest(stream, manifestFile), (Object)manifestFile);
                    return pair2;
                }
            }
            final Ref manifestRef = Ref.create(null);
            ((JarBasedArtifactRootDescriptor)descriptor).processEntries(new JarBasedArtifactRootDescriptor.EntryProcessor(){

                @Override
                public void process(@Nullable InputStream inputStream, @NotNull String relativePath, ZipEntry entry) throws IOException {
                    if (manifestRef.isNull() && relativePath.equals(manifestPath) && inputStream != null) {
                        try (InputStream stream = inputStream;){
                            manifestRef.set((Object)JarsBuilder.this.createManifest(stream, descriptor.getRootFile()));
                        }
                    }
                }
            });
            if (manifestRef.isNull()) continue;
            return new Pair((Object)((Manifest)manifestRef.get()), (Object)descriptor.getRootFile());
        }
        return null;
    }

    @Nullable
    private Manifest createManifest(InputStream manifestStream, File manifestFile) {
        try {
            return new Manifest(manifestStream);
        }
        catch (IOException e) {
            this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, JpsBuildBundle.message("build.message.cannot.create.manifest.mf.from.0.1", manifestFile.getAbsolutePath(), e.getMessage())));
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private void extractFileAndAddToJar(final JarOutputStream jarOutputStream, final JarBasedArtifactRootDescriptor root, final String relativeOutputPath, final Set<? super String> writtenPaths) throws IOException {
        final long timestamp = this.buildDateInMillis != null ? this.buildDateInMillis : FSOperations.lastModified(root.getRootFile());
        root.processEntries(new JarBasedArtifactRootDescriptor.EntryProcessor(){

            @Override
            public void process(@Nullable InputStream inputStream, @NotNull String relativePath, ZipEntry entry) throws IOException {
                String pathInJar = JarsBuilder.this.addParentDirectories(jarOutputStream, writtenPaths, JpsArtifactPathUtil.appendToPath(relativeOutputPath, relativePath));
                if (inputStream == null) {
                    if (!pathInJar.endsWith("/")) {
                        JarsBuilder.this.addDirectoryEntry(jarOutputStream, pathInJar + "/", writtenPaths);
                    }
                } else if (writtenPaths.add(pathInJar)) {
                    ZipEntry newEntry = new ZipEntry(pathInJar);
                    newEntry.setTime(timestamp);
                    if (entry.getMethod() == 0) {
                        newEntry.setMethod(0);
                        newEntry.setSize(entry.getSize());
                        newEntry.setCrc(entry.getCrc());
                    }
                    jarOutputStream.putNextEntry(newEntry);
                    FileUtil.copy((InputStream)inputStream, (OutputStream)jarOutputStream);
                    try {
                        jarOutputStream.closeEntry();
                    }
                    catch (IOException e) {
                        String messageText = JpsBuildBundle.message("build.message.cannot.extract.0.from.1.while.building.2.artifact.3", pathInJar, root.getRootFile().getAbsolutePath(), root.getTarget().getArtifact().getName(), e.getMessage());
                        JarsBuilder.this.myContext.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, messageText));
                        LOG.debug((Throwable)e);
                    }
                }
            }
        });
    }

    private void addFileToJar(@NotNull JarOutputStream jarOutputStream, @NotNull File jarFile, @NotNull File file, SourceFileFilter filter, @NotNull String relativePath, String targetJarPath, @NotNull Set<? super String> writtenPaths, List<? super String> packedFilePaths, int rootIndex) throws IOException {
        if (!file.exists() || FileUtil.isAncestor((File)file, (File)jarFile, (boolean)false)) {
            return;
        }
        relativePath = this.addParentDirectories(jarOutputStream, writtenPaths, relativePath);
        this.addFileOrDirRecursively(jarOutputStream, file, filter, relativePath, targetJarPath, writtenPaths, packedFilePaths, rootIndex);
    }

    private void addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @NotNull File file, SourceFileFilter filter, @NotNull String relativePath, String targetJarPath, @NotNull Set<? super String> writtenItemRelativePaths, List<? super String> packedFilePaths, int rootIndex) throws IOException {
        String filePath = FileUtil.toSystemIndependentName((String)file.getAbsolutePath());
        if (!filter.accept(filePath) || !filter.shouldBeCopied(filePath, this.myContext.getProjectDescriptor())) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            String directoryPath;
            String string = directoryPath = relativePath.length() == 0 ? "" : relativePath + "/";
            if (!directoryPath.isEmpty()) {
                this.addDirectoryEntry(jarOutputStream, directoryPath, writtenItemRelativePaths);
            }
            if ((children = file.listFiles()) != null) {
                for (File child : children) {
                    this.addFileOrDirRecursively(jarOutputStream, child, filter, directoryPath + child.getName(), targetJarPath, writtenItemRelativePaths, packedFilePaths, rootIndex);
                }
            }
            return;
        }
        boolean added = ZipUtil.addFileToZip((ZipOutputStream)jarOutputStream, (File)file, (String)relativePath, writtenItemRelativePaths, null);
        if (rootIndex != -1) {
            this.myOutSrcMapping.appendData(targetJarPath, rootIndex, filePath);
            if (added) {
                packedFilePaths.add(filePath);
            }
        }
    }

    private String addParentDirectories(JarOutputStream jarOutputStream, Set<? super String> writtenPaths, String relativePath) throws IOException {
        while (StringUtil.startsWithChar((CharSequence)relativePath, (char)'/')) {
            relativePath = relativePath.substring(1);
        }
        int i = relativePath.indexOf(47);
        while (i != -1) {
            String prefix = relativePath.substring(0, i + 1);
            if (prefix.length() > 1) {
                this.addDirectoryEntry(jarOutputStream, prefix, writtenPaths);
            }
            i = relativePath.indexOf(47, i + 1);
        }
        return relativePath;
    }

    private void addDirectoryEntry(ZipOutputStream output, @NonNls String relativePath, Set<? super String> writtenPaths) throws IOException {
        if (!writtenPaths.add(relativePath)) {
            return;
        }
        ZipEntry e = new ZipEntry(relativePath);
        if (this.buildDateInMillis != null) {
            e.setTime(this.buildDateInMillis);
        }
        e.setMethod(0);
        e.setSize(0L);
        e.setCrc(0L);
        output.putNextEntry(e);
        output.closeEntry();
    }

    private void addManifestEntry(ZipOutputStream output, Manifest manifest, Set<? super String> writtenPaths) throws IOException {
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        if (this.buildDateInMillis != null) {
            manifestEntry.setTime(this.buildDateInMillis);
        }
        output.putNextEntry(manifestEntry);
        manifest.write(new BufferedOutputStream(output));
        output.closeEntry();
        writtenPaths.add("META-INF/MANIFEST.MF");
    }

    private class JarsGraph
    implements InboundSemiGraph<JarInfo> {
        private JarsGraph() {
        }

        @NotNull
        public Collection<JarInfo> getNodes() {
            return JarsBuilder.this.myJarsToBuild;
        }

        @NotNull
        public Iterator<JarInfo> getIn(JarInfo n) {
            HashSet<JarInfo> ins = new HashSet<JarInfo>();
            DestinationInfo destination = n.getDestination();
            if (destination instanceof JarDestinationInfo) {
                ins.add(((JarDestinationInfo)destination).getJarInfo());
            }
            return ins.iterator();
        }
    }
}

