/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactBasedBuildTarget;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;

public abstract class ArtifactBasedBuildTargetType<T extends ArtifactBasedBuildTarget>
extends BuildTargetType<T> {
    protected ArtifactBasedBuildTargetType(String typeId, boolean fileBased) {
        super(typeId, fileBased);
    }

    @Override
    @NotNull
    public List<T> computeAllTargets(@NotNull JpsModel model) {
        Collection<JpsArtifact> artifacts = JpsBuilderArtifactService.getInstance().getArtifacts(model, true);
        ArrayList<T> targets = new ArrayList<T>(artifacts.size());
        for (JpsArtifact artifact : artifacts) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            targets.add(this.createArtifactBasedTarget(artifact));
        }
        return targets;
    }

    @Override
    @NotNull
    public BuildTargetLoader<T> createLoader(@NotNull JpsModel model) {
        return new Loader(model);
    }

    protected abstract T createArtifactBasedTarget(JpsArtifact var1);

    private class Loader
    extends BuildTargetLoader<T> {
        private final Map<String, JpsArtifact> myArtifacts = new HashMap<String, JpsArtifact>();

        Loader(JpsModel model) {
            for (JpsArtifact artifact : JpsBuilderArtifactService.getInstance().getArtifacts(model, true)) {
                this.myArtifacts.put(artifact.getName(), artifact);
            }
        }

        @Override
        @Nullable
        public T createTarget(@NotNull String targetId) {
            JpsArtifact artifact = this.myArtifacts.get(targetId);
            return artifact != null ? (Object)ArtifactBasedBuildTargetType.this.createArtifactBasedTarget(artifact) : null;
        }
    }
}

