/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.ExcludedJavaSourceRootProvider;
import org.jetbrains.jps.builders.java.FilteredResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.JVMModuleBuildTarget;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.service.JpsServiceManager;

public final class ResourcesTarget
extends JVMModuleBuildTarget<ResourceRootDescriptor> {
    private final ResourcesTargetType myTargetType;

    public ResourcesTarget(@NotNull JpsModule module, ResourcesTargetType targetType) {
        super(targetType, module);
        this.myTargetType = targetType;
    }

    @Nullable
    public File getOutputDir() {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, this.myTargetType.isTests());
    }

    @Override
    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        return ContainerUtil.createMaybeSingletonList((Object)this.getOutputDir());
    }

    @Override
    public boolean isTests() {
        return this.myTargetType.isTests();
    }

    @Override
    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    @Override
    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<ResourceRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File rootFile;
        ArrayList<ResourceRootDescriptor> roots = new ArrayList<ResourceRootDescriptor>();
        JavaSourceRootType type = this.isTests() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        Iterable excludedRootProviders = JpsServiceManager.getInstance().getExtensions(ExcludedJavaSourceRootProvider.class);
        FileFilter filterForExcludedPatterns = index.getModuleFileFilterHonorExclusionPatterns(this.myModule);
        for (JpsTypedModuleSourceRoot sourceRoot : this.myModule.getSourceRoots((JpsModuleSourceRootType)type)) {
            if (this.isExcludedFromCompilation(excludedRootProviders, (JpsModuleSourceRoot)sourceRoot)) continue;
            String packagePrefix = ((JavaSourceRootProperties)sourceRoot.getProperties()).getPackagePrefix();
            rootFile = sourceRoot.getFile();
            roots.add(new FilteredResourceRootDescriptor(rootFile, this, packagePrefix, this.computeRootExcludes(rootFile, index), filterForExcludedPatterns));
        }
        JavaResourceRootType resourceType = this.isTests() ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
        for (JpsTypedModuleSourceRoot root : this.myModule.getSourceRoots((JpsModuleSourceRootType)resourceType)) {
            if (this.isExcludedFromCompilation(excludedRootProviders, (JpsModuleSourceRoot)root)) continue;
            rootFile = root.getFile();
            String relativeOutputPath = ((JavaResourceRootProperties)root.getProperties()).getRelativeOutputPath();
            roots.add(new ResourceRootDescriptor(rootFile, this, relativeOutputPath.replace('/', '.'), this.computeRootExcludes(rootFile, index), filterForExcludedPatterns));
        }
        return roots;
    }

    private boolean isExcludedFromCompilation(Iterable<ExcludedJavaSourceRootProvider> excludedRootProviders, JpsModuleSourceRoot sourceRoot) {
        for (ExcludedJavaSourceRootProvider provider : excludedRootProviders) {
            if (!provider.isExcludedFromCompilation(this.myModule, sourceRoot)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "Resources for '" + this.getModule().getName() + "' " + (this.myTargetType.isTests() ? "tests" : "production");
    }

    @Override
    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        int fingerprint = 0;
        BuildRootIndex rootIndex = pd.getBuildRootIndex();
        PathRelativizerService relativizer = pd.dataManager.getRelativizer();
        List<ResourceRootDescriptor> roots = rootIndex.getTargetRoots(this, null);
        for (ResourceRootDescriptor root : roots) {
            String path = relativizer.toRelative(root.getRootFile().getAbsolutePath());
            fingerprint += ResourcesTarget.pathHashCode(path);
            fingerprint += root.getPackagePrefix().hashCode();
        }
        out.write(Integer.toHexString(fingerprint));
    }

    private static int pathHashCode(@Nullable String path) {
        if (ProjectStamps.PORTABLE_CACHES) {
            return StringUtil.isEmpty((String)path) ? 0 : FileUtil.toCanonicalPath((String)path).hashCode();
        }
        return FileUtil.pathHashCode((String)path);
    }
}

