/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;

public class CompiledClass
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance(CompiledClass.class);
    @NotNull
    private final File myOutputFile;
    @NotNull
    private final Collection<File> mySourceFiles;
    @Nullable
    private final String myClassName;
    @NotNull
    private BinaryContent myContent;
    private boolean myIsDirty = false;

    public CompiledClass(@NotNull File outputFile, @NotNull Collection<File> sourceFiles, @Nullable String className, @NotNull BinaryContent content) {
        this.myOutputFile = outputFile;
        this.mySourceFiles = sourceFiles;
        this.myClassName = className;
        this.myContent = content;
        LOG.assertTrue(!this.mySourceFiles.isEmpty());
    }

    public CompiledClass(@NotNull File outputFile, @NotNull File sourceFile, @Nullable String className, @NotNull BinaryContent content) {
        this(outputFile, Collections.singleton(sourceFile), className, content);
    }

    public void save() throws IOException {
        this.myContent.saveToFile(this.myOutputFile);
        this.myIsDirty = false;
    }

    @NotNull
    public File getOutputFile() {
        return this.myOutputFile;
    }

    @NotNull
    public Collection<File> getSourceFiles() {
        return this.mySourceFiles;
    }

    @NotNull
    public List<String> getSourceFilesPaths() {
        return ContainerUtil.map(this.mySourceFiles, file -> file.getPath());
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public BinaryContent getContent() {
        return this.myContent;
    }

    public void setContent(@NotNull BinaryContent content) {
        this.myContent = content;
        this.myIsDirty = true;
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CompiledClass aClass = (CompiledClass)((Object)o);
        return FileUtil.filesEqual((File)this.myOutputFile, (File)aClass.myOutputFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myOutputFile);
    }

    public String toString() {
        return "CompiledClass{myOutputFile=" + this.myOutputFile + ", mySourceFiles=" + this.mySourceFiles + ", myIsDirty=" + this.myIsDirty + '}';
    }
}

