/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderService;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.service.JpsServiceManager;

public final class BuilderRegistry {
    private static final Logger LOG = Logger.getInstance(BuilderRegistry.class);
    private final Map<BuilderCategory, List<ModuleLevelBuilder>> myModuleLevelBuilders = new HashMap<BuilderCategory, List<ModuleLevelBuilder>>();
    private final Object2LongMap<BuildTargetType<?>> myExpectedBuildTime = new Object2LongOpenHashMap();
    private final List<TargetBuilder<?, ?>> myTargetBuilders = new ArrayList();
    private final FileFilter myModuleBuilderFileFilter;

    public static BuilderRegistry getInstance() {
        return Holder.ourInstance;
    }

    private BuilderRegistry() {
        for (BuilderCategory category : BuilderCategory.values()) {
            this.myModuleLevelBuilders.put(category, new ArrayList());
        }
        Set compilableFileExtensions = CollectionFactory.createFilePathSet();
        for (BuilderService service : JpsServiceManager.getInstance().getExtensions(BuilderService.class)) {
            this.myTargetBuilders.addAll(service.createBuilders());
            List<? extends ModuleLevelBuilder> moduleLevelBuilders = service.createModuleLevelBuilders();
            for (ModuleLevelBuilder moduleLevelBuilder : moduleLevelBuilders) {
                try {
                    List<String> extensions = moduleLevelBuilder.getCompilableFileExtensions();
                    if (compilableFileExtensions != null) {
                        compilableFileExtensions.addAll(extensions);
                    }
                }
                catch (AbstractMethodError e) {
                    LOG.info(moduleLevelBuilder.getClass().getName() + " builder doesn't implement 'getCompilableFileExtensions' method so ModuleBuildTarget will process all files under source roots.");
                    compilableFileExtensions = null;
                }
                this.myModuleLevelBuilders.get((Object)moduleLevelBuilder.getCategory()).add(moduleLevelBuilder);
            }
        }
        if (compilableFileExtensions == null) {
            this.myModuleBuilderFileFilter = FileFilters.EVERYTHING;
        } else {
            Set finalCompilableFileExtensions = compilableFileExtensions;
            this.myModuleBuilderFileFilter = file -> finalCompilableFileExtensions.contains(FileUtilRt.getExtension((String)file.getName()));
        }
        long moduleTargetBuildTime = 0L;
        for (ModuleLevelBuilder moduleLevelBuilder : this.getModuleLevelBuilders()) {
            moduleTargetBuildTime += moduleLevelBuilder.getExpectedBuildTime();
        }
        this.myExpectedBuildTime.put((Object)JavaModuleBuildTargetType.PRODUCTION, moduleTargetBuildTime);
        this.myExpectedBuildTime.put((Object)JavaModuleBuildTargetType.TEST, moduleTargetBuildTime);
        for (TargetBuilder targetBuilder : this.myTargetBuilders) {
            long l = targetBuilder.getExpectedBuildTime();
            for (BuildTargetType type : targetBuilder.getTargetTypes()) {
                long total = this.myExpectedBuildTime.getLong(type);
                this.myExpectedBuildTime.put(type, total + l);
            }
        }
    }

    @NotNull
    public FileFilter getModuleBuilderFileFilter() {
        return this.myModuleBuilderFileFilter;
    }

    public int getModuleLevelBuilderCount() {
        int count = 0;
        for (BuilderCategory category : BuilderCategory.values()) {
            count += this.getBuilders(category).size();
        }
        return count;
    }

    public List<BuildTask> getBeforeTasks() {
        return Collections.emptyList();
    }

    public List<BuildTask> getAfterTasks() {
        return Collections.emptyList();
    }

    public List<ModuleLevelBuilder> getBuilders(BuilderCategory category) {
        return Collections.unmodifiableList(this.myModuleLevelBuilders.get((Object)category));
    }

    public List<ModuleLevelBuilder> getModuleLevelBuilders() {
        ArrayList<ModuleLevelBuilder> result = new ArrayList<ModuleLevelBuilder>();
        for (BuilderCategory category : BuilderCategory.values()) {
            result.addAll(this.getBuilders(category));
        }
        return result;
    }

    public List<TargetBuilder<?, ?>> getTargetBuilders() {
        return this.myTargetBuilders;
    }

    public long getExpectedBuildTimeForTarget(BuildTargetType<?> targetType) {
        return this.myExpectedBuildTime.getLong(targetType);
    }

    private static final class Holder {
        static final BuilderRegistry ourInstance = new BuilderRegistry();

        private Holder() {
        }
    }
}

