/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.client;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.CountingGZIPInputStream;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Base64;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cache.client.JpsNettyClient;
import org.jetbrains.jps.cache.client.JpsServerAuthUtil;
import org.jetbrains.jps.cache.model.JpsLoaderContext;
import org.jetbrains.jps.cache.statistics.SystemOpsStatistic;

public class JpsServerConnectionUtil {
    private static final Logger LOG = Logger.getInstance(JpsServerConnectionUtil.class);
    private static final String CDN_CACHE_HEADER = "X-Cache";
    private static final String INITIAL_FILE_FOR_SPEED_TEST = "2_MB.zip";

    @Nullable
    public static SystemOpsStatistic measureConnectionSpeed(@NotNull JpsNettyClient nettyClient) {
        long start = System.currentTimeMillis();
        SystemOpsStatistic firstSystemStats = JpsServerConnectionUtil.measureConnectionSpeedOnFile(nettyClient, INITIAL_FILE_FOR_SPEED_TEST, null);
        if (firstSystemStats == null) {
            LOG.info("Can't detect connection speed");
            return null;
        }
        String nextChunkFileName = JpsServerConnectionUtil.calculateFileName(firstSystemStats);
        if (nextChunkFileName != null) {
            SystemOpsStatistic statistic = JpsServerConnectionUtil.measureConnectionSpeedOnFile(nettyClient, nextChunkFileName, firstSystemStats);
            long connectionSpeedTime = (System.currentTimeMillis() - start) / 1000L;
            LOG.info("Checking system operations: connection speed, decompression and delete took: " + connectionSpeedTime + "s");
            return statistic;
        }
        LOG.info("Connection speed is too small");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static SystemOpsStatistic measureConnectionSpeedOnFile(@NotNull JpsNettyClient nettyClient, @NotNull String fileName, @Nullable SystemOpsStatistic previousSystemStats) {
        Map<String, String> headers = JpsServerAuthUtil.getRequestHeaders();
        String url = JpsServerConnectionUtil.calculateURL(fileName);
        LOG.info("Checking connection speed base on the file: " + fileName);
        long start = System.currentTimeMillis();
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpGet httpRequest = new HttpGet(url);
            headers.forEach((k, v) -> httpRequest.setHeader(k, v));
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpRequest);
            HttpEntity responseEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == 200) {
                long decompressionSpeedBytesPesSec;
                long fileSize = responseEntity.getContentLength();
                Header header = response.getFirstHeader(CDN_CACHE_HEADER);
                File downloadedFile = JpsServerConnectionUtil.saveToFile(FileUtil.createTempFile((String)"download.", (String)".tmp").toPath(), responseEntity, null).toFile();
                long downloadTime = System.currentTimeMillis() - start;
                long bytesPerSecond = fileSize / downloadTime * 1000L;
                if (header != null && header.getValue().startsWith("Hit")) {
                    LOG.info("Speed of connection to CDN: " + StringUtil.formatFileSize((long)bytesPerSecond) + "/s; " + JpsServerConnectionUtil.formatInternetSpeed(bytesPerSecond * 8L));
                } else {
                    LOG.info("Speed of connection to S3: " + StringUtil.formatFileSize((long)bytesPerSecond) + "/s; " + JpsServerConnectionUtil.formatInternetSpeed(bytesPerSecond * 8L));
                }
                if (previousSystemStats == null) {
                    start = System.currentTimeMillis();
                    ZipUtil.extract((File)downloadedFile, (File)FileUtil.createTempDirectory((String)"decompress", (String)".tmp"), null);
                    long decompressionTime = System.currentTimeMillis() - start;
                    decompressionSpeedBytesPesSec = fileSize / decompressionTime * 1000L;
                    LOG.info("Time spent to decompress file " + fileName + " " + decompressionTime + "ms");
                } else {
                    decompressionSpeedBytesPesSec = previousSystemStats.getDecompressionSpeedBytesPesSec();
                }
                start = System.currentTimeMillis();
                FileUtil.delete((File)downloadedFile);
                long deletionTime = System.currentTimeMillis() - start;
                if (deletionTime == 0L) {
                    deletionTime = 1L;
                }
                long deletionSpeedBytesPerSec = fileSize / deletionTime * 1000L;
                LOG.info("Time spent to delete file " + fileName + " " + deletionTime + "ms");
                SystemOpsStatistic systemOpsStatistic = new SystemOpsStatistic(bytesPerSecond, decompressionSpeedBytesPesSec, deletionSpeedBytesPerSec);
                return systemOpsStatistic;
            }
            String errorText = StreamUtil.readText((Reader)new InputStreamReader(responseEntity.getContent(), StandardCharsets.UTF_8));
            LOG.warn("Request: " + url + " Error: " + response.getStatusLine().getStatusCode() + " body: " + errorText);
            return null;
        }
        catch (IOException e) {
            LOG.warn("Failed to download/delete/decompress file for measurement system stats", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private static String calculateFileName(@NotNull SystemOpsStatistic systemOpsStatistic) {
        long connectionSpeed = systemOpsStatistic.getConnectionSpeedBytesPerSec();
        if (connectionSpeed > 3000000L) {
            return "75_MB.dat";
        }
        if (connectionSpeed > 2000000L) {
            return "50_MB.dat";
        }
        if (connectionSpeed > 1300000L) {
            return "25_MB.dat";
        }
        if (connectionSpeed > 700000L) {
            return "10_MB.dat";
        }
        return null;
    }

    private static String calculateURL(@NotNull String fileName) {
        byte[] decodedBytes = Base64.getDecoder().decode("aHR0cHM6Ly9kMWxjNWs5bGVyZzZrbS5jbG91ZGZyb250Lm5ldA==");
        return new String(decodedBytes, StandardCharsets.UTF_8) + "/speed-test/" + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Path saveToFile(@NotNull Path file, HttpEntity responseEntity, @Nullable JpsLoaderContext loaderContext) throws IOException {
        NioFiles.createDirectories((Path)file.getParent());
        boolean deleteFile = true;
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            JpsServerConnectionUtil.copyStreamContent(responseEntity.getContent(), out, loaderContext, responseEntity.getContentLength());
            deleteFile = false;
        }
        finally {
            if (deleteFile) {
                Files.deleteIfExists(file);
            }
        }
        return file;
    }

    private static long copyStreamContent(@NotNull InputStream inputStream, @NotNull OutputStream outputStream, @Nullable JpsLoaderContext loaderContext, long expectedContentLength) throws IOException {
        int count;
        CountingGZIPInputStream gzipStream = inputStream instanceof CountingGZIPInputStream ? (CountingGZIPInputStream)inputStream : null;
        byte[] buffer = new byte[8192];
        long bytesWritten = 0L;
        long bytesRead = 0L;
        while ((count = inputStream.read(buffer)) > 0) {
            if (loaderContext != null) {
                loaderContext.checkCanceled();
            }
            outputStream.write(buffer, 0, count);
            bytesRead = gzipStream != null ? gzipStream.getCompressedBytesRead() : (bytesWritten += (long)count);
        }
        if (gzipStream != null) {
            bytesRead = gzipStream.getCompressedBytesRead();
        }
        if (bytesRead < expectedContentLength) {
            throw new IOException("Connection closed at byte " + bytesRead + ". Expected " + expectedContentLength + " bytes.");
        }
        return bytesWritten;
    }

    public static boolean checkInternetConnectionAvailable() {
        try {
            URL url = new URL("https://www.google.com/");
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(1000);
            connection.connect();
            return true;
        }
        catch (Exception e) {
            LOG.info("Internet connection is not available");
            return false;
        }
    }

    @NotNull
    private static String formatInternetSpeed(long fileSize) {
        int rank = (int)((Math.log10(fileSize) + 2.1714778384307465E-6) / 3.0);
        double value = (double)fileSize / Math.pow(1000.0, rank);
        String[] units = new String[]{"Bit", "Kbit", "Mbit", "Gbit"};
        return new DecimalFormat("0.##").format(value) + units[rank] + "/s";
    }
}

