/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.client;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cache.client.JpsCachesDownloader;
import org.jetbrains.jps.cache.client.JpsNettyClient;
import org.jetbrains.jps.cache.client.JpsServerClient;
import org.jetbrains.jps.cache.model.AffectedModule;
import org.jetbrains.jps.cache.model.DownloadableFileUrl;
import org.jetbrains.jps.cache.model.JpsLoaderContext;
import org.jetbrains.jps.cache.model.OutputLoadResult;

public final class JpsServerClientImpl
implements JpsServerClient {
    private static final Logger LOG = Logger.getInstance(JpsServerClientImpl.class);
    private final String myServerUrl;

    JpsServerClientImpl(@NotNull String serverUrl) {
        this.myServerUrl = serverUrl;
    }

    @Override
    @Nullable
    public File downloadMetadataById(@NotNull JpsNettyClient nettyClient, @NotNull String metadataId, @NotNull File targetDir) {
        String downloadUrl = this.myServerUrl + "/metadata/" + metadataId;
        String fileName = "metadata.json";
        DownloadableFileUrl description = new DownloadableFileUrl(downloadUrl, fileName);
        JpsCachesDownloader downloader = new JpsCachesDownloader(Collections.singletonList(description), nettyClient, null);
        LOG.debug("Downloading JPS metadata from: " + downloadUrl);
        try {
            File metadataFile;
            List<Pair<File, DownloadableFileUrl>> pairs = downloader.download(targetDir);
            Pair first = (Pair)ContainerUtil.getFirstItem(pairs);
            File file = metadataFile = first != null ? (File)first.first : null;
            if (metadataFile == null) {
                LOG.warn("Failed to download JPS metadata");
                return null;
            }
            return metadataFile;
        }
        catch (ProcessCanceledException | IOException e) {
            if (e instanceof IOException) {
                LOG.warn("Failed to download JPS metadata from URL: " + downloadUrl, e);
            }
            return null;
        }
    }

    @Override
    @Nullable
    public File downloadCacheById(@NotNull JpsLoaderContext context, @NotNull String cacheId, @NotNull File targetDir) {
        block3: {
            String downloadUrl = this.myServerUrl + "/caches/" + cacheId;
            String fileName = "portable-build-cache.zip";
            DownloadableFileUrl description = new DownloadableFileUrl(downloadUrl, fileName);
            JpsCachesDownloader downloader = new JpsCachesDownloader(Collections.singletonList(description), context.getNettyClient(), context);
            LOG.debug("Downloading JPS caches from: " + downloadUrl);
            try {
                File zipFile;
                List<Pair<File, DownloadableFileUrl>> pairs = downloader.download(targetDir);
                Pair first = (Pair)ContainerUtil.getFirstItem(pairs);
                File file = zipFile = first != null ? (File)first.first : null;
                if (zipFile != null) {
                    return zipFile;
                }
                LOG.warn("Failed to download JPS caches");
            }
            catch (ProcessCanceledException | IOException e) {
                if (!(e instanceof IOException)) break block3;
                LOG.warn("Failed to download JPS caches from URL: " + downloadUrl, e);
            }
        }
        return null;
    }

    @Override
    public List<OutputLoadResult> downloadCompiledModules(@NotNull JpsLoaderContext context, @NotNull List<AffectedModule> affectedModules) {
        File targetDir = new File(PathManager.getPluginTempPath(), "jps-cache-loader");
        if (targetDir.exists()) {
            FileUtil.delete((File)targetDir);
        }
        targetDir.mkdirs();
        Map<String, AffectedModule> urlToModuleNameMap = affectedModules.stream().collect(Collectors.toMap(module -> this.myServerUrl + "/" + module.getType() + "/" + module.getName() + "/" + module.getHash(), module -> module));
        List descriptions = ContainerUtil.map(urlToModuleNameMap.entrySet(), entry -> new DownloadableFileUrl((String)entry.getKey(), ((AffectedModule)entry.getValue()).getOutPath().getName() + ".zip"));
        JpsCachesDownloader downloader = new JpsCachesDownloader(descriptions, context.getNettyClient(), context);
        List downloadedFiles = new ArrayList();
        try {
            List<Pair<File, DownloadableFileUrl>> download = downloader.download(targetDir);
            downloadedFiles = ContainerUtil.map(download, pair -> (File)pair.first);
            return ContainerUtil.map(download, pair -> {
                String downloadUrl = ((DownloadableFileUrl)pair.second).getDownloadUrl();
                return new OutputLoadResult((File)pair.first, downloadUrl, (AffectedModule)urlToModuleNameMap.get(downloadUrl));
            });
        }
        catch (ProcessCanceledException | IOException e) {
            if (e instanceof IOException) {
                LOG.warn("Failed to download JPS compilation outputs", e);
            }
            if (targetDir.exists()) {
                FileUtil.delete((File)targetDir);
            }
            downloadedFiles.forEach(zipFile -> FileUtil.delete((File)zipFile));
            return null;
        }
    }
}

