/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.client;

import io.netty.channel.Channel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineProtoUtil;

public class JpsNettyClient {
    private final UUID sessionId;
    private final Channel channel;
    private final AtomicInteger currentDownloadsCount;

    public JpsNettyClient(@NotNull Channel channel, @NotNull UUID sessionId) {
        this.channel = channel;
        this.sessionId = sessionId;
        this.currentDownloadsCount = new AtomicInteger();
    }

    public void sendDescriptionStatusMessage(@NotNull String message) {
        this.channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.sessionId, CmdlineProtoUtil.createCacheDownloadMessage(message)));
    }

    public void sendDescriptionStatusMessage(@NotNull String message, int expectedDownloads) {
        int currentDownloads = this.currentDownloadsCount.incrementAndGet();
        if (expectedDownloads == 0) {
            this.channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.sessionId, CmdlineProtoUtil.createCacheDownloadMessage(message)));
        } else {
            int doubleExpectedDownloads = expectedDownloads * 2 + 1000;
            this.channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.sessionId, CmdlineProtoUtil.createCacheDownloadMessageWithProgress(message, (float)currentDownloads / (float)doubleExpectedDownloads)));
        }
    }

    public void sendDownloadStatisticMessage(@NotNull String latestDownloadCommit, long decompressionTimeBytesPesSec, long deletionTimeBytesPerSec) {
        this.channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.sessionId, CmdlineProtoUtil.createSaveDownloadStatisticMessage(latestDownloadCommit, decompressionTimeBytesPesSec, deletionTimeBytesPerSec)));
    }

    public void saveLatestBuiltCommit() {
        this.channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.sessionId, CmdlineProtoUtil.createSaveLatestBuiltCommitMessage()));
    }
}

