/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public final class IntObjectPersistentMultiMaplet<V>
extends IntObjectMultiMaplet<V> {
    private static final Collection NULL_COLLECTION = Collections.emptySet();
    private static final int CACHE_SIZE = 128;
    private final PersistentHashMap<Integer, Collection<V>> myMap;
    private final DataExternalizer<V> myValueExternalizer;
    private final SLRUCache<Integer, Collection> myCache;

    public IntObjectPersistentMultiMaplet(File file, KeyDescriptor<Integer> keyExternalizer, DataExternalizer<V> valueExternalizer, Supplier<? extends Collection<V>> collectionFactory) throws IOException {
        this.myValueExternalizer = valueExternalizer;
        this.myMap = new PersistentHashMap(file, keyExternalizer, new CollectionDataExternalizer<V>(valueExternalizer, collectionFactory));
        this.myCache = new SLRUCache<Integer, Collection>(128, 128){

            @NotNull
            public Collection createValue(Integer key) {
                try {
                    Collection collection = (Collection)IntObjectPersistentMultiMaplet.this.myMap.get((Object)key);
                    return collection == null ? NULL_COLLECTION : collection;
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            }
        };
    }

    @Override
    public boolean containsKey(int key) {
        try {
            return this.myMap.containsMapping((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public Collection<V> get(int key) {
        Collection collection = (Collection)this.myCache.get((Object)key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(int key, Collection<V> value) {
        try {
            this.myCache.remove((Object)key);
            if (value == null || value.isEmpty()) {
                this.myMap.remove((Object)key);
            } else {
                this.myMap.put((Object)key, value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, final Collection<V> value) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.appendData((Object)key, new AppendablePersistentMap.ValueDataAppender(){

                public void append(@NotNull DataOutput out) throws IOException {
                    for (Object v : value) {
                        IntObjectPersistentMultiMaplet.this.myValueExternalizer.save(out, v);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, V value) {
        this.put(key, (V)Collections.singleton(value));
    }

    @Override
    public void removeAll(int key, Collection<V> values) {
        try {
            Collection collection = (Collection)this.myCache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.removeAll(values)) {
                this.myCache.remove((Object)key);
                if (collection.isEmpty()) {
                    this.myMap.remove((Object)key);
                } else {
                    this.myMap.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(int key, V value) {
        try {
            Collection collection = (Collection)this.myCache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.myCache.remove((Object)key);
                if (collection.isEmpty()) {
                    this.myMap.remove((Object)key);
                } else {
                    this.myMap.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(int key) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.remove((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(IntObjectMultiMaplet<V> m) {
        m.forEachEntry((vs, value) -> this.put(value, (V)vs));
    }

    @Override
    public void replaceAll(IntObjectMultiMaplet<V> m) {
        m.forEachEntry((vs, value) -> this.replace(value, (Collection<V>)vs));
    }

    @Override
    public void close() {
        try {
            this.myCache.clear();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.myMap.isDirty()) {
                this.myMap.dropMemoryCaches();
            }
        } else {
            this.myMap.force();
        }
    }

    @Override
    void forEachEntry(ObjIntConsumer<? super Collection<V>> procedure) {
        try {
            this.myMap.processKeysWithExistingMapping(key -> {
                try {
                    procedure.accept((Collection<V>)this.myMap.get(key), (int)key);
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
                return true;
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static class CollectionDataExternalizer<V>
    implements DataExternalizer<Collection<V>> {
        private final DataExternalizer<V> myElementExternalizer;
        private final Supplier<? extends Collection<V>> myCollectionFactory;

        CollectionDataExternalizer(DataExternalizer<V> elementExternalizer, Supplier<? extends Collection<V>> collectionFactory) {
            this.myElementExternalizer = elementExternalizer;
            this.myCollectionFactory = collectionFactory;
        }

        public void save(@NotNull DataOutput out, Collection<V> value) throws IOException {
            for (V x : value) {
                this.myElementExternalizer.save(out, x);
            }
        }

        public Collection<V> read(@NotNull DataInput in) throws IOException {
            Collection<V> result = this.myCollectionFactory.get();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(this.myElementExternalizer.read(in));
            }
            return result;
        }
    }
}

