/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

public class ResourceRootDescriptor
extends BuildRootDescriptor {
    @NotNull
    private final File myRoot;
    @NotNull
    private final ResourcesTarget myTarget;
    @NotNull
    private final String myPackagePrefix;
    @NotNull
    private final Set<File> myExcludes;
    protected final FileFilter myFilterForExcludedPatterns;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public ResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        this(root, target, packagePrefix, excludes, FileFilters.EVERYTHING);
    }

    public ResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<File> excludes, @NotNull FileFilter filterForExcludedPatterns) {
        this.myPackagePrefix = packagePrefix;
        this.myRoot = root;
        this.myTarget = target;
        this.myExcludes = excludes;
        this.myFilterForExcludedPatterns = filterForExcludedPatterns;
    }

    @Override
    public File getRootFile() {
        return this.myRoot;
    }

    @Override
    @NotNull
    public Set<File> getExcludedRoots() {
        return this.myExcludes;
    }

    @NotNull
    public ResourcesTarget getTarget() {
        return this.myTarget;
    }

    @NotNull
    public String getPackagePrefix() {
        return this.myPackagePrefix;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsProject project = this.getTarget().getModule().getProject();
        JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project).getCompilerExcludes();
        return file -> !excludes.isExcluded(file) && this.myFilterForExcludedPatterns.accept(file);
    }

    public String toString() {
        return "ResourceRootDescriptor{target='" + this.myTarget + '\'' + ", root=" + this.myRoot + '}';
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.myRoot.getPath());
    }
}

