/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.java;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.tools.JavaCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;

public final class EclipseCompilerTool
extends JavaCompilingTool {
    private static final String JAR_FILE_NAME_PREFIX = "ecj-";
    private static final String JAR_FILE_NAME_SUFFIX = ".jar";
    private String myVersion;

    @NotNull
    public String getId() {
        return "Eclipse";
    }

    @NotNull
    public String getAlternativeId() {
        return "EclipseEmbedded";
    }

    @NotNull
    public String getDescription() {
        String version = this.myVersion;
        if (version == null) {
            String name;
            Path file;
            version = "";
            JavaCompiler compiler = EclipseCompilerTool.findCompiler();
            Path path = file = compiler == null ? null : PathManager.getJarForClass(compiler.getClass());
            if (file != null && (name = file.getFileName().toString()).startsWith(JAR_FILE_NAME_PREFIX) && name.endsWith(JAR_FILE_NAME_SUFFIX)) {
                version = " " + name.substring(JAR_FILE_NAME_PREFIX.length(), name.length() - JAR_FILE_NAME_SUFFIX.length());
            }
            this.myVersion = version;
        }
        return "Eclipse compiler" + version;
    }

    @NotNull
    public JavaCompiler createCompiler() throws CannotCreateJavaCompilerException {
        JavaCompiler javaCompiler = EclipseCompilerTool.findCompiler();
        if (javaCompiler == null) {
            throw new CannotCreateJavaCompilerException("Eclipse Batch Compiler was not found in classpath");
        }
        return javaCompiler;
    }

    @Nullable
    private static JavaCompiler findCompiler() {
        for (JavaCompiler javaCompiler : ServiceLoader.load(JavaCompiler.class)) {
            if (!"EclipseCompiler".equals(StringUtil.getShortName(javaCompiler.getClass()))) continue;
            return javaCompiler;
        }
        return null;
    }

    @NotNull
    public List<File> getAdditionalClasspath() {
        File element = EclipseCompilerTool.findEcjJarFile();
        return element == null ? Collections.emptyList() : Collections.singletonList(element);
    }

    @Nullable
    public static File findEcjJarFile() {
        File result = new File(PathManager.getHomePath(), "plugins/java/lib/ecj/eclipse.jar");
        if (result.exists()) {
            return result;
        }
        for (String relativeDirectoryPath : new String[]{"plugins/java/lib", "lib", "community/lib"}) {
            File lib = new File(PathManager.getHomePath(), relativeDirectoryPath);
            File[] children = lib.listFiles((dir, name) -> name.startsWith(JAR_FILE_NAME_PREFIX) && name.endsWith(JAR_FILE_NAME_SUFFIX));
            if (children == null || children.length <= 0) continue;
            return children[0];
        }
        return null;
    }

    public List<String> getDefaultCompilerOptions() {
        return Collections.singletonList("-noExit");
    }
}

