/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.tracing.Tracer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.OutboundSemiGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildRootIndexImpl;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.TargetOutputIndexImpl;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.model.module.JpsModule;

public final class BuildTargetIndexImpl
implements BuildTargetIndex {
    private final BuildTargetRegistry myRegistry;
    private final BuildRootIndexImpl myBuildRootIndex;
    private final Map<BuildTarget<?>, Collection<BuildTarget<?>>> myDependencies;
    private List<BuildTargetChunk> myTargetChunks;

    public BuildTargetIndexImpl(BuildTargetRegistry targetRegistry, BuildRootIndexImpl buildRootIndex) {
        this.myRegistry = targetRegistry;
        this.myBuildRootIndex = buildRootIndex;
        this.myDependencies = new HashMap();
    }

    @Override
    public List<BuildTargetChunk> getSortedTargetChunks(@NotNull CompileContext context) {
        this.initializeChunks(context);
        return this.myTargetChunks;
    }

    private synchronized void initializeChunks(@NotNull CompileContext context) {
        if (this.myTargetChunks != null) {
            return;
        }
        Tracer.Span chunksInitSpan = Tracer.start((String)"BuildTargetIndexImpl.initializeChunks");
        final List<BuildTarget<?>> allTargets = this.getAllTargets();
        TargetOutputIndexImpl outputIndex = new TargetOutputIndexImpl(allTargets, context);
        HashMap dummyTargetDependencies = new HashMap();
        ArrayList realTargets = new ArrayList(allTargets.size());
        for (BuildTarget<Object> target : allTargets) {
            if (this.isDummy(target)) {
                dummyTargetDependencies.put(target, target.computeDependencies(this.myRegistry, outputIndex));
                continue;
            }
            realTargets.add(target);
        }
        for (BuildTarget<Object> target : realTargets) {
            Collection<BuildTarget<?>> dependencies = target.computeDependencies(this, outputIndex);
            Collection<BuildTarget<?>> realDependencies = !ContainerUtil.intersects(dependencies, dummyTargetDependencies.keySet()) ? dependencies : BuildTargetIndexImpl.includeTransitiveDependenciesOfDummyTargets(dependencies, dummyTargetDependencies);
            this.myDependencies.put(target, realDependencies);
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)new InboundSemiGraph<BuildTarget<?>>(){

            @NotNull
            public Collection<BuildTarget<?>> getNodes() {
                return allTargets;
            }

            @NotNull
            public Iterator<BuildTarget<?>> getIn(BuildTarget<?> n) {
                Collection deps = (Collection)BuildTargetIndexImpl.this.myDependencies.get(n);
                return deps != null ? deps.iterator() : Collections.emptyIterator();
            }
        });
        DFSTBuilder builder = new DFSTBuilder((OutboundSemiGraph)graph);
        Collection components = builder.getComponents();
        this.myTargetChunks = new ArrayList<BuildTargetChunk>(components.size());
        for (Collection component : components) {
            this.myTargetChunks.add(new BuildTargetChunk(new LinkedHashSet(component)));
        }
        chunksInitSpan.complete();
    }

    private static Collection<BuildTarget<?>> includeTransitiveDependenciesOfDummyTargets(Collection<? extends BuildTarget<?>> dependencies, Map<BuildTarget<?>, Collection<BuildTarget<?>>> dummyTargetDependencies) {
        ArrayList realDependencies = new ArrayList(dependencies.size());
        HashSet processed = new HashSet(dependencies);
        ArrayDeque toProcess = new ArrayDeque(dependencies);
        while (!toProcess.isEmpty()) {
            BuildTarget dep = (BuildTarget)toProcess.poll();
            Collection<BuildTarget<?>> toInclude = dummyTargetDependencies.get(dep);
            if (toInclude != null) {
                for (BuildTarget<?> target : toInclude) {
                    if (!processed.add(target)) continue;
                    toProcess.add(target);
                }
            }
            realDependencies.add(dep);
        }
        realDependencies.trimToSize();
        return realDependencies;
    }

    @Override
    public boolean isDummy(@NotNull BuildTarget<?> target) {
        return target.getTargetType().isFileBased() && this.myBuildRootIndex.getTargetRoots(target, null).isEmpty();
    }

    @Override
    public Set<BuildTarget<?>> getDependenciesRecursively(@NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        this.initializeChunks(context);
        LinkedHashSet result = new LinkedHashSet();
        for (BuildTarget<?> dep : this.getDependencies(target, context)) {
            this.collectDependenciesRecursively(dep, result, context);
        }
        return result;
    }

    private void collectDependenciesRecursively(BuildTarget<?> target, LinkedHashSet<? super BuildTarget<?>> result, CompileContext context) {
        if (result.add(target)) {
            for (BuildTarget<?> dep : this.getDependencies(target, context)) {
                this.collectDependenciesRecursively(dep, result, context);
            }
        }
    }

    @Override
    @NotNull
    public Collection<BuildTarget<?>> getDependencies(@NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        this.initializeChunks(context);
        Collection<BuildTarget<?>> deps = this.myDependencies.get(target);
        return deps != null ? deps : Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<ModuleBasedTarget<?>> getModuleBasedTargets(@NotNull JpsModule module, @NotNull BuildTargetRegistry.ModuleTargetSelector selector) {
        return this.myRegistry.getModuleBasedTargets(module, selector);
    }

    @Override
    @NotNull
    public <T extends BuildTarget<?>> List<T> getAllTargets(@NotNull BuildTargetType<T> type) {
        return this.myRegistry.getAllTargets(type);
    }

    @Override
    @NotNull
    public List<BuildTarget<?>> getAllTargets() {
        return this.myRegistry.getAllTargets();
    }
}

