/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.api;

import com.intellij.AbstractBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JpsDynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(JpsDynamicBundle.class);
    private static final Method SET_PARENT = JpsDynamicBundle.getSetParentMethod();
    private static final ClassLoader ourLangBundleLoader;

    private static Method getSetParentMethod() {
        try {
            return ReflectionUtil.getDeclaredMethod(ResourceBundle.class, (String)"setParent", (Class[])new Class[]{ResourceBundle.class});
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected JpsDynamicBundle(@NonNls @NotNull String pathToBundle) {
        super(pathToBundle);
    }

    @NotNull
    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        ResourceBundle base = super.findBundle(pathToBundle, loader, control);
        ClassLoader languageBundleLoader = ourLangBundleLoader;
        if (languageBundleLoader != null) {
            ResourceBundle languageBundle = super.findBundle(pathToBundle, languageBundleLoader, control);
            try {
                if (SET_PARENT != null) {
                    SET_PARENT.invoke((Object)languageBundle, base);
                }
                return languageBundle;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return base;
    }

    static {
        URLClassLoader loader = null;
        try {
            String bundlePath = System.getProperty("jps.language.bundle", null);
            if (bundlePath != null) {
                loader = new URLClassLoader(new URL[]{new File(bundlePath).toURI().toURL()}, null);
            }
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            ourLangBundleLoader = loader;
        }
    }
}

