/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.plugins;

import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StoredPropertyBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.plugins.PluginManagerProxy;
import com.intellij.settingsSync.plugins.SettingsSyncPluginCategoryFinder;
import com.intellij.settingsSync.plugins.SettingsSyncPluginInstaller;
import com.intellij.settingsSync.plugins.SettingsSyncPluginManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@State(name="SettingsSyncPlugins", storages={@Storage(value="settingsSyncPlugins.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\b\b\u0001\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003%&'B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u001b\u001a\u00020\u0002H\u0016J \u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0006\u0010!\u001a\u00020\u0014J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001aH\u0002J\b\u0010$\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager$SyncPluginsState;", "Lcom/intellij/openapi/Disposable;", "()V", "noUpdateFromIde", "", "pluginStateListener", "com/intellij/settingsSync/plugins/SettingsSyncPluginManager$pluginStateListener$1", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager$pluginStateListener$1;", "sessionUninstalledPlugins", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "state", "checkDependencies", "idString", "pluginState", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager$PluginData;", "clearState", "", "dispose", "doWithNoUpdateFromIde", "runnable", "Ljava/lang/Runnable;", "findPlugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getState", "isPluginSyncEnabled", "isBundled", "category", "Lcom/intellij/openapi/components/SettingsCategory;", "loadState", "pushChangesToIde", "shouldSaveState", "plugin", "updateStateFromIde", "Companion", "PluginData", "SyncPluginsState", "intellij.settingsSync"})
public final class SettingsSyncPluginManager
implements PersistentStateComponent<SyncPluginsState>,
Disposable {
    private final pluginStateListener.1 pluginStateListener = new PluginStateListener(this){
        final /* synthetic */ SettingsSyncPluginManager this$0;

        public void install(@NotNull IdeaPluginDescriptor descriptor) {
            SettingsSyncPluginManager.access$getSessionUninstalledPlugins$p(this.this$0).remove(descriptor.getPluginId().getIdString());
        }

        public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
            String idString = descriptor.getPluginId().getIdString();
            PluginData pluginData = SettingsSyncPluginManager.access$getState$p(this.this$0).getPlugins().get(idString);
            if (pluginData != null) {
                PluginData pluginData2;
                PluginData it = pluginData2 = pluginData;
                boolean bl = false;
                it.setEnabled(false);
            }
            SettingsSyncPluginManager.access$getSessionUninstalledPlugins$p(this.this$0).add(idString);
        }
        {
            this.this$0 = this$0;
        }
    };
    private SyncPluginsState state;
    private boolean noUpdateFromIde;
    private final HashSet<String> sessionUninstalledPlugins;
    @NotNull
    public static final String FILE_SPEC = "settingsSyncPlugins.xml";
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public SyncPluginsState getState() {
        this.updateStateFromIde();
        return this.state;
    }

    public void loadState(@NotNull SyncPluginsState state) {
        this.state = state;
    }

    @TestOnly
    public final void clearState() {
        this.state.getPlugins().clear();
    }

    private final void updateStateFromIde() {
        if (this.noUpdateFromIde) {
            return;
        }
        IdeaPluginDescriptor[] $this$forEach$iv = PluginManagerProxy.Companion.getInstance().getPlugins();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            IdeaPluginDescriptor element$iv;
            IdeaPluginDescriptor it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String idString = it.getPluginId().getIdString();
            if (this.shouldSaveState(it)) {
                PluginData pluginData = this.state.getPlugins().get(idString);
                if (pluginData == null) {
                    pluginData = new PluginData();
                    pluginData.setCategory(SettingsSyncPluginCategoryFinder.INSTANCE.getPluginCategory(it));
                    Iterable $this$forEach$iv2 = it.getDependencies();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        IdeaPluginDependency dependency = (IdeaPluginDependency)element$iv2;
                        boolean bl2 = false;
                        if (dependency.isOptional()) continue;
                        pluginData.getDependencies().add(dependency.getPluginId().getIdString());
                        pluginData.intIncrementModificationCount();
                    }
                    this.state.getPlugins().put(idString, pluginData);
                }
                pluginData.setEnabled(it.isEnabled() && !this.sessionUninstalledPlugins.contains(idString));
                continue;
            }
            if (!this.state.getPlugins().containsKey(idString)) continue;
            this.state.getPlugins().remove(idString);
        }
    }

    public final void pushChangesToIde() {
        PluginManagerProxy pluginManagerProxy = PluginManagerProxy.Companion.getInstance();
        SettingsSyncPluginInstaller installer = pluginManagerProxy.createInstaller();
        Map<String, PluginData> $this$forEach$iv = this.state.getPlugins();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, PluginData>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, PluginData> element$iv;
            Map.Entry<String, PluginData> mapEntry = element$iv = iterator.next();
            boolean bl = false;
            IdeaPluginDescriptor plugin = this.findPlugin(mapEntry.getKey());
            if (plugin != null) {
                if (!this.isPluginSyncEnabled(plugin.getPluginId().getIdString(), plugin.isBundled(), SettingsSyncPluginCategoryFinder.INSTANCE.getPluginCategory(plugin)) || mapEntry.getValue().isEnabled() == plugin.isEnabled()) continue;
                if (mapEntry.getValue().isEnabled()) {
                    pluginManagerProxy.enablePlugin(plugin.getPluginId());
                    LOG.info("Disabled plugin: " + plugin.getPluginId().getIdString());
                    continue;
                }
                pluginManagerProxy.disablePlugin(plugin.getPluginId());
                LOG.info("Enabled plugin: " + plugin.getPluginId().getIdString());
                continue;
            }
            if (!mapEntry.getValue().isEnabled() || !this.isPluginSyncEnabled(mapEntry.getKey(), false, mapEntry.getValue().getCategory()) || !this.checkDependencies(mapEntry.getKey(), mapEntry.getValue())) continue;
            PluginId newPluginId = PluginId.getId((String)mapEntry.getKey());
            installer.addPluginId(newPluginId);
            LOG.info("New plugin installation requested: " + newPluginId.getIdString());
        }
        installer.installPlugins();
    }

    private final IdeaPluginDescriptor findPlugin(String idString) {
        IdeaPluginDescriptor ideaPluginDescriptor;
        PluginId pluginId = PluginId.findId((String)idString);
        if (pluginId != null) {
            PluginId pluginId2;
            PluginId it = pluginId2 = pluginId;
            boolean bl = false;
            ideaPluginDescriptor = PluginManagerProxy.Companion.getInstance().findPlugin(it);
        } else {
            ideaPluginDescriptor = null;
        }
        return ideaPluginDescriptor;
    }

    private final boolean checkDependencies(String idString, PluginData pluginState) {
        Iterable $this$forEach$iv = pluginState.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (this.findPlugin(it) != null) continue;
            LOG.info("Skipping " + idString + " plugin installation due to missing dependency: " + it);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWithNoUpdateFromIde(@NotNull Runnable runnable) {
        this.noUpdateFromIde = true;
        try {
            runnable.run();
        }
        finally {
            this.noUpdateFromIde = false;
        }
    }

    private final boolean shouldSaveState(IdeaPluginDescriptor plugin) {
        return this.isPluginSyncEnabled(plugin.getPluginId().getIdString(), plugin.isBundled(), SettingsSyncPluginCategoryFinder.INSTANCE.getPluginCategory(plugin)) && (!plugin.isBundled() || !plugin.isEnabled() || this.state.getPlugins().containsKey(plugin.getPluginId().getIdString()));
    }

    private final boolean isPluginSyncEnabled(String idString, boolean isBundled, SettingsCategory category) {
        SettingsSyncSettings settings = SettingsSyncSettings.Companion.getInstance();
        return settings.isCategoryEnabled(category) && (category != SettingsCategory.PLUGINS || isBundled && settings.isSubcategoryEnabled(SettingsCategory.PLUGINS, "bundled") || settings.isSubcategoryEnabled(SettingsCategory.PLUGINS, idString));
    }

    public void dispose() {
        PluginStateManager.removeStateListener((PluginStateListener)this.pluginStateListener);
    }

    public SettingsSyncPluginManager() {
        PluginStateManager.addStateListener((PluginStateListener)this.pluginStateListener);
        this.state = new SyncPluginsState();
        this.sessionUninstalledPlugins = new HashSet();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncPluginManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ HashSet access$getSessionUninstalledPlugins$p(SettingsSyncPluginManager $this) {
        return $this.sessionUninstalledPlugins;
    }

    public static final /* synthetic */ SyncPluginsState access$getState$p(SettingsSyncPluginManager $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(SettingsSyncPluginManager $this, SyncPluginsState syncPluginsState) {
        $this.state = syncPluginsState;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002RC\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager$SyncPluginsState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager$PluginData;", "plugins", "getPlugins", "()Ljava/util/Map;", "setPlugins", "(Ljava/util/Map;)V", "plugins$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.settingsSync"})
    public static final class SyncPluginsState
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty plugins$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(SyncPluginsState.class, "plugins", "getPlugins()Ljava/util/Map;", 0))};
        }

        @NotNull
        public final Map<String, PluginData> getPlugins() {
            return (Map)this.plugins$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setPlugins(@NotNull Map<String, PluginData> map) {
            this.plugins$delegate.setValue((Object)this, $$delegatedProperties[0], map);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR7\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00148F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager$PluginData;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "Lcom/intellij/openapi/components/SettingsCategory;", "category", "getCategory", "()Lcom/intellij/openapi/components/SettingsCategory;", "setCategory", "(Lcom/intellij/openapi/components/SettingsCategory;)V", "category$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "", "dependencies", "getDependencies", "()Ljava/util/Set;", "setDependencies", "(Ljava/util/Set;)V", "dependencies$delegate", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "isEnabled$delegate", "intellij.settingsSync"})
    public static final class PluginData
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty isEnabled$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty dependencies$delegate = this.stringSet().provideDelegate((Object)this, $$delegatedProperties[1]);
        @NotNull
        private final ReadWriteProperty category$delegate;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(PluginData.class, "isEnabled", "isEnabled()Z", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(PluginData.class, "dependencies", "getDependencies()Ljava/util/Set;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(PluginData.class, "category", "getCategory()Lcom/intellij/openapi/components/SettingsCategory;", 0))};
        }

        public final boolean isEnabled() {
            return (Boolean)this.isEnabled$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setEnabled(boolean bl) {
            this.isEnabled$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        @NotNull
        public final Set<String> getDependencies() {
            return (Set)this.dependencies$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setDependencies(@NotNull Set<String> set) {
            this.dependencies$delegate.setValue((Object)this, $$delegatedProperties[1], set);
        }

        @NotNull
        public final SettingsCategory getCategory() {
            return (SettingsCategory)this.category$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public final void setCategory(@NotNull SettingsCategory settingsCategory) {
            this.category$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)settingsCategory);
        }

        /*
         * WARNING - void declaration
         */
        public PluginData() {
            void this_$iv;
            BaseState baseState = this;
            Enum defaultValue$iv = (Enum)SettingsCategory.PLUGINS;
            boolean $i$f$enum = false;
            StoredPropertyBase storedPropertyBase = this_$iv.doEnum(defaultValue$iv, SettingsCategory.class);
            if (storedPropertyBase == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.components.StoredPropertyBase<T>");
            }
            this.category$delegate = storedPropertyBase.provideDelegate((Object)this, $$delegatedProperties[2]);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager$Companion;", "", "()V", "FILE_SPEC", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginManager;", "intellij.settingsSync"})
    public static final class Companion {
        @NotNull
        public final SettingsSyncPluginManager getInstance() {
            return (SettingsSyncPluginManager)ApplicationManager.getApplication().getService(SettingsSyncPluginManager.class);
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

