/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.plugins.SettingsSyncPluginInstaller;
import com.intellij.settingsSync.plugins.SettingsSyncPluginInstallerImpl;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0017J\b\u0010\u000f\u001a\u00020\bH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl;", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginInstaller;", "()V", "pluginsIds", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/extensions/PluginId;", "Lkotlin/collections/ArrayList;", "addPluginId", "", "pluginId", "installCollected", "installers", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "installPlugins", "notifyRestartNeeded", "Companion", "PrepareInstallationRunnable", "intellij.settingsSync"})
public final class SettingsSyncPluginInstallerImpl
implements SettingsSyncPluginInstaller {
    private final ArrayList<PluginId> pluginsIds = new ArrayList();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void addPluginId(@NotNull PluginId pluginId) {
        this.pluginsIds.add(pluginId);
    }

    @Override
    @RequiresBackgroundThread
    public void installPlugins() {
        if (this.pluginsIds.isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this){
            final /* synthetic */ SettingsSyncPluginInstallerImpl this$0;

            public final void run() {
                PrepareInstallationRunnable prepareRunnable = new PrepareInstallationRunnable(SettingsSyncPluginInstallerImpl.access$getPluginsIds$p(this.this$0));
                if (ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)prepareRunnable, SettingsSyncBundle.INSTANCE.message("installing.plugins.indicator", new Object[0]), true, null)) {
                    SettingsSyncPluginInstallerImpl.access$installCollected(this.this$0, prepareRunnable.getInstallers());
                }
            }
            {
                this.this$0 = settingsSyncPluginInstallerImpl;
            }
        });
    }

    private final void installCollected(List<PluginDownloader> installers) {
        boolean isRestartNeeded = false;
        Iterable $this$forEach$iv = installers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginDownloader it = (PluginDownloader)element$iv;
            boolean bl = false;
            if (!it.installDynamically(null)) {
                isRestartNeeded = true;
            }
            LOG.info("Installed plugin ID: " + it.getId().getIdString());
        }
        if (isRestartNeeded) {
            this.notifyRestartNeeded();
        }
    }

    private final void notifyRestartNeeded() {
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("settingsSync.errors").createNotification(SettingsSyncBundle.INSTANCE.message("plugins.sync.restart.notification.title", new Object[0]), SettingsSyncBundle.INSTANCE.message("plugins.sync.restart.notification.message", new Object[0]), NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.create((String)SettingsSyncBundle.INSTANCE.message("plugins.sync.restart.notification.action", ApplicationNamesInfo.getInstance().getFullProductName()), (Consumer)notifyRestartNeeded.1.INSTANCE));
        notification.notify(null);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncPluginInstallerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ ArrayList access$getPluginsIds$p(SettingsSyncPluginInstallerImpl $this) {
        return $this.pluginsIds;
    }

    public static final /* synthetic */ void access$installCollected(SettingsSyncPluginInstallerImpl $this, List installers) {
        $this.installCollected(installers);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl$PrepareInstallationRunnable;", "Ljava/lang/Runnable;", "pluginIds", "", "Lcom/intellij/openapi/extensions/PluginId;", "(Ljava/util/List;)V", "collectedInstallers", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "Lkotlin/collections/ArrayList;", "getPluginIds", "()Ljava/util/List;", "getInstallers", "prepareToInstall", "", "pluginId", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "run", "intellij.settingsSync"})
    private static final class PrepareInstallationRunnable
    implements Runnable {
        private final ArrayList<PluginDownloader> collectedInstallers;
        @NotNull
        private final List<PluginId> pluginIds;

        @Override
        public void run() {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            Iterable $this$forEach$iv = this.pluginIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginId it = (PluginId)element$iv;
                boolean bl = false;
                this.prepareToInstall(it, indicator);
                indicator.checkCanceled();
            }
        }

        private final void prepareToInstall(PluginId pluginId, ProgressIndicator indicator) {
            PluginDownloader downloader;
            PluginNode descriptor = MarketplaceRequests.getLastCompatiblePluginUpdate$default((MarketplaceRequests)MarketplaceRequests.Companion.getInstance(), (PluginId)pluginId, null, (ProgressIndicator)indicator, (int)2, null);
            if (descriptor != null && (downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)((IdeaPluginDescriptor)descriptor))).prepareToInstall(indicator)) {
                this.collectedInstallers.add(downloader);
            }
        }

        @NotNull
        public final ArrayList<PluginDownloader> getInstallers() {
            return this.collectedInstallers;
        }

        @NotNull
        public final List<PluginId> getPluginIds() {
            return this.pluginIds;
        }

        public PrepareInstallationRunnable(@NotNull List<PluginId> pluginIds) {
            this.pluginIds = pluginIds;
            this.collectedInstallers = new ArrayList();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

