/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEnabledStateListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.config.EnableSettingsSyncDialog;
import com.intellij.settingsSync.config.SettingsSyncConfigurable;
import com.intellij.settingsSync.config.SettingsSyncConfigurable$WhenMappings;
import com.intellij.settingsSync.config.SettingsSyncEnabler;
import com.intellij.settingsSync.config.SettingsSyncPanelFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.PairFunction;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 %2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004%&'(B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u00102\u000b\u0010\u001d\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001e2\u000b\u0010\u001f\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001eH\u0002J\b\u0010 \u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/settingsSync/config/SettingsSyncEnabler$Listener;", "Lcom/intellij/settingsSync/SettingsSyncStatusTracker$Listener;", "()V", "configPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "enableButton", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JButton;", "statusLabel", "Ljavax/swing/JLabel;", "syncEnabler", "Lcom/intellij/settingsSync/config/SettingsSyncEnabler;", "createPanel", "disableAndRemoveData", "", "disableSync", "disposeUIResources", "getReadableSyncTime", "", "getUserName", "serverStateCheckFinished", "state", "Lcom/intellij/settingsSync/ServerState;", "showEnableSyncDialog", "remoteSettingsFound", "", "showError", "message", "Lorg/jetbrains/annotations/Nls;", "details", "syncStatusChanged", "updateFromServerFinished", "result", "Lcom/intellij/settingsSync/UpdateResult;", "updateStatusInfo", "DisableResult", "EnabledPredicate", "LoggedInPredicate", "SyncEnablerRunning", "intellij.settingsSync"})
public final class SettingsSyncConfigurable
extends BoundConfigurable
implements SettingsSyncEnabler.Listener,
SettingsSyncStatusTracker.Listener {
    private DialogPanel configPanel;
    private Cell<? extends JButton> enableButton;
    private JLabel statusLabel;
    private final SettingsSyncEnabler syncEnabler = new SettingsSyncEnabler();
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_REMOVE_DATA_AND_DISABLE = 1;
    public static final int RESULT_DISABLE = 2;
    @NotNull
    public static final DisableResult DisableResult = new DisableResult(null);

    @NotNull
    public DialogPanel createPanel() {
        DialogPanel categoriesPanel = SettingsSyncPanelFactory.INSTANCE.createPanel(SettingsSyncBundle.INSTANCE.message("configurable.what.to.sync.label", new Object[0]));
        SettingsSyncAuthService authService = SettingsSyncAuthService.Companion.getInstance();
        this.configPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, authService, categoriesPanel){
            final /* synthetic */ SettingsSyncConfigurable this$0;
            final /* synthetic */ SettingsSyncAuthService $authService;
            final /* synthetic */ DialogPanel $categoriesPanel;

            public final void invoke(@NotNull Panel $this$panel) {
                ComponentPredicate isSyncEnabled = ComponentPredicateKt.and((ComponentPredicate)this.this$0.new LoggedInPredicate(), (ComponentPredicate)this.this$0.new EnabledPredicate());
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        Cell statusCell = $this$row.label("");
                        statusCell.visibleIf((ComponentPredicate)this.this$0.this$0.new LoggedInPredicate());
                        SettingsSyncConfigurable.access$setStatusLabel$p(this.this$0.this$0, (JLabel)statusCell.getComponent());
                        SettingsSyncConfigurable.access$updateStatusInfo(this.this$0.this$0);
                        $this$row.label(SettingsSyncBundle.INSTANCE.message("sync.status.login.message", new Object[0])).visibleIf(ComponentPredicateKt.not((ComponentPredicate)this.this$0.this$0.new LoggedInPredicate()));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null);
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(isSyncEnabled){
                    final /* synthetic */ ComponentPredicate $isSyncEnabled;

                    public final void invoke(@NotNull Row $this$row) {
                        Row.DefaultImpls.comment$default((Row)$this$row, (String)SettingsSyncBundle.INSTANCE.message("settings.sync.info.message", new Object[0]), (int)80, null, (int)4, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)this.$isSyncEnabled));
                    }
                    {
                        this.$isSyncEnabled = componentPredicate;
                        super(1);
                    }
                }), (int)1, null);
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this, isSyncEnabled){
                    final /* synthetic */ createPanel.1 this$0;
                    final /* synthetic */ ComponentPredicate $isSyncEnabled;

                    public final void invoke(@NotNull Row $this$row) {
                        $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.login", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this){
                            final /* synthetic */ createPanel.3 this$0;

                            public final void invoke(@NotNull ActionEvent it) {
                                this.this$0.this$0.$authService.login();
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }).visibleIf(ComponentPredicateKt.not((ComponentPredicate)this.this$0.this$0.new LoggedInPredicate())).enabled(this.this$0.$authService.isLoginAvailable());
                        JComponent jComponent = $this$row.label(SettingsSyncBundle.INSTANCE.message("error.label.login.not.available", new Object[0])).getComponent();
                        JLabel $this$apply = (JLabel)jComponent;
                        boolean bl = false;
                        $this$apply.setVisible(!this.this$0.$authService.isLoginAvailable());
                        $this$apply.setIcon(AllIcons.General.Error);
                        $this$apply.setForeground((Color)JBColor.red);
                        SettingsSyncConfigurable.access$setEnableButton$p(this.this$0.this$0, $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.enable", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this){
                            final /* synthetic */ createPanel.3 this$0;

                            public final void invoke(@NotNull ActionEvent it) {
                                SettingsSyncConfigurable.access$getSyncEnabler$p(this.this$0.this$0.this$0).checkServerState();
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }).visibleIf(ComponentPredicateKt.and((ComponentPredicate)this.this$0.this$0.new LoggedInPredicate(), (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)this.this$0.this$0.new EnabledPredicate()))).enabledIf(ComponentPredicateKt.not((ComponentPredicate)this.this$0.this$0.new SyncEnablerRunning())));
                        $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.disable", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this){
                            final /* synthetic */ createPanel.3 this$0;

                            public final void invoke(@NotNull ActionEvent it) {
                                ComponentPredicateKt.and((ComponentPredicate)this.this$0.this$0.this$0.new LoggedInPredicate(), (ComponentPredicate)this.this$0.this$0.this$0.new EnabledPredicate());
                                SettingsSyncConfigurable.access$disableSync(this.this$0.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }).visibleIf(this.$isSyncEnabled);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$isSyncEnabled = componentPredicate;
                        super(1);
                    }
                }), (int)1, null);
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        $this$row.cell((JComponent)this.this$0.$categoriesPanel).visibleIf(ComponentPredicateKt.and((ComponentPredicate)this.this$0.this$0.new LoggedInPredicate(), (ComponentPredicate)this.this$0.this$0.new EnabledPredicate())).onApply((Function0)new Function0<Unit>(this){
                            final /* synthetic */ createPanel.4 this$0;

                            public final void invoke() {
                                this.this$0.this$0.$categoriesPanel.apply();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }).onReset((Function0)new Function0<Unit>(this){
                            final /* synthetic */ createPanel.4 this$0;

                            public final void invoke() {
                                this.this$0.this$0.$categoriesPanel.reset();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }).onIsModified((Function0)new Function0<Boolean>(this){
                            final /* synthetic */ createPanel.4 this$0;

                            public final boolean invoke() {
                                return this.this$0.this$0.$categoriesPanel.isModified();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null);
            }
            {
                this.this$0 = settingsSyncConfigurable;
                this.$authService = settingsSyncAuthService;
                this.$categoriesPanel = dialogPanel;
                super(1);
            }
        }));
        SettingsSyncAuthService settingsSyncAuthService = SettingsSyncAuthService.Companion.getInstance();
        SettingsSyncAuthService.Listener listener = new SettingsSyncAuthService.Listener(this){
            final /* synthetic */ SettingsSyncConfigurable this$0;

            public void stateChanged() {
                if (SettingsSyncAuthService.Companion.getInstance().isLoggedIn() && !SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) {
                    SettingsSyncConfigurable.access$getSyncEnabler$p(this.this$0).checkServerState();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        settingsSyncAuthService.addListener(listener, disposable);
        DialogPanel dialogPanel = this.configPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
        }
        return dialogPanel;
    }

    @Override
    public void serverStateCheckFinished(@NotNull ServerState state) {
        block1: {
            ServerState serverState;
            block2: {
                block0: {
                    serverState = state;
                    if (!Intrinsics.areEqual((Object)serverState, (Object)ServerState.FileNotExists.INSTANCE)) break block0;
                    this.showEnableSyncDialog(false);
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)serverState, (Object)ServerState.UpToDate.INSTANCE) && !Intrinsics.areEqual((Object)serverState, (Object)ServerState.UpdateNeeded.INSTANCE)) break block2;
                this.showEnableSyncDialog(true);
                break block1;
            }
            if (!(serverState instanceof ServerState.Error) || !(Intrinsics.areEqual((Object)state, (Object)SettingsSyncEnabler.State.INSTANCE.getCANCELLED()) ^ true)) break block1;
            this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), ((ServerState.Error)state).getMessage());
        }
    }

    @Override
    public void updateFromServerFinished(@NotNull UpdateResult result2) {
        UpdateResult updateResult = result2;
        if (updateResult instanceof UpdateResult.Success) {
            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
        } else if (Intrinsics.areEqual((Object)updateResult, (Object)UpdateResult.NoFileOnServer.INSTANCE)) {
            this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), SettingsSyncBundle.INSTANCE.message("notification.title.update.no.such.file", new Object[0]));
        } else if (updateResult instanceof UpdateResult.Error) {
            this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), ((UpdateResult.Error)result2).getMessage());
        }
        this.updateStatusInfo();
    }

    private final void showEnableSyncDialog(boolean remoteSettingsFound) {
        block5: {
            EnableSettingsSyncDialog.Result result2;
            DialogPanel dialogPanel = this.configPanel;
            if (dialogPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            }
            EnableSettingsSyncDialog.Result result3 = EnableSettingsSyncDialog.Companion.showAndGetResult((JComponent)dialogPanel, remoteSettingsFound);
            if (result3 == null) break block5;
            EnableSettingsSyncDialog.Result it = result2 = result3;
            boolean bl = false;
            this.reset();
            switch (SettingsSyncConfigurable$WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    this.syncEnabler.getSettingsFromServer();
                    break;
                }
                case 2: {
                    SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
                    this.syncEnabler.pushSettingsToServer();
                }
            }
        }
    }

    private final void disableSync() {
        int result2 = Messages.showCheckboxMessageDialog((String)SettingsSyncBundle.INSTANCE.message("disable.dialog.text", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("disable.dialog.title", new Object[0]), (String[])new String[]{Messages.getCancelButton(), SettingsSyncBundle.INSTANCE.message("disable.dialog.disable.button", new Object[0])}, (String)SettingsSyncBundle.INSTANCE.message("disable.dialog.remove.data.box", new Object[0]), (boolean)false, (int)1, (int)1, (Icon)Messages.getInformationIcon(), (PairFunction)disableSync.result.1.INSTANCE);
        switch (result2) {
            case 2: {
                SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
                this.updateStatusInfo();
                break;
            }
            case 1: {
                this.disableAndRemoveData();
                break;
            }
        }
    }

    private final void disableAndRemoveData() {
        SettingsSyncRemoteCommunicator remoteCommunicator = SettingsSyncMain.Companion.getInstance().getRemoteCommunicator$intellij_settingsSync();
        new Task.Modal(this, remoteCommunicator, null, SettingsSyncBundle.INSTANCE.message("disable.remove.data.title", new Object[0]), false){
            final /* synthetic */ SettingsSyncConfigurable this$0;
            final /* synthetic */ SettingsSyncRemoteCommunicator $remoteCommunicator;

            public void run(@NotNull ProgressIndicator indicator) {
                SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
                this.$remoteCommunicator.delete();
            }

            public void onThrowable(@NotNull Throwable error) {
                SettingsSyncConfigurable.access$showError(this.this$0, SettingsSyncBundle.INSTANCE.message("disable.remove.data.failure", new Object[0]), error.getLocalizedMessage());
            }

            public void onSuccess() {
                SettingsSyncConfigurable.access$updateStatusInfo(this.this$0);
            }
            {
                this.this$0 = this$0;
                this.$remoteCommunicator = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    private final void showError(String message, String details) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.failed", new Object[0]));
        JLabel jLabel = this.statusLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
        }
        jLabel.setIcon(AllIcons.General.Error);
        messageBuilder.append(' ').append(message + ": " + details);
        JLabel jLabel2 = this.statusLabel;
        if (jLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
        }
        jLabel2.setText(messageBuilder.toString());
    }

    private final void updateStatusInfo() {
        if (this.statusLabel != null) {
            StringBuilder messageBuilder = new StringBuilder();
            JLabel jLabel = this.statusLabel;
            if (jLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            }
            jLabel.setIcon(null);
            if (SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) {
                SettingsSyncStatusTracker statusTracker = SettingsSyncStatusTracker.Companion.getInstance();
                if (statusTracker.isSyncSuccessful()) {
                    messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.enabled", new Object[0]));
                    if (statusTracker.isSynced()) {
                        messageBuilder.append(' ').append(SettingsSyncBundle.INSTANCE.message("sync.status.last.sync.message", this.getReadableSyncTime(), this.getUserName()));
                    }
                } else {
                    messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.failed", new Object[0]));
                    JLabel jLabel2 = this.statusLabel;
                    if (jLabel2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
                    }
                    jLabel2.setIcon(AllIcons.General.Error);
                    messageBuilder.append(' ').append(statusTracker.getErrorMessage());
                }
            } else {
                messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.disabled", new Object[0]));
            }
            JLabel jLabel3 = this.statusLabel;
            if (jLabel3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            }
            jLabel3.setText(messageBuilder.toString());
        }
    }

    private final String getReadableSyncTime() {
        String string = DateFormatUtil.formatPrettyDateTime((long)SettingsSyncStatusTracker.Companion.getInstance().getLastSyncTime());
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string2;
    }

    private final String getUserName() {
        Object object = SettingsSyncAuthService.Companion.getInstance().getUserData();
        if (object == null || (object = object.loginName) == null) {
            object = "?";
        }
        return object;
    }

    @Override
    public void syncStatusChanged() {
        this.updateStatusInfo();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        SettingsSyncStatusTracker.Companion.getInstance().removeListener(this);
    }

    public SettingsSyncConfigurable() {
        super(SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]), null, 2, null);
        this.syncEnabler.addListener(this);
        SettingsSyncStatusTracker.Companion.getInstance().addListener(this);
    }

    @Override
    public void serverStateCheckStarted() {
        SettingsSyncEnabler.Listener.DefaultImpls.serverStateCheckStarted(this);
    }

    @Override
    public void updateFromServerStarted() {
        SettingsSyncEnabler.Listener.DefaultImpls.updateFromServerStarted(this);
    }

    @Override
    public void serverRequestStarted() {
        SettingsSyncEnabler.Listener.DefaultImpls.serverRequestStarted(this);
    }

    @Override
    public void serverRequestFinished() {
        SettingsSyncEnabler.Listener.DefaultImpls.serverRequestFinished(this);
    }

    public static final /* synthetic */ JLabel access$getStatusLabel$p(SettingsSyncConfigurable $this) {
        JLabel jLabel = $this.statusLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
        }
        return jLabel;
    }

    public static final /* synthetic */ void access$setStatusLabel$p(SettingsSyncConfigurable $this, JLabel jLabel) {
        $this.statusLabel = jLabel;
    }

    public static final /* synthetic */ void access$updateStatusInfo(SettingsSyncConfigurable $this) {
        $this.updateStatusInfo();
    }

    public static final /* synthetic */ Cell access$getEnableButton$p(SettingsSyncConfigurable $this) {
        Cell<? extends JButton> cell = $this.enableButton;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"enableButton");
        }
        return cell;
    }

    public static final /* synthetic */ void access$setEnableButton$p(SettingsSyncConfigurable $this, Cell cell) {
        $this.enableButton = cell;
    }

    public static final /* synthetic */ void access$disableSync(SettingsSyncConfigurable $this) {
        $this.disableSync();
    }

    public static final /* synthetic */ void access$showError(SettingsSyncConfigurable $this, String message, String details) {
        $this.showError(message, details);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$LoggedInPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class LoggedInPredicate
    extends ComponentPredicate {
        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            SettingsSyncAuthService settingsSyncAuthService = SettingsSyncAuthService.Companion.getInstance();
            SettingsSyncAuthService.Listener listener2 = new SettingsSyncAuthService.Listener(this, listener){
                final /* synthetic */ LoggedInPredicate this$0;
                final /* synthetic */ Function1 $listener;

                public void stateChanged() {
                    this.$listener.invoke((Object)this.this$0.invoke());
                }
                {
                    this.this$0 = this$0;
                    this.$listener = $captured_local_variable$1;
                }
            };
            Disposable disposable = SettingsSyncConfigurable.this.getDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            settingsSyncAuthService.addListener(listener2, disposable);
        }

        @NotNull
        public Boolean invoke() {
            return SettingsSyncAuthService.Companion.getInstance().isLoggedIn();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$EnabledPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class EnabledPredicate
    extends ComponentPredicate {
        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            SettingsSyncEvents settingsSyncEvents = SettingsSyncEvents.Companion.getInstance();
            SettingsSyncEnabledStateListener settingsSyncEnabledStateListener = new SettingsSyncEnabledStateListener(this, listener){
                final /* synthetic */ EnabledPredicate this$0;
                final /* synthetic */ Function1 $listener;

                public void enabledStateChanged(boolean syncEnabled) {
                    this.$listener.invoke((Object)this.this$0.invoke());
                }
                {
                    this.this$0 = this$0;
                    this.$listener = $captured_local_variable$1;
                }
            };
            Disposable disposable = SettingsSyncConfigurable.this.getDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            settingsSyncEvents.addEnabledStateChangeListener(settingsSyncEnabledStateListener, disposable);
        }

        @NotNull
        public Boolean invoke() {
            return SettingsSyncSettings.Companion.getInstance().getSyncEnabled();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u000e\u0010\t\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$SyncEnablerRunning;", "Lcom/intellij/ui/layout/ComponentPredicate;", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "isRunning", "", "addListener", "", "listener", "Lkotlin/Function1;", "invoke", "()Ljava/lang/Boolean;", "updateRunning", "intellij.settingsSync"})
    public final class SyncEnablerRunning
    extends ComponentPredicate {
        private boolean isRunning;

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            SettingsSyncConfigurable.this.syncEnabler.addListener(new SettingsSyncEnabler.Listener(this, listener){
                final /* synthetic */ SyncEnablerRunning this$0;
                final /* synthetic */ Function1 $listener;

                public void serverRequestStarted() {
                    SyncEnablerRunning.access$updateRunning(this.this$0, this.$listener, true);
                }

                public void serverRequestFinished() {
                    SyncEnablerRunning.access$updateRunning(this.this$0, this.$listener, false);
                }
                {
                    this.this$0 = this$0;
                    this.$listener = $captured_local_variable$1;
                }

                public void serverStateCheckStarted() {
                    SettingsSyncEnabler.Listener.DefaultImpls.serverStateCheckStarted(this);
                }

                public void serverStateCheckFinished(@NotNull ServerState state) {
                    SettingsSyncEnabler.Listener.DefaultImpls.serverStateCheckFinished(this, state);
                }

                public void updateFromServerStarted() {
                    SettingsSyncEnabler.Listener.DefaultImpls.updateFromServerStarted(this);
                }

                public void updateFromServerFinished(@NotNull UpdateResult result2) {
                    SettingsSyncEnabler.Listener.DefaultImpls.updateFromServerFinished(this, result2);
                }
            });
        }

        private final void updateRunning(Function1<? super Boolean, Unit> listener, boolean isRunning) {
            this.isRunning = isRunning;
            listener.invoke((Object)this.invoke());
        }

        @NotNull
        public Boolean invoke() {
            return this.isRunning;
        }

        public static final /* synthetic */ void access$updateRunning(SyncEnablerRunning $this, Function1 listener, boolean isRunning) {
            $this.updateRunning((Function1<? super Boolean, Unit>)listener, isRunning);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$DisableResult;", "", "()V", "RESULT_CANCEL", "", "RESULT_DISABLE", "RESULT_REMOVE_DATA_AND_DISABLE", "intellij.settingsSync"})
    public static final class DisableResult {
        private DisableResult() {
        }

        public /* synthetic */ DisableResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

