/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.openapi.components.SettingsCategory;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.config.SettingsSyncPluginsGroup;
import com.intellij.settingsSync.config.SettingsSyncSubcategoryDescriptor;
import com.intellij.settingsSync.config.SettingsSyncSubcategoryGroup;
import com.intellij.settingsSync.config.SettingsSyncUiGroup;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00070\b\u00a2\u0006\u0002\b\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/settingsSync/config/SettingsCategoryDescriptor;", "", "category", "Lcom/intellij/openapi/components/SettingsCategory;", "secondaryGroup", "Lcom/intellij/settingsSync/config/SettingsSyncSubcategoryGroup;", "(Lcom/intellij/openapi/components/SettingsCategory;Lcom/intellij/settingsSync/config/SettingsSyncSubcategoryGroup;)V", "categoryKey", "", "getCategoryKey", "()Ljava/lang/String;", "description", "Lorg/jetbrains/annotations/Nls;", "getDescription", "isSynchronized", "", "()Z", "setSynchronized", "(Z)V", "name", "getName", "getSecondaryGroup", "()Lcom/intellij/settingsSync/config/SettingsSyncSubcategoryGroup;", "apply", "", "isModified", "reset", "Companion", "intellij.settingsSync"})
public final class SettingsCategoryDescriptor {
    private boolean isSynchronized;
    private final SettingsCategory category;
    @Nullable
    private final SettingsSyncSubcategoryGroup secondaryGroup;
    private static final List<SettingsCategoryDescriptor> DESCRIPTORS;
    @NotNull
    public static final Companion Companion;

    public final boolean isSynchronized() {
        return this.isSynchronized;
    }

    public final void setSynchronized(boolean bl) {
        this.isSynchronized = bl;
    }

    public final void reset() {
        this.isSynchronized = SettingsSyncSettings.Companion.getInstance().isCategoryEnabled(this.category);
        if (this.secondaryGroup != null) {
            Iterable $this$forEach$iv = this.secondaryGroup.getDescriptors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SettingsSyncSubcategoryDescriptor it = (SettingsSyncSubcategoryDescriptor)element$iv;
                boolean bl = false;
                it.setSelected(this.isSynchronized && SettingsSyncSettings.Companion.getInstance().isSubcategoryEnabled(this.category, it.getId()));
            }
        }
    }

    public final void apply() {
        if (this.secondaryGroup != null) {
            Iterable $this$forEach$iv = this.secondaryGroup.getDescriptors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SettingsSyncSubcategoryDescriptor it = (SettingsSyncSubcategoryDescriptor)element$iv;
                boolean bl = false;
                SettingsSyncSettings.Companion.getInstance().setSubcategoryEnabled(this.category, it.getId(), !this.isSynchronized || it.isSelected());
            }
        }
        SettingsSyncSettings.Companion.getInstance().setCategoryEnabled(this.category, this.isSynchronized);
    }

    public final boolean isModified() {
        if (this.isSynchronized != SettingsSyncSettings.Companion.getInstance().isCategoryEnabled(this.category)) {
            return true;
        }
        if (this.secondaryGroup != null && this.isSynchronized) {
            Iterable $this$forEach$iv = this.secondaryGroup.getDescriptors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SettingsSyncSubcategoryDescriptor it = (SettingsSyncSubcategoryDescriptor)element$iv;
                boolean bl = false;
                if (it.isSelected() == SettingsSyncSettings.Companion.getInstance().isSubcategoryEnabled(this.category, it.getId())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final String getName() {
        return SettingsSyncBundle.INSTANCE.message(this.getCategoryKey() + ".name", new Object[0]);
    }

    @NotNull
    public final String getDescription() {
        return SettingsSyncBundle.INSTANCE.message(this.getCategoryKey() + ".description", new Object[0]);
    }

    private final String getCategoryKey() {
        String string = this.category.name();
        Locale locale = Locale.getDefault();
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        return "settings.category." + string2;
    }

    @Nullable
    public final SettingsSyncSubcategoryGroup getSecondaryGroup() {
        return this.secondaryGroup;
    }

    public SettingsCategoryDescriptor(@NotNull SettingsCategory category, @Nullable SettingsSyncSubcategoryGroup secondaryGroup) {
        this.category = category;
        this.secondaryGroup = secondaryGroup;
        this.isSynchronized = true;
    }

    public /* synthetic */ SettingsCategoryDescriptor(SettingsCategory settingsCategory, SettingsSyncSubcategoryGroup settingsSyncSubcategoryGroup, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            settingsSyncSubcategoryGroup = null;
        }
        this(settingsCategory, settingsSyncSubcategoryGroup);
    }

    static {
        Companion = new Companion(null);
        DESCRIPTORS = CollectionsKt.listOf((Object[])new SettingsCategoryDescriptor[]{new SettingsCategoryDescriptor(SettingsCategory.UI, new SettingsSyncUiGroup()), new SettingsCategoryDescriptor(SettingsCategory.KEYMAP, null, 2, null), new SettingsCategoryDescriptor(SettingsCategory.CODE, null, 2, null), new SettingsCategoryDescriptor(SettingsCategory.PLUGINS, new SettingsSyncPluginsGroup()), new SettingsCategoryDescriptor(SettingsCategory.TOOLS, null, 2, null), new SettingsCategoryDescriptor(SettingsCategory.SYSTEM, null, 2, null)});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/SettingsCategoryDescriptor$Companion;", "", "()V", "DESCRIPTORS", "", "Lcom/intellij/settingsSync/config/SettingsCategoryDescriptor;", "listAll", "intellij.settingsSync"})
    public static final class Companion {
        @NotNull
        public final List<SettingsCategoryDescriptor> listAll() {
            return DESCRIPTORS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

