/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.FrameStateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.settingsSync.SettingsSyncEnabledStateListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSynchronizer;
import com.intellij.settingsSync.plugins.SettingsSyncPluginManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\rH\u0003J\b\u0010\u001b\u001a\u00020\u000fH\u0003R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/settingsSync/SettingsSynchronizer;", "Lcom/intellij/ide/ApplicationInitializedListener;", "Lcom/intellij/ide/FrameStateListener;", "Lcom/intellij/settingsSync/SettingsSyncEnabledStateListener;", "()V", "autoSyncDelay", "", "getAutoSyncDelay", "()J", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "componentsInitialized", "", "enabledStateChanged", "syncEnabled", "", "initializeSyncing", "Ljava/lang/Runnable;", "onFrameActivated", "onFrameDeactivated", "scheduleSyncing", "logMessage", "", "setupSyncingByTimer", "stopSyncingByTimer", "Companion", "intellij.settingsSync"})
public final class SettingsSynchronizer
implements ApplicationInitializedListener,
FrameStateListener,
SettingsSyncEnabledStateListener {
    private final ScheduledExecutorService executorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Settings Sync Update", (int)1);
    private ScheduledFuture<?> scheduledFuture;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final long getAutoSyncDelay() {
        return Registry.intValue((String)"settingsSync.autoSync.frequency.sec", (int)60);
    }

    public void componentsInitialized() {
        if (!SettingsSyncMainKt.isSettingsSyncEnabledByKey()) {
            return;
        }
        SettingsSyncPluginManager.Companion.getInstance();
        SettingsSyncEvents.addEnabledStateChangeListener$default(SettingsSyncEvents.Companion.getInstance(), this, null, 2, null);
        if (SettingsSyncMainKt.isSettingsSyncEnabledInSettings()) {
            this.executorService.schedule(this.initializeSyncing(), 0L, TimeUnit.SECONDS);
            return;
        }
    }

    public void onFrameActivated() {
        if (!(SettingsSyncMainKt.isSettingsSyncEnabledByKey() && SettingsSyncMainKt.isSettingsSyncEnabledInSettings() && SettingsSyncMain.Companion.isAvailable())) {
            return;
        }
        if (this.getAutoSyncDelay() > 0L && this.scheduledFuture == null) {
            this.scheduledFuture = this.setupSyncingByTimer();
        }
        if (Registry.is((String)"settingsSync.autoSync.on.focus", (boolean)true)) {
            this.scheduleSyncing("Syncing settings on app focus");
        }
    }

    public void onFrameDeactivated() {
        this.stopSyncingByTimer();
    }

    private final Runnable initializeSyncing() {
        return initializeSyncing.1.INSTANCE;
    }

    @Override
    public void enabledStateChanged(boolean syncEnabled) {
        if (!syncEnabled) {
            this.stopSyncingByTimer();
            SettingsSyncMain.Companion.getInstance().disableSyncing();
        }
    }

    private final void scheduleSyncing(String logMessage) {
        this.executorService.schedule(new Runnable(logMessage){
            final /* synthetic */ String $logMessage;

            public final void run() {
                SettingsSynchronizer.Companion.getLOG().info(this.$logMessage);
                SettingsSyncMain.Companion.getInstance().syncSettings$intellij_settingsSync();
            }
            {
                this.$logMessage = string;
            }
        }, 0L, TimeUnit.SECONDS);
    }

    @RequiresEdt
    private final ScheduledFuture<?> setupSyncingByTimer() {
        long delay = this.getAutoSyncDelay();
        return this.executorService.scheduleWithFixedDelay(setupSyncingByTimer.1.INSTANCE, delay, delay, TimeUnit.SECONDS);
    }

    @RequiresEdt
    private final void stopSyncingByTimer() {
        if (this.scheduledFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/SettingsSynchronizer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

