/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncTroubleshootingAction;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.io.Compressor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.cloudconfig.FileVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "TroubleshootingDialog", "intellij.settingsSync"})
public final class SettingsSyncTroubleshootingAction
extends DumbAwareAction {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && SettingsSyncMainKt.isSettingsSyncEnabledByKey());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block3: {
            SettingsSyncRemoteCommunicator remoteCommunicator = SettingsSyncMain.Companion.getInstance().getRemoteCommunicator$intellij_settingsSync();
            if (!(remoteCommunicator instanceof CloudConfigServerCommunicator)) {
                Messages.showErrorDialog((Project)e.getProject(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.wrong.configuration", Reflection.getOrCreateKotlinClass(remoteCommunicator.getClass())), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.title", new Object[0]));
                return;
            }
            try {
                FileVersionInfo version2 = (FileVersionInfo)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(remoteCommunicator){
                    final /* synthetic */ SettingsSyncRemoteCommunicator $remoteCommunicator;

                    @Nullable
                    public final FileVersionInfo compute() {
                        return ((CloudConfigServerCommunicator)this.$remoteCommunicator).getLatestVersion();
                    }
                    {
                        this.$remoteCommunicator = settingsSyncRemoteCommunicator;
                    }
                }, SettingsSyncBundle.INSTANCE.message("troubleshooting.loading.info.progress.dialog.title", new Object[0]), false, e.getProject());
                new TroubleshootingDialog(e.getProject(), (CloudConfigServerCommunicator)remoteCommunicator, version2).show();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                if (Messages.showOkCancelDialog((Project)e.getProject(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.check.log.file.for.errors", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.loading.info.failed", new Object[0]), (String)ShowLogAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) != 0) break block3;
                ShowLogAction.showLog();
            }
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncTroubleshootingAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J0\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\"\u001a\n #*\u0004\u0018\u00010\u001f0\u001f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0007H\u0002J\u001a\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)2\b\b\u0001\u0010*\u001a\u00020\u001fH\u0002J\"\u0010+\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-*\u00020/2\n\b\u0001\u00100\u001a\u0004\u0018\u000101H\u0002J\u0016\u00102\u001a\u00020/*\u0002032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u00104\u001a\u00020/*\u0002032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u00105\u001a\u00020/*\u0002032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\f\u00106\u001a\u00020/*\u000203H\u0002J\u001c\u00107\u001a\u00020/*\u0002032\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TroubleshootingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "remoteCommunicator", "Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "latestVersion", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/settingsSync/CloudConfigServerCommunicator;Lcom/jetbrains/cloudconfig/FileVersionInfo;)V", "getLatestVersion", "()Lcom/jetbrains/cloudconfig/FileVersionInfo;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRemoteCommunicator", "()Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "userData", "Lcom/intellij/ui/JBAccountInfoService$JBAData;", "getUserData", "()Lcom/intellij/ui/JBAccountInfoService$JBAData;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "deleteFile", "", "downloadFullHistory", "history", "", "loginName", "", "downloadVersion", "version", "formatDate", "kotlin.jvm.PlatformType", "date", "Ljava/util/Date;", "getSnapshotFileName", "showFileDownloadedMessage", "zipFile", "Ljava/io/File;", "message", "showHistoryDialog", "copyableLabel", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBLabel;", "Lcom/intellij/ui/dsl/builder/Row;", "text", "", "emailRow", "Lcom/intellij/ui/dsl/builder/Panel;", "loginNameRow", "serverUrlRow", "statusRow", "versionRow", "intellij.settingsSync"})
    private static final class TroubleshootingDialog
    extends DialogWrapper {
        @Nullable
        private final JBAccountInfoService.JBAData userData;
        @Nullable
        private final Project project;
        @NotNull
        private final CloudConfigServerCommunicator remoteCommunicator;
        @Nullable
        private final FileVersionInfo latestVersion;

        @Nullable
        public final JBAccountInfoService.JBAData getUserData() {
            return this.userData;
        }

        @NotNull
        protected Action[] createActions() {
            this.setCancelButtonText(CommonBundle.getCloseButtonText());
            this.getCancelAction().putValue("DefaultAction", true);
            return new Action[]{this.getCancelAction()};
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
                final /* synthetic */ TroubleshootingDialog this$0;

                public final void invoke(@NotNull Panel $this$panel) {
                    TroubleshootingDialog.access$statusRow(this.this$0, $this$panel);
                    TroubleshootingDialog.access$serverUrlRow(this.this$0, $this$panel, this.this$0.getRemoteCommunicator());
                    TroubleshootingDialog.access$loginNameRow(this.this$0, $this$panel, this.this$0.getUserData());
                    TroubleshootingDialog.access$emailRow(this.this$0, $this$panel, this.this$0.getUserData());
                    if (this.this$0.getLatestVersion() == null) {
                        Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)TroubleshootingDialog.createCenterPanel.1.INSTANCE, (int)1, null);
                    } else {
                        Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)createCenterPanel.2.INSTANCE, (int)1, null);
                        TroubleshootingDialog.access$versionRow(this.this$0, $this$panel, this.this$0.getLatestVersion(), this.this$0.getRemoteCommunicator());
                        Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                            final /* synthetic */ createCenterPanel.1 this$0;

                            public final void invoke(@NotNull Row $this$row) {
                                $this$row.button(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.show.history.button", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this){
                                    final /* synthetic */ createCenterPanel.3 this$0;

                                    public final void invoke(@NotNull ActionEvent it) {
                                        TroubleshootingDialog troubleshootingDialog = this.this$0.this$0.this$0;
                                        Project project = this.this$0.this$0.this$0.getProject();
                                        CloudConfigServerCommunicator cloudConfigServerCommunicator = this.this$0.this$0.this$0.getRemoteCommunicator();
                                        JBAccountInfoService.JBAData jBAData = this.this$0.this$0.this$0.getUserData();
                                        String string = jBAData != null ? jBAData.loginName : null;
                                        Intrinsics.checkNotNull((Object)string);
                                        TroubleshootingDialog.access$showHistoryDialog(troubleshootingDialog, project, cloudConfigServerCommunicator, string);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                                $this$row.button(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.delete.button", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this){
                                    final /* synthetic */ createCenterPanel.3 this$0;

                                    public final void invoke(@NotNull ActionEvent it) {
                                        TroubleshootingDialog.access$deleteFile(this.this$0.this$0.this$0, this.this$0.this$0.this$0.getProject(), this.this$0.this$0.this$0.getRemoteCommunicator());
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)1, null);
                    }
                }
                {
                    this.this$0 = troubleshootingDialog;
                    super(1);
                }
            }));
        }

        private final Row statusRow(Panel $this$statusRow) {
            return Panel.DefaultImpls.row$default((Panel)$this$statusRow, null, (Function1)statusRow.1.INSTANCE, (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row serverUrlRow(Panel $this$serverUrlRow, CloudConfigServerCommunicator remoteCommunicator) {
            return Panel.DefaultImpls.row$default((Panel)$this$serverUrlRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, remoteCommunicator){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ CloudConfigServerCommunicator $remoteCommunicator;

                public final void invoke(@NotNull Row $this$row) {
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.server.url.label", new Object[0]));
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, this.$remoteCommunicator.getUrl$intellij_settingsSync());
                }
                {
                    this.this$0 = troubleshootingDialog;
                    this.$remoteCommunicator = cloudConfigServerCommunicator;
                    super(1);
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row loginNameRow(Panel $this$loginNameRow, JBAccountInfoService.JBAData userData) {
            return Panel.DefaultImpls.row$default((Panel)$this$loginNameRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, userData){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ JBAccountInfoService.JBAData $userData;

                public final void invoke(@NotNull Row $this$row) {
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.login.label", new Object[0]));
                    JBAccountInfoService.JBAData jBAData = this.$userData;
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, jBAData != null ? jBAData.loginName : null);
                }
                {
                    this.this$0 = troubleshootingDialog;
                    this.$userData = jBAData;
                    super(1);
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row emailRow(Panel $this$emailRow, JBAccountInfoService.JBAData userData) {
            return Panel.DefaultImpls.row$default((Panel)$this$emailRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, userData){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ JBAccountInfoService.JBAData $userData;

                public final void invoke(@NotNull Row $this$row) {
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.email.label", new Object[0]));
                    JBAccountInfoService.JBAData jBAData = this.$userData;
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, jBAData != null ? jBAData.email : null);
                }
                {
                    this.this$0 = troubleshootingDialog;
                    this.$userData = jBAData;
                    super(1);
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row versionRow(Panel $this$versionRow, FileVersionInfo version2, CloudConfigServerCommunicator remoteCommunicator) {
            return Panel.DefaultImpls.row$default((Panel)$this$versionRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, version2, remoteCommunicator){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ FileVersionInfo $version;
                final /* synthetic */ CloudConfigServerCommunicator $remoteCommunicator;

                public final void invoke(@NotNull Row $this$row) {
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.version.date.label", new Object[0]));
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, TroubleshootingDialog.access$formatDate(this.this$0, this.$version.getModifiedDate()));
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.version.id.label", new Object[0]));
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, this.$version.getVersionId());
                    Row.DefaultImpls.actionButton$default((Row)$this$row, (AnAction)((AnAction)new DumbAwareAction(this, AllIcons.Actions.Download){
                        final /* synthetic */ versionRow.1 this$0;

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            TroubleshootingDialog.access$downloadVersion(this.this$0.this$0, this.this$0.$remoteCommunicator, this.this$0.$version, e.getProject());
                        }
                        {
                            this.this$0 = this$0;
                            super($super_call_param$1);
                        }
                    }), null, (int)2, null);
                }
                {
                    this.this$0 = troubleshootingDialog;
                    this.$version = fileVersionInfo;
                    this.$remoteCommunicator = cloudConfigServerCommunicator;
                    super(1);
                }
            }), (int)1, null);
        }

        private final void downloadVersion(CloudConfigServerCommunicator remoteCommunicator, FileVersionInfo version2, Project project) {
            File zipFile2 = (File)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(this, remoteCommunicator, version2){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ CloudConfigServerCommunicator $remoteCommunicator;
                final /* synthetic */ FileVersionInfo $version;

                public final File compute() {
                    File file;
                    InputStream inputStream = this.$remoteCommunicator.downloadSnapshot(this.$version);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStream stream2 = inputStream;
                    try {
                        File tempFile = FileUtil.createTempFile((String)TroubleshootingDialog.access$getSnapshotFileName(this.this$0, this.$version), null);
                        FileUtil.writeToFile((File)tempFile, (byte[])stream2.readAllBytes());
                    }
                    catch (Throwable e) {
                        SettingsSyncTroubleshootingAction.Companion.getLOG().error(e);
                        file = null;
                    }
                    return file;
                }
                {
                    this.this$0 = troubleshootingDialog;
                    this.$remoteCommunicator = cloudConfigServerCommunicator;
                    this.$version = fileVersionInfo;
                }
            }, SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.downloading.settings.from.server.progress.title", new Object[0]), false, project);
            if (zipFile2 != null) {
                this.showFileDownloadedMessage(zipFile2, SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.successfully.downloaded.message", new Object[0]));
            } else if (Messages.showOkCancelDialog((Component)this.getContentPane(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.check.log.file.for.errors", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.download.zip.file.failed", new Object[0]), (String)ShowLogAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) == 0) {
                ShowLogAction.showLog();
            }
        }

        private final String getSnapshotFileName(FileVersionInfo version2) {
            return "settings-sync-snapshot-" + this.formatDate(version2.getModifiedDate()) + ".zip";
        }

        private final String formatDate(Date date) {
            return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US).format(date);
        }

        private final void showFileDownloadedMessage(File zipFile2, @Nls String message) {
            if (Messages.showOkCancelDialog((Component)this.getContentPane(), (String)message, (String)"", (String)RevealFileAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) == 0) {
                RevealFileAction.openFile((File)zipFile2);
            }
        }

        private final void showHistoryDialog(Project project, CloudConfigServerCommunicator remoteCommunicator, String loginName) {
            List history2 = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(remoteCommunicator){
                final /* synthetic */ CloudConfigServerCommunicator $remoteCommunicator;

                public final List<FileVersionInfo> compute() {
                    return this.$remoteCommunicator.fetchHistory();
                }
                {
                    this.$remoteCommunicator = cloudConfigServerCommunicator;
                }
            }, SettingsSyncBundle.INSTANCE.message("troubleshooting.fetching.history.progress.title", new Object[0]), false, project);
            DialogBuilder dialogBuilder = new DialogBuilder((Component)this.getContentPane()).title(SettingsSyncBundle.INSTANCE.message("troubleshooting.settings.history.dialog.title", new Object[0]));
            DialogPanel historyPanel2 = (DialogPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, history2, remoteCommunicator){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ List $history;
                final /* synthetic */ CloudConfigServerCommunicator $remoteCommunicator;

                public final void invoke(@NotNull Panel $this$panel) {
                    for (FileVersionInfo version2 : this.$history) {
                        TroubleshootingDialog.access$versionRow(this.this$0, $this$panel, version2, this.$remoteCommunicator).layout(RowLayout.PARENT_GRID);
                    }
                }
                {
                    this.this$0 = troubleshootingDialog;
                    this.$history = list;
                    this.$remoteCommunicator = cloudConfigServerCommunicator;
                    super(1);
                }
            })).withBorder((Border)JBUI.Borders.empty((int)4, (int)10, (int)4, (int)10));
            JButton button = new JButton(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.download.full.history.button", new Object[0]));
            button.addActionListener(new ActionListener(this, project, remoteCommunicator, history2, loginName){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ CloudConfigServerCommunicator $remoteCommunicator;
                final /* synthetic */ List $history;
                final /* synthetic */ String $loginName;

                public final void actionPerformed(ActionEvent it) {
                    TroubleshootingDialog.access$downloadFullHistory(this.this$0, this.$project, this.$remoteCommunicator, this.$history, this.$loginName);
                }
                {
                    this.this$0 = troubleshootingDialog;
                    this.$project = project;
                    this.$remoteCommunicator = cloudConfigServerCommunicator;
                    this.$history = list;
                    this.$loginName = string;
                }
            });
            JBScrollPane scrollPanel = new JBScrollPane((Component)historyPanel2, 20, 30);
            BorderLayoutPanel mainPanel = JBUI.Panels.simplePanel();
            mainPanel.add((Component)scrollPanel, (Object)"Center");
            mainPanel.add((Component)button, (Object)"South");
            dialogBuilder.centerPanel((JComponent)mainPanel);
            dialogBuilder.addCloseButton();
            dialogBuilder.show();
        }

        private final void downloadFullHistory(Project project, CloudConfigServerCommunicator remoteCommunicator, List<? extends FileVersionInfo> history2, String loginName) {
            File compoundZip2 = (File)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(this, loginName, history2, remoteCommunicator){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ String $loginName;
                final /* synthetic */ List $history;
                final /* synthetic */ CloudConfigServerCommunicator $remoteCommunicator;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                @NotNull
                public final File compute() {
                    void var2_2;
                    String fileName = "settings-server-history-" + FileUtil.sanitizeFileName((String)this.$loginName) + "-" + TroubleshootingDialog.access$formatDate(this.this$0, new Date()) + ".zip";
                    File zipFile2 = FileUtil.createTempFile((String)fileName, null);
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    indicator.setIndeterminate(false);
                    Closeable closeable = (Closeable)new Compressor.Zip(zipFile2);
                    Throwable throwable = null;
                    try {
                        Compressor.Zip zip = (Compressor.Zip)closeable;
                        boolean bl = false;
                        boolean bl2 = false;
                        for (FileVersionInfo version2 : (Iterable)this.$history) {
                            void step;
                            indicator.checkCanceled();
                            indicator.setFraction((double)step / (double)this.$history.size());
                            InputStream stream2 = this.$remoteCommunicator.downloadSnapshot(version2);
                            if (stream2 != null) {
                                zip.addFile(TroubleshootingDialog.access$getSnapshotFileName(this.this$0, version2), stream2);
                            } else {
                                SettingsSyncTroubleshootingAction.Companion.getLOG().warn("Couldn't download snapshot for version made on " + version2.getModifiedDate());
                            }
                            ++step;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return var2_2;
                }
                {
                    this.this$0 = troubleshootingDialog;
                    this.$loginName = string;
                    this.$history = list;
                    this.$remoteCommunicator = cloudConfigServerCommunicator;
                }
            }, SettingsSyncBundle.INSTANCE.message("troubleshooting.fetching.history.progress.title", new Object[0]), true, project);
            this.showFileDownloadedMessage(compoundZip2, SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.download.full.history.success.message", new Object[0]));
        }

        private final void deleteFile(Project project, CloudConfigServerCommunicator remoteCommunicator) {
            int choice = Messages.showOkCancelDialog((Component)this.getContentPane(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.message", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.title", new Object[0]), (String)IdeBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), null);
            if (choice == 0) {
                try {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(remoteCommunicator){
                        final /* synthetic */ CloudConfigServerCommunicator $remoteCommunicator;

                        public final void compute() {
                            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
                            this.$remoteCommunicator.delete();
                        }
                        {
                            this.$remoteCommunicator = cloudConfigServerCommunicator;
                        }
                    }, SettingsSyncBundle.INSTANCE.message("troubleshooting.delete.file.from.server.progress.title", new Object[0]), false, project);
                }
                catch (Exception e) {
                    Companion.getLOG().warn("Couldn't delete settings.sync.snapshot.zip from server", (Throwable)e);
                    Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.title", new Object[0]));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Cell<JBLabel> copyableLabel(Row $this$copyableLabel, @NlsSafe Object text) {
            void $this$apply;
            JBLabel jBLabel;
            JBLabel jBLabel2 = jBLabel = new JBLabel(String.valueOf(text));
            Row row = $this$copyableLabel;
            boolean bl = false;
            $this$apply.setCopyable(true);
            Unit unit = Unit.INSTANCE;
            return row.cell((JComponent)jBLabel);
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final CloudConfigServerCommunicator getRemoteCommunicator() {
            return this.remoteCommunicator;
        }

        @Nullable
        public final FileVersionInfo getLatestVersion() {
            return this.latestVersion;
        }

        public TroubleshootingDialog(@Nullable Project project, @NotNull CloudConfigServerCommunicator remoteCommunicator, @Nullable FileVersionInfo latestVersion) {
            super(project, true);
            this.project = project;
            this.remoteCommunicator = remoteCommunicator;
            this.latestVersion = latestVersion;
            this.userData = SettingsSyncAuthService.Companion.getInstance().getUserData();
            this.setTitle(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.title", new Object[0]));
            this.init();
        }

        public static final /* synthetic */ Row access$statusRow(TroubleshootingDialog $this, Panel $this$access_u24statusRow) {
            return $this.statusRow($this$access_u24statusRow);
        }

        public static final /* synthetic */ Row access$serverUrlRow(TroubleshootingDialog $this, Panel $this$access_u24serverUrlRow, CloudConfigServerCommunicator remoteCommunicator) {
            return $this.serverUrlRow($this$access_u24serverUrlRow, remoteCommunicator);
        }

        public static final /* synthetic */ Row access$loginNameRow(TroubleshootingDialog $this, Panel $this$access_u24loginNameRow, JBAccountInfoService.JBAData userData) {
            return $this.loginNameRow($this$access_u24loginNameRow, userData);
        }

        public static final /* synthetic */ Row access$emailRow(TroubleshootingDialog $this, Panel $this$access_u24emailRow, JBAccountInfoService.JBAData userData) {
            return $this.emailRow($this$access_u24emailRow, userData);
        }

        public static final /* synthetic */ Row access$versionRow(TroubleshootingDialog $this, Panel $this$access_u24versionRow, FileVersionInfo version2, CloudConfigServerCommunicator remoteCommunicator) {
            return $this.versionRow($this$access_u24versionRow, version2, remoteCommunicator);
        }

        public static final /* synthetic */ void access$showHistoryDialog(TroubleshootingDialog $this, Project project, CloudConfigServerCommunicator remoteCommunicator, String loginName) {
            $this.showHistoryDialog(project, remoteCommunicator, loginName);
        }

        public static final /* synthetic */ void access$deleteFile(TroubleshootingDialog $this, Project project, CloudConfigServerCommunicator remoteCommunicator) {
            $this.deleteFile(project, remoteCommunicator);
        }

        public static final /* synthetic */ Cell access$copyableLabel(TroubleshootingDialog $this, Row $this$access_u24copyableLabel, Object text) {
            return $this.copyableLabel($this$access_u24copyableLabel, text);
        }

        public static final /* synthetic */ String access$formatDate(TroubleshootingDialog $this, Date date) {
            return $this.formatDate(date);
        }

        public static final /* synthetic */ void access$downloadVersion(TroubleshootingDialog $this, CloudConfigServerCommunicator remoteCommunicator, FileVersionInfo version2, Project project) {
            $this.downloadVersion(remoteCommunicator, version2, project);
        }

        public static final /* synthetic */ String access$getSnapshotFileName(TroubleshootingDialog $this, FileVersionInfo version2) {
            return $this.getSnapshotFileName(version2);
        }

        public static final /* synthetic */ void access$downloadFullHistory(TroubleshootingDialog $this, Project project, CloudConfigServerCommunicator remoteCommunicator, List history2, String loginName) {
            $this.downloadFullHistory(project, remoteCommunicator, history2, loginName);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

