/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.settingsSync.SettingsSyncEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@State(name="SettingsSyncSettings", storages={@Storage(value="settingsSync.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0005J\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/settingsSync/SettingsSyncSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/settingsSync/SettingsSyncSettings$SettingsSyncSettingsState;", "()V", "value", "", "syncEnabled", "getSyncEnabled", "()Z", "setSyncEnabled", "(Z)V", "fireSettingsStateChanged", "", "isCategoryEnabled", "category", "Lcom/intellij/openapi/components/SettingsCategory;", "isSubcategoryEnabled", "subcategoryId", "", "setCategoryEnabled", "isEnabled", "setSubcategoryEnabled", "Companion", "SettingsSyncSettingsState", "intellij.settingsSync"})
public final class SettingsSyncSettings
extends SimplePersistentStateComponent<SettingsSyncSettingsState> {
    @NotNull
    public static final String FILE_SPEC = "settingsSync.xml";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean getSyncEnabled() {
        return ((SettingsSyncSettingsState)this.getState()).getSyncEnabled();
    }

    public final void setSyncEnabled(boolean value) {
        ((SettingsSyncSettingsState)this.getState()).setSyncEnabled(value);
        this.fireSettingsStateChanged(value);
    }

    private final void fireSettingsStateChanged(boolean syncEnabled) {
        SettingsSyncEvents.Companion.getInstance().fireEnabledStateChanged(syncEnabled);
    }

    public final boolean isCategoryEnabled(@NotNull SettingsCategory category) {
        return !((SettingsSyncSettingsState)this.getState()).getDisabledCategories().contains(category);
    }

    public final void setCategoryEnabled(@NotNull SettingsCategory category, boolean isEnabled) {
        if (isEnabled) {
            ((SettingsSyncSettingsState)this.getState()).getDisabledCategories().remove(category);
        } else if (!((SettingsSyncSettingsState)this.getState()).getDisabledCategories().contains(category)) {
            ((SettingsSyncSettingsState)this.getState()).getDisabledCategories().add(category);
            CollectionsKt.sort(((SettingsSyncSettingsState)this.getState()).getDisabledCategories());
        }
    }

    public final boolean isSubcategoryEnabled(@NotNull SettingsCategory category, @NotNull String subcategoryId) {
        ArrayList<String> disabled = ((SettingsSyncSettingsState)this.getState()).getDisabledSubcategories().get(category);
        return disabled == null || !disabled.contains(subcategoryId);
    }

    public final void setSubcategoryEnabled(@NotNull SettingsCategory category, @NotNull String subcategoryId, boolean isEnabled) {
        ArrayList<String> disabledList = ((SettingsSyncSettingsState)this.getState()).getDisabledSubcategories().get(category);
        if (isEnabled) {
            if (disabledList != null) {
                disabledList.remove(subcategoryId);
                if (disabledList.isEmpty()) {
                    ((SettingsSyncSettingsState)this.getState()).getDisabledSubcategories().remove(category);
                }
            }
        } else if (disabledList == null) {
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(subcategoryId);
            ((SettingsSyncSettingsState)this.getState()).getDisabledSubcategories().put(category, newList);
        } else if (!disabledList.contains(subcategoryId)) {
            disabledList.add(subcategoryId);
            Collections.sort((List)disabledList);
        }
    }

    public SettingsSyncSettings() {
        super((BaseState)new SettingsSyncSettingsState());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R7\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nRO\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/settingsSync/SettingsSyncSettings$SettingsSyncSettingsState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "Lcom/intellij/openapi/components/SettingsCategory;", "disabledCategories", "getDisabledCategories", "()Ljava/util/List;", "setDisabledCategories", "(Ljava/util/List;)V", "disabledCategories$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "Ljava/util/ArrayList;", "", "disabledSubcategories", "getDisabledSubcategories", "()Ljava/util/Map;", "setDisabledSubcategories", "(Ljava/util/Map;)V", "disabledSubcategories$delegate", "", "syncEnabled", "getSyncEnabled", "()Z", "setSyncEnabled", "(Z)V", "syncEnabled$delegate", "intellij.settingsSync"})
    public static final class SettingsSyncSettingsState
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty syncEnabled$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty disabledCategories$delegate = this.list().provideDelegate((Object)this, $$delegatedProperties[1]);
        @NotNull
        private final ReadWriteProperty disabledSubcategories$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[2]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(SettingsSyncSettingsState.class, "syncEnabled", "getSyncEnabled()Z", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(SettingsSyncSettingsState.class, "disabledCategories", "getDisabledCategories()Ljava/util/List;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(SettingsSyncSettingsState.class, "disabledSubcategories", "getDisabledSubcategories()Ljava/util/Map;", 0))};
        }

        public final boolean getSyncEnabled() {
            return (Boolean)this.syncEnabled$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setSyncEnabled(boolean bl) {
            this.syncEnabled$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        @NotNull
        public final List<SettingsCategory> getDisabledCategories() {
            return (List)this.disabledCategories$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setDisabledCategories(@NotNull List<SettingsCategory> list) {
            this.disabledCategories$delegate.setValue((Object)this, $$delegatedProperties[1], list);
        }

        @NotNull
        public final Map<SettingsCategory, ArrayList<String>> getDisabledSubcategories() {
            return (Map)this.disabledSubcategories$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public final void setDisabledSubcategories(@NotNull Map<SettingsCategory, ArrayList<String>> map) {
            this.disabledSubcategories$delegate.setValue((Object)this, $$delegatedProperties[2], map);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/SettingsSyncSettings$Companion;", "", "()V", "FILE_SPEC", "", "getInstance", "Lcom/intellij/settingsSync/SettingsSyncSettings;", "kotlin.jvm.PlatformType", "intellij.settingsSync"})
    public static final class Companion {
        public final SettingsSyncSettings getInstance() {
            return (SettingsSyncSettings)((Object)ApplicationManager.getApplication().getService(SettingsSyncSettings.class));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

