/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentCategorizer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.settingsSync.SettingsSyncSettings;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\"\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a$\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001H\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"findComponentClasses", "", "Ljava/lang/Class;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "", "fileSpec", "", "getCategory", "Lcom/intellij/openapi/components/SettingsCategory;", "componentClasses", "getSchemeCategory", "getSubCategory", "isSyncEnabled", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "removeOsPrefix", "intellij.settingsSync"})
public final class SettingsSyncFilteringKt {
    public static final boolean isSyncEnabled(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        SettingsCategory category;
        if (roamingType == RoamingType.DISABLED) {
            return false;
        }
        String rawFileSpec = SettingsSyncFilteringKt.removeOsPrefix(fileSpec);
        if (Intrinsics.areEqual((Object)rawFileSpec, (Object)"settingsSync.xml") || Intrinsics.areEqual((Object)rawFileSpec, (Object)"settingsSyncPlugins.xml")) {
            return true;
        }
        List<Class<PersistentStateComponent<Object>>> componentClasses = SettingsSyncFilteringKt.findComponentClasses(rawFileSpec);
        SettingsCategory settingsCategory = SettingsSyncFilteringKt.getSchemeCategory(rawFileSpec);
        if (settingsCategory == null) {
            settingsCategory = category = SettingsSyncFilteringKt.getCategory(componentClasses);
        }
        if (category != SettingsCategory.OTHER && SettingsSyncSettings.Companion.getInstance().isCategoryEnabled(category)) {
            String subCategory = SettingsSyncFilteringKt.getSubCategory(componentClasses);
            if (subCategory != null) {
                return SettingsSyncSettings.Companion.getInstance().isSubcategoryEnabled(category, subCategory);
            }
            return true;
        }
        return false;
    }

    private static final String removeOsPrefix(String fileSpec) {
        String osPrefix = StoreUtilKt.getPerOsSettingsStorageFolderName() + "/";
        return StringsKt.startsWith$default((String)fileSpec, (String)osPrefix, (boolean)false, (int)2, null) ? StringUtil.trimStart((String)fileSpec, (String)osPrefix) : fileSpec;
    }

    private static final SettingsCategory getCategory(List<Class<PersistentStateComponent<Object>>> componentClasses) {
        if (componentClasses.isEmpty()) {
            return SettingsCategory.OTHER;
        }
        if (componentClasses.size() == 1) {
            return ComponentCategorizer.getCategory(componentClasses.get(0));
        }
        Iterable $this$forEach$iv = componentClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            SettingsCategory category = ComponentCategorizer.getCategory((Class)it);
            if (category == SettingsCategory.OTHER) continue;
            return category;
        }
        return SettingsCategory.OTHER;
    }

    private static final SettingsCategory getSchemeCategory(String fileSpec) {
        int separatorIndex = StringsKt.indexOf$default((CharSequence)fileSpec, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separatorIndex >= 0) {
            String string = fileSpec;
            int n = 0;
            String string2 = string.substring(n, separatorIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            switch (string2) {
                case "codestyles": {
                    return SettingsCategory.CODE;
                }
                case "colors": {
                    return SettingsCategory.UI;
                }
                case "keymaps": {
                    return SettingsCategory.KEYMAP;
                }
                case "inspection": {
                    return SettingsCategory.CODE;
                }
            }
        }
        return null;
    }

    private static final String getSubCategory(List<Class<PersistentStateComponent<Object>>> componentClasses) {
        for (Class<PersistentStateComponent<Object>> componentClass : componentClasses) {
            if (!AppEditorFontOptions.class.isAssignableFrom(componentClass)) continue;
            return "editorFont";
        }
        return null;
    }

    private static final List<Class<PersistentStateComponent<Object>>> findComponentClasses(String fileSpec) {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        }
        ComponentManagerImpl componentManager = (ComponentManagerImpl)application;
        ArrayList componentClasses = new ArrayList();
        componentManager.processAllImplementationClasses(new Function2<Class<?>, PluginDescriptor, Unit>(fileSpec, componentClasses){
            final /* synthetic */ String $fileSpec;
            final /* synthetic */ ArrayList $componentClasses;

            public final void invoke(@NotNull Class<?> aClass, @Nullable PluginDescriptor $noName_1) {
                if (PersistentStateComponent.class.isAssignableFrom(aClass)) {
                    Storage[] state;
                    Storage[] storageArray = state = aClass.getAnnotation(State.class);
                    if (state != null && (storageArray = storageArray.storages()) != null) {
                        Storage[] $this$forEach$iv = storageArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            Storage element$iv;
                            Storage storage = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            if (storage.deprecated() || !Intrinsics.areEqual((Object)storage.value(), (Object)this.$fileSpec)) continue;
                            Class<?> clazz = aClass;
                            if (clazz == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<com.intellij.openapi.components.PersistentStateComponent<kotlin.Any>>");
                            }
                            this.$componentClasses.add(clazz);
                        }
                    }
                }
            }
            {
                this.$fileSpec = string;
                this.$componentClasses = arrayList;
                super(2);
            }
        });
        return componentClasses;
    }
}

