/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.SettingsChangeListener;
import com.intellij.settingsSync.SettingsLog;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncIdeMediator;
import com.intellij.settingsSync.SettingsSyncPushResult;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.SettingsSyncUpdateChecker;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0015\b\u0000\u0018\u0000 *2\u00020\u0001:\u0002*+B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u0018H\u0003J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\r\u0010!\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\"J\r\u0010#\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b$J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006,"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "settingsLog", "Lcom/intellij/settingsSync/SettingsLog;", "ideMediator", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "updateChecker", "Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/settingsSync/SettingsLog;Lcom/intellij/settingsSync/SettingsSyncIdeMediator;Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;)V", "pendingEvents", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/settingsSync/SyncSettingsEvent;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "updateObject", "com/intellij/settingsSync/SettingsSyncBridge$updateObject$1", "Lcom/intellij/settingsSync/SettingsSyncBridge$updateObject$1;", "initialize", "", "initMode", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "processPendingEvents", "pushToCloud", "Lcom/intellij/settingsSync/SettingsSyncPushResult;", "settingsSnapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "pushToIde", "resumeEventProcessing", "resumeEventProcessing$intellij_settingsSync", "suspendEventProcessing", "suspendEventProcessing$intellij_settingsSync", "waitForAllExecuted", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "Companion", "InitMode", "intellij.settingsSync"})
public final class SettingsSyncBridge {
    private final ConcurrentList<SyncSettingsEvent> pendingEvents;
    private final MergingUpdateQueue queue;
    private final updateObject.1 updateObject;
    private final SettingsLog settingsLog;
    private final SettingsSyncIdeMediator ideMediator;
    private final SettingsSyncRemoteCommunicator remoteCommunicator;
    private final SettingsSyncUpdateChecker updateChecker;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @RequiresBackgroundThread
    public final void initialize(@NotNull InitMode initMode) {
        SyncSettingsEvent syncSettingsEvent;
        this.settingsLog.initialize();
        this.ideMediator.activateStreamProvider();
        InitMode initMode2 = initMode;
        if (initMode2 instanceof InitMode.TakeFromServer) {
            syncSettingsEvent = ((InitMode.TakeFromServer)initMode).getCloudEvent();
        } else if (Intrinsics.areEqual((Object)initMode2, (Object)InitMode.PushToServer.INSTANCE)) {
            syncSettingsEvent = SyncSettingsEvent.MustPushRequest.INSTANCE;
        } else if (Intrinsics.areEqual((Object)initMode2, (Object)InitMode.JustInit.INSTANCE)) {
            syncSettingsEvent = SyncSettingsEvent.LogCurrentSettings.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SyncSettingsEvent initialEvent = syncSettingsEvent;
        this.pendingEvents.add((Object)initialEvent);
        this.processPendingEvents();
        SettingsSyncEvents.Companion.getInstance().addSettingsChangedListener(new SettingsChangeListener(this){
            final /* synthetic */ SettingsSyncBridge this$0;

            public final void settingChanged(@NotNull SyncSettingsEvent event) {
                SettingsSyncBridge.access$getPendingEvents$p(this.this$0).add((Object)event);
                SettingsSyncBridge.access$getQueue$p(this.this$0).queue((Update)SettingsSyncBridge.access$getUpdateObject$p(this.this$0));
            }
            {
                this.this$0 = settingsSyncBridge;
            }
        });
    }

    @RequiresBackgroundThread
    private final void processPendingEvents() {
        SyncSettingsEvent it;
        boolean $i$f$none;
        Iterable $this$none$iv;
        SettingsSyncPushResult settingsSyncPushResult;
        SettingsSyncPushResult pushResult;
        Collection collection;
        SettingsLog.Position previousIdePosition = this.settingsLog.getIdePosition();
        SettingsLog.Position previousCloudPosition = this.settingsLog.getCloudPosition();
        boolean pushToCloudRequested = false;
        boolean mustPushToCloud = false;
        while (!(collection = (Collection)this.pendingEvents).isEmpty()) {
            SyncSettingsEvent event = (SyncSettingsEvent)this.pendingEvents.remove(0);
            if (event instanceof SyncSettingsEvent.IdeChange) {
                this.settingsLog.applyIdeState(((SyncSettingsEvent.IdeChange)event).getSnapshot());
                continue;
            }
            if (event instanceof SyncSettingsEvent.CloudChange) {
                this.settingsLog.applyCloudState(((SyncSettingsEvent.CloudChange)event).getSnapshot());
                continue;
            }
            if (event instanceof SyncSettingsEvent.LogCurrentSettings) {
                this.settingsLog.logExistingSettings();
                continue;
            }
            if (event instanceof SyncSettingsEvent.PushIfNeededRequest) {
                pushToCloudRequested = true;
                continue;
            }
            if (!(event instanceof SyncSettingsEvent.MustPushRequest)) continue;
            mustPushToCloud = true;
        }
        SettingsLog.Position newIdePosition = this.settingsLog.getIdePosition();
        SettingsLog.Position newCloudPosition = this.settingsLog.getCloudPosition();
        SettingsLog.Position masterPosition = null;
        masterPosition = Intrinsics.areEqual((Object)newIdePosition, (Object)previousIdePosition) ^ true || Intrinsics.areEqual((Object)newCloudPosition, (Object)previousCloudPosition) ^ true ? this.settingsLog.advanceMaster() : this.settingsLog.getMasterPosition();
        if (Intrinsics.areEqual((Object)newIdePosition, (Object)masterPosition) ^ true) {
            pushResult = this.pushToIde(this.settingsLog.collectCurrentSnapshot());
            LOG.info("Result of pushing settings to the IDE: " + pushResult);
            settingsSyncPushResult = pushResult;
            if (Intrinsics.areEqual((Object)settingsSyncPushResult, (Object)SettingsSyncPushResult.Success.INSTANCE)) {
                this.settingsLog.setIdePosition(masterPosition);
                SettingsSyncStatusTracker.Companion.getInstance().updateOnSuccess();
            } else if (settingsSyncPushResult instanceof SettingsSyncPushResult.Error) {
                SettingsSyncStatusTracker.Companion.getInstance().updateOnError(SettingsSyncBundle.INSTANCE.message("notification.title.apply.error", new Object[0]) + ": " + ((SettingsSyncPushResult.Error)pushResult).getMessage());
            } else if (Intrinsics.areEqual((Object)settingsSyncPushResult, (Object)SettingsSyncPushResult.Rejected.INSTANCE)) {
                $this$none$iv = (Iterable)this.pendingEvents;
                $i$f$none = false;
                if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) {
                    for (Object element$iv : $this$none$iv) {
                        it = (SyncSettingsEvent)element$iv;
                        boolean bl = false;
                        if (!(it instanceof SyncSettingsEvent.IdeChange)) continue;
                        break;
                    }
                }
            }
        }
        if (Intrinsics.areEqual((Object)newCloudPosition, (Object)masterPosition) ^ true || mustPushToCloud) {
            pushResult = this.pushToCloud(this.settingsLog.collectCurrentSnapshot());
            LOG.info("Result of pushing settings to the cloud: " + pushResult);
            settingsSyncPushResult = pushResult;
            if (Intrinsics.areEqual((Object)settingsSyncPushResult, (Object)SettingsSyncPushResult.Success.INSTANCE)) {
                this.settingsLog.setCloudPosition(masterPosition);
                SettingsSyncStatusTracker.Companion.getInstance().updateOnSuccess();
            } else if (settingsSyncPushResult instanceof SettingsSyncPushResult.Error) {
                SettingsSyncStatusTracker.Companion.getInstance().updateOnError(SettingsSyncBundle.INSTANCE.message("notification.title.push.error", new Object[0]) + ": " + ((SettingsSyncPushResult.Error)pushResult).getMessage());
            } else if (Intrinsics.areEqual((Object)settingsSyncPushResult, (Object)SettingsSyncPushResult.Rejected.INSTANCE)) {
                boolean bl;
                block25: {
                    $this$none$iv = (Iterable)this.pendingEvents;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (SyncSettingsEvent)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof SyncSettingsEvent.CloudChange)) continue;
                            bl = false;
                            break block25;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.updateChecker.scheduleUpdateFromServer();
                }
            }
        } else if (pushToCloudRequested) {
            LOG.info("Requested to push if needed, but there was nothing to push");
        }
    }

    private final SettingsSyncPushResult pushToCloud(SettingsSnapshot settingsSnapshot) {
        return this.remoteCommunicator.push(settingsSnapshot);
    }

    private final SettingsSyncPushResult pushToIde(SettingsSnapshot settingsSnapshot) {
        this.ideMediator.applyToIde(settingsSnapshot);
        return SettingsSyncPushResult.Success.INSTANCE;
    }

    @TestOnly
    public final void waitForAllExecuted(long timeout, @NotNull TimeUnit timeUnit) {
        this.queue.waitForAllExecuted(timeout, timeUnit);
    }

    @VisibleForTesting
    public final void suspendEventProcessing$intellij_settingsSync() {
        this.queue.suspend();
    }

    @VisibleForTesting
    public final void resumeEventProcessing$intellij_settingsSync() {
        this.queue.resume();
    }

    /*
     * WARNING - void declaration
     */
    public SettingsSyncBridge(@NotNull Disposable parentDisposable, @NotNull SettingsLog settingsLog, @NotNull SettingsSyncIdeMediator ideMediator2, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator, @NotNull SettingsSyncUpdateChecker updateChecker) {
        void $this$apply;
        MergingUpdateQueue mergingUpdateQueue;
        this.settingsLog = settingsLog;
        this.ideMediator = ideMediator2;
        this.remoteCommunicator = remoteCommunicator;
        this.updateChecker = updateChecker;
        this.pendingEvents = ContainerUtil.createConcurrentList();
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("SettingsSyncBridge", 1000, true, null, parentDisposable, null, Alarm.ThreadToUse.POOLED_THREAD);
        SettingsSyncBridge settingsSyncBridge = this;
        boolean bl = false;
        $this$apply.setRestartTimerOnAdd(true);
        Unit unit = Unit.INSTANCE;
        settingsSyncBridge.queue = mergingUpdateQueue;
        this.updateObject = new Update(this, 1){
            final /* synthetic */ SettingsSyncBridge this$0;

            public void run() {
                SettingsSyncBridge.access$processPendingEvents(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncBridge.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ ConcurrentList access$getPendingEvents$p(SettingsSyncBridge $this) {
        return $this.pendingEvents;
    }

    public static final /* synthetic */ MergingUpdateQueue access$getQueue$p(SettingsSyncBridge $this) {
        return $this.queue;
    }

    public static final /* synthetic */ updateObject.1 access$getUpdateObject$p(SettingsSyncBridge $this) {
        return $this.updateObject;
    }

    public static final /* synthetic */ void access$processPendingEvents(SettingsSyncBridge $this) {
        $this.processPendingEvents();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "", "()V", "JustInit", "PushToServer", "TakeFromServer", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$JustInit;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$TakeFromServer;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$PushToServer;", "intellij.settingsSync"})
    public static abstract class InitMode {
        private InitMode() {
        }

        public /* synthetic */ InitMode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$JustInit;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "()V", "intellij.settingsSync"})
        public static final class JustInit
        extends InitMode {
            @NotNull
            public static final JustInit INSTANCE;

            private JustInit() {
                super(null);
            }

            static {
                JustInit justInit;
                INSTANCE = justInit = new JustInit();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$TakeFromServer;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "cloudEvent", "Lcom/intellij/settingsSync/SyncSettingsEvent$CloudChange;", "(Lcom/intellij/settingsSync/SyncSettingsEvent$CloudChange;)V", "getCloudEvent", "()Lcom/intellij/settingsSync/SyncSettingsEvent$CloudChange;", "intellij.settingsSync"})
        public static final class TakeFromServer
        extends InitMode {
            @NotNull
            private final SyncSettingsEvent.CloudChange cloudEvent;

            @NotNull
            public final SyncSettingsEvent.CloudChange getCloudEvent() {
                return this.cloudEvent;
            }

            public TakeFromServer(@NotNull SyncSettingsEvent.CloudChange cloudEvent) {
                super(null);
                this.cloudEvent = cloudEvent;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode$PushToServer;", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "()V", "intellij.settingsSync"})
        public static final class PushToServer
        extends InitMode {
            @NotNull
            public static final PushToServer INSTANCE;

            private PushToServer() {
                super(null);
            }

            static {
                PushToServer pushToServer;
                INSTANCE = pushToServer = new PushToServer();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/SettingsSyncBridge$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

