/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.LocalDirSettingsSyncRemoteCommunicatorKt;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSyncPushResult;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00030\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/settingsSync/LocalDirSettingsSyncRemoteCommunicator;", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "settingsSyncStorage", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "serverDir", "getServerDir", "()Ljava/nio/file/Path;", "zipFile", "kotlin.jvm.PlatformType", "getZipFile", "checkServerState", "Lcom/intellij/settingsSync/ServerState;", "delete", "", "push", "Lcom/intellij/settingsSync/SettingsSyncPushResult;", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "receiveUpdates", "Lcom/intellij/settingsSync/UpdateResult;", "Companion", "intellij.settingsSync"})
public final class LocalDirSettingsSyncRemoteCommunicator
implements SettingsSyncRemoteCommunicator {
    private final Path settingsSyncStorage;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final Path getServerDir() {
        String localServerPath = System.getProperty("idea.settings.sync.local.server.path");
        if (localServerPath == null) {
            LOG.error("Local server path is undefined, using ");
            return this.settingsSyncStorage.resolveSibling("settingsSyncServer");
        }
        return PathKt.createDirectories((Path)Paths.get(localServerPath, new String[0]));
    }

    private final Path getZipFile() {
        return this.getServerDir().resolve("settings.sync.snapshot.zip");
    }

    @Override
    @NotNull
    public ServerState checkServerState() {
        return PathKt.exists((Path)this.getZipFile()) ? (ServerState)ServerState.UpToDate.INSTANCE : (ServerState)ServerState.UpdateNeeded.INSTANCE;
    }

    @Override
    @NotNull
    public UpdateResult receiveUpdates() {
        return new UpdateResult.Success(LocalDirSettingsSyncRemoteCommunicatorKt.extractZipFile(this.getZipFile()));
    }

    @Override
    @NotNull
    public SettingsSyncPushResult push(@NotNull SettingsSnapshot snapshot) {
        try {
            File file = LocalDirSettingsSyncRemoteCommunicatorKt.prepareTempZipFile(snapshot).toFile();
            Files.move(file.toPath(), this.getZipFile(), StandardCopyOption.REPLACE_EXISTING);
            return SettingsSyncPushResult.Success.INSTANCE;
        }
        catch (Throwable e) {
            LOG.error(e);
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            return new SettingsSyncPushResult.Error(string);
        }
    }

    @Override
    public void delete() {
    }

    public LocalDirSettingsSyncRemoteCommunicator(@NotNull Path settingsSyncStorage) {
        this.settingsSyncStorage = settingsSyncStorage;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LocalDirSettingsSyncRemoteCommunicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/LocalDirSettingsSyncRemoteCommunicator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

