/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.FileStateKt;
import com.intellij.settingsSync.GitSettingsLog;
import com.intellij.settingsSync.SettingsLog;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0002HIB1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010(\u001a\u00020#H\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u0018H\u0002J\u0018\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004H\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\u0018\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u001eH\u0016J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\fH\u0002J\b\u00108\u001a\u00020 H\u0016J\b\u00109\u001a\u00020 H\u0016J\b\u0010:\u001a\u00020 H\u0016J\u0010\u0010;\u001a\u0002052\u0006\u0010<\u001a\u00020\fH\u0002J\u0012\u0010=\u001a\u00020\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010>\u001a\u00020\u001eH\u0016J\b\u0010?\u001a\u00020\u001eH\u0016J\b\u0010@\u001a\u00020\u001eH\u0002J\u0010\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020 H\u0016J\u0010\u0010C\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020 H\u0016J\u0018\u0010D\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010E\u001a\u00020 H\u0002J\f\u0010F\u001a\u00020G*\u00020\u0016H\u0002R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006J"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog;", "Lcom/intellij/settingsSync/SettingsLog;", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "rootConfigPath", "parentDisposable", "collectFilesToExportFromSettings", "Lkotlin/Function0;", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "cloud", "Lorg/eclipse/jgit/lib/Ref;", "getCloud", "()Lorg/eclipse/jgit/lib/Ref;", "git", "Lorg/eclipse/jgit/api/Git;", "ide", "getIde", "master", "getMaster", "repository", "Lorg/eclipse/jgit/lib/Repository;", "short", "", "Lorg/eclipse/jgit/lib/ObjectId;", "getShort", "(Lorg/eclipse/jgit/lib/ObjectId;)Ljava/lang/String;", "(Lorg/eclipse/jgit/lib/Ref;)Ljava/lang/String;", "abortMerge", "", "advanceMaster", "Lcom/intellij/settingsSync/SettingsLog$Position;", "applyCloudState", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "applyIdeState", "applySnapshotAndCommit", "refName", "applyState", "collectCurrentSnapshot", "commit", "message", "copyDirectory", "dirToCopy", "targetDir", "copyExistingSettings", "createBranchIfNeeded", "name", "newRepository", "", "dispose", "fastForwardMaster", "Lcom/intellij/settingsSync/GitSettingsLog$BranchPosition;", "branchOnSamePosition", "targetBranch", "getCloudPosition", "getIdePosition", "getMasterPosition", "getPosition", "ref", "initRepository", "initialize", "logExistingSettings", "mergeUsingSimplifiedLastModifiedStrategy", "setCloudPosition", "position", "setIdePosition", "updateBranchPosition", "targetPosition", "headCommit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "BranchPosition", "Companion", "intellij.settingsSync"})
public final class GitSettingsLog
implements SettingsLog,
Disposable {
    private Repository repository;
    private Git git;
    private final Path settingsSyncStorage;
    private final Path rootConfigPath;
    private final Function0<Collection<Path>> collectFilesToExportFromSettings;
    @Deprecated
    @NotNull
    private static final Logger LOG;
    @Deprecated
    @NotNull
    public static final String MASTER_REF_NAME = "master";
    @Deprecated
    @NotNull
    public static final String IDE_REF_NAME = "ide";
    @Deprecated
    @NotNull
    public static final String CLOUD_REF_NAME = "cloud";
    @NotNull
    private static final Companion Companion;

    private final Ref getMaster() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref = repository.findRef(MASTER_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    private final Ref getIde() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref = repository.findRef(IDE_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    private final Ref getCloud() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref = repository.findRef(CLOUD_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    @Override
    public void initialize() {
        boolean newRepository;
        Path dotGit = this.settingsSyncStorage.resolve(".git");
        Repository repository = this.repository = FileRepositoryBuilder.create(dotGit.toFile());
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        this.git = new Git(repository);
        boolean bl = newRepository = !PathKt.exists((Path)dotGit);
        if (newRepository) {
            LOG.info("Initializing new Git repository for Settings Sync at " + this.settingsSyncStorage);
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            }
            repository2.create();
            Repository repository3 = this.repository;
            if (repository3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            }
            this.initRepository(repository3);
        }
        this.createBranchIfNeeded(MASTER_REF_NAME, newRepository);
        this.createBranchIfNeeded(CLOUD_REF_NAME, newRepository);
        this.createBranchIfNeeded(IDE_REF_NAME, newRepository);
    }

    @Override
    public void logExistingSettings() {
        this.copyExistingSettings();
    }

    private final void createBranchIfNeeded(String name, boolean newRepository) {
        Ref ref;
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        if ((ref = repository.findRef(name)) == null) {
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            }
            RevCommit head = this.headCommit(repository2);
            if (!newRepository) {
                LOG.warn("Ref with name " + name + " not found in existing repository. Recreating at position of HEAD@" + this.getShort(head.toObjectId()));
            }
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            }
            git.branchCreate().setName(name).setStartPoint(head).call();
        }
    }

    private final void copyExistingSettings() {
        Iterable path2;
        LOG.info("Copying existing settings from " + this.rootConfigPath + " to " + this.settingsSyncStorage);
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git.checkout().setName(IDE_REF_NAME).call();
        List copiedFileSpecs = new ArrayList();
        Collection filesToExport = (Collection)this.collectFilesToExportFromSettings.invoke();
        for (Iterable path2 : filesToExport) {
            String fileSpec = ((Object)PathsKt.relativeTo(path2, (Path)this.rootConfigPath)).toString();
            if (PathKt.isFile(path2)) {
                Path target = this.settingsSyncStorage.resolve(fileSpec);
                NioFiles.createDirectories((Path)target.getParent());
                Files.copy(path2, target, new CopyOption[]{LinkOption.NOFOLLOW_LINKS});
            } else {
                this.copyDirectory((Path)path2, this.settingsSyncStorage);
            }
            copiedFileSpecs.add(fileSpec);
        }
        path2 = copiedFileSpecs;
        if (!path2.isEmpty()) {
            Git git2 = this.git;
            if (git2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            }
            AddCommand addCommand = git2.add();
            for (String fileSpec : copiedFileSpecs) {
                addCommand.addFilepattern(fileSpec);
            }
            addCommand.call();
            this.commit("Copy existing configs");
        }
    }

    private final void copyDirectory(Path dirToCopy, Path targetDir) {
        Files.walkFileTree(dirToCopy, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(targetDir, dirToCopy){
            final /* synthetic */ Path $targetDir;
            final /* synthetic */ Path $dirToCopy;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Path target = this.$targetDir.resolve(this.$dirToCopy.getParent().relativize(file));
                NioFiles.createDirectories((Path)target.getParent());
                Files.copy(file, target, LinkOption.NOFOLLOW_LINKS);
                return FileVisitResult.CONTINUE;
            }
            {
                this.$targetDir = $captured_local_variable$0;
                this.$dirToCopy = $captured_local_variable$1;
            }
        });
    }

    private final void initRepository(Repository repository) {
        Path gitignore = PathKt.createFile((Path)this.settingsSyncStorage.resolve(".gitignore"));
        PathKt.write$default((Path)gitignore, (CharSequence)"event-log-metadata\njdbc-drivers\nssl\nport\nport.lock\nupdatedBrokenPlugins.db\n", null, (boolean)false, (int)6, null);
        Git git = new Git(repository);
        git.add().addFilepattern(".gitignore").call();
        git.commit().setMessage("Initial").call();
    }

    @Override
    public void applyIdeState(@NotNull SettingsSnapshot snapshot) {
        this.applyState(IDE_REF_NAME, snapshot);
    }

    @Override
    public void applyCloudState(@NotNull SettingsSnapshot snapshot) {
        this.applyState(CLOUD_REF_NAME, snapshot);
    }

    private final void applyState(String refName, SettingsSnapshot snapshot) {
        if (snapshot.isEmpty()) {
            LOG.error("Empty snapshot");
            return;
        }
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git.checkout().setName(refName).call();
        this.applySnapshotAndCommit(refName, snapshot);
    }

    private final void applySnapshotAndCommit(String refName, SettingsSnapshot snapshot) {
        LOG.info("Applying settings changes to branch " + refName + ": " + CollectionsKt.joinToString$default((Iterable)snapshot.getFileStates(), null, null, null, (int)5, null, (Function1)applySnapshotAndCommit.1.INSTANCE, (int)23, null));
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        AddCommand addCommand = git.add();
        String message = "Apply changes received from " + refName;
        for (FileState fileState : snapshot.getFileStates()) {
            Path file = this.settingsSyncStorage.resolve(fileState.getFile());
            FileState fileState2 = fileState;
            if (fileState2 instanceof FileState.Modified) {
                PathKt.write((Path)file, (byte[])((FileState.Modified)fileState).getContent(), (int)0, (int)((FileState.Modified)fileState).getSize());
            } else if (fileState2 instanceof FileState.Deleted) {
                PathKt.write$default((Path)file, (CharSequence)"DELETED", null, (boolean)false, (int)6, null);
            }
            addCommand.addFilepattern(fileState.getFile());
        }
        addCommand.call();
        this.commit(message);
    }

    private final void commit(String message) {
        try {
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            }
            git.commit().setMessage(message).setAllowEmpty(false).call();
        }
        catch (EmptyCommitException e) {
            LOG.info("No actual changes in the settings");
        }
    }

    public void dispose() {
        if (this.repository != null) {
            Repository repository = this.repository;
            if (repository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            }
            repository.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SettingsSnapshot collectCurrentSnapshot() {
        void var3_2;
        void $this$mapTo$iv;
        Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)this.settingsSyncStorage.toFile()).onEnter((Function1)collectCurrentSnapshot.files.1.INSTANCE)), (Function1)collectCurrentSnapshot.files.2.INSTANCE);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            File file = (File)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            FileState fileState = FileStateKt.getFileStateFromFileWithDeletedMarker(it.toPath(), this.settingsSyncStorage);
            collection.add(fileState);
        }
        HashSet files2 = (HashSet)var3_2;
        return new SettingsSnapshot(files2);
    }

    @Override
    @NotNull
    public SettingsLog.Position getIdePosition() {
        return this.getPosition(this.getIde());
    }

    @Override
    @NotNull
    public SettingsLog.Position getCloudPosition() {
        return this.getPosition(this.getCloud());
    }

    @Override
    @NotNull
    public SettingsLog.Position getMasterPosition() {
        return this.getPosition(this.getMaster());
    }

    private final BranchPosition getPosition(Ref ref) {
        return new BranchPosition(ref.getObjectId().name());
    }

    @Override
    public void setIdePosition(@NotNull SettingsLog.Position position) {
        this.updateBranchPosition(IDE_REF_NAME, position);
    }

    @Override
    public void setCloudPosition(@NotNull SettingsLog.Position position) {
        this.updateBranchPosition(CLOUD_REF_NAME, position);
    }

    private final Ref updateBranchPosition(String refName, SettingsLog.Position targetPosition) {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref = repository.findRef(refName);
        Intrinsics.checkNotNull((Object)ref);
        Ref ref2 = ref;
        ObjectId previousObjectId = ref2.getObjectId();
        ObjectId targetObjectId = ObjectId.fromString(targetPosition.getId());
        Repository repository2 = this.repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        RefUpdate refUpdate = repository2.updateRef(ref2.getName());
        refUpdate.setNewObjectId(targetObjectId);
        RefUpdate.Result result2 = refUpdate.update();
        LOG.info("Updated position of " + this.getShort(ref2) + " from " + this.getShort(previousObjectId) + " to " + targetPosition + ": " + result2);
        Repository repository3 = this.repository;
        if (repository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref3 = repository3.findRef(ref2.getName());
        Intrinsics.checkNotNull((Object)ref3);
        return ref3;
    }

    private final BranchPosition fastForwardMaster(Ref branchOnSamePosition, Ref targetBranch) {
        MergeResult mergeResult;
        LOG.info("Advancing master. Its position is equal to " + this.getShort(branchOnSamePosition) + ": " + this.getShort(this.getMaster().getObjectId()) + ". Fast-forwarding to " + this.getShort(targetBranch) + " " + this.getShort(targetBranch.getObjectId()));
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        if ((mergeResult = git.merge().include(targetBranch).call()).getMergeStatus() != MergeResult.MergeStatus.FAST_FORWARD) {
            LOG.warn("Non-fast-forward result: " + mergeResult);
        }
        return this.getPosition(this.getMaster());
    }

    @Override
    @NotNull
    public SettingsLog.Position advanceMaster() {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git.checkout().setName(MASTER_REF_NAME).call();
        if (Intrinsics.areEqual((Object)this.getMaster().getObjectId(), (Object)this.getIde().getObjectId())) {
            return this.fastForwardMaster(this.getIde(), this.getCloud());
        }
        if (Intrinsics.areEqual((Object)this.getMaster().getObjectId(), (Object)this.getCloud().getObjectId())) {
            return this.fastForwardMaster(this.getCloud(), this.getIde());
        }
        LOG.info("Advancing master@" + this.getShort(this.getMaster().getObjectId()) + ". Need merge of ide@" + this.getShort(this.getIde().getObjectId()) + " and cloud@" + this.getShort(this.getCloud().getObjectId()));
        Git git2 = this.git;
        if (git2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git2.reset().setRef(IDE_REF_NAME).setMode(ResetCommand.ResetType.HARD).call();
        Git git3 = this.git;
        if (git3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        MergeResult mergeResult = git3.merge().include(this.getCloud()).call();
        LOG.info("Merge of master&ide@" + this.getShort(this.getMaster().getObjectId()) + " with cloud@" + this.getShort(this.getCloud().getObjectId()) + ": " + mergeResult);
        if (mergeResult.getMergeStatus() == MergeResult.MergeStatus.CONFLICTING) {
            LOG.info("Merge of master&ide with cloud failed with conflicts. Aborting and merging with simplified last-modified strategy...");
            this.abortMerge();
            this.mergeUsingSimplifiedLastModifiedStrategy();
        }
        return this.getPosition(this.getMaster());
    }

    private final void mergeUsingSimplifiedLastModifiedStrategy() {
        RevCommit cloudTip;
        int cloudLastDate;
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        RevCommit ideTip = (RevCommit)CollectionsKt.first((Iterable)git.log().add(this.getIde().getObjectId()).setMaxCount(1).call());
        int ideLastDate = ideTip.getCommitTime();
        Git git2 = this.git;
        if (git2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        MergeStrategy mergeStrategy = ideLastDate >= (cloudLastDate = (cloudTip = (RevCommit)CollectionsKt.first((Iterable)git2.log().add(this.getCloud().getObjectId()).setMaxCount(1).call())).getCommitTime()) ? MergeStrategy.OURS : MergeStrategy.THEIRS;
        Git git3 = this.git;
        if (git3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        MergeResult mergeResult = git3.merge().include(this.getCloud()).setStrategy(mergeStrategy).call();
        LOG.info("Merging with the last-modified strategy completed with result: " + mergeResult);
    }

    private final void abortMerge() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        repository.writeMergeCommitMsg(null);
        Repository repository2 = this.repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        repository2.writeMergeHeads(null);
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
    }

    private final RevCommit headCommit(Repository $this$headCommit) {
        Ref ref = $this$headCommit.findRef("HEAD");
        return $this$headCommit.parseCommit(ref.getObjectId());
    }

    private final String getShort(Ref $this$short) {
        return StringsKt.removePrefix((String)$this$short.getName(), (CharSequence)"refs/heads/");
    }

    private final String getShort(ObjectId $this$short) {
        String string = $this$short.getName();
        int n = 0;
        int n2 = 8;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public GitSettingsLog(@NotNull Path settingsSyncStorage, @NotNull Path rootConfigPath, @NotNull Disposable parentDisposable, @NotNull Function0<? extends Collection<? extends Path>> collectFilesToExportFromSettings2) {
        this.settingsSyncStorage = settingsSyncStorage;
        this.rootConfigPath = rootConfigPath;
        this.collectFilesToExportFromSettings = collectFilesToExportFromSettings2;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitSettingsLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Repository access$getRepository$p(GitSettingsLog $this) {
        Repository repository = $this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        return repository;
    }

    public static final /* synthetic */ void access$setRepository$p(GitSettingsLog $this, Repository repository) {
        $this.repository = repository;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog$BranchPosition;", "Lcom/intellij/settingsSync/SettingsLog$Position;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.settingsSync"})
    private static final class BranchPosition
    implements SettingsLog.Position {
        @NotNull
        private final String id;

        @NotNull
        public String toString() {
            String string = this.getId();
            int n = 0;
            int n2 = 8;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string2;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        public BranchPosition(@NotNull String id) {
            this.id = id;
        }

        @NotNull
        public final String component1() {
            return this.getId();
        }

        @NotNull
        public final BranchPosition copy(@NotNull String id) {
            return new BranchPosition(id);
        }

        public static /* synthetic */ BranchPosition copy$default(BranchPosition branchPosition, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = branchPosition.getId();
            }
            return branchPosition.copy(string);
        }

        public int hashCode() {
            String string = this.getId();
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BranchPosition)) break block3;
                    BranchPosition branchPosition = (BranchPosition)object;
                    if (!Intrinsics.areEqual((Object)this.getId(), (Object)branchPosition.getId())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog$Companion;", "", "()V", "CLOUD_REF_NAME", "", "IDE_REF_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MASTER_REF_NAME", "intellij.settingsSync"})
    private static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

