/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.LocalDirSettingsSyncRemoteCommunicatorKt;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSyncAuthException;
import com.intellij.settingsSync.SettingsSyncPushResult;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.util.io.PathKt;
import com.jetbrains.cloudconfig.CloudConfigFileClientV2;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.FileVersionInfo;
import com.jetbrains.cloudconfig.HeaderStorage;
import com.jetbrains.cloudconfig.auth.AuthProvider;
import com.jetbrains.cloudconfig.auth.JbaTokenAuthProvider;
import com.jetbrains.cloudconfig.exception.InvalidVersionIdException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u001f\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "()V", "_client", "Lkotlin/Lazy;", "Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "_url", "", "client", "getClient", "()Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "clientVersionContext", "Lcom/intellij/settingsSync/CloudConfigServerCommunicator$VersionContext;", "currentVersionOfFiles", "", "url", "getUrl$intellij_settingsSync", "()Ljava/lang/String;", "checkServerState", "Lcom/intellij/settingsSync/ServerState;", "createConfiguration", "Lcom/jetbrains/cloudconfig/Configuration;", "delete", "", "downloadSnapshot", "Ljava/io/InputStream;", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "fetchHistory", "", "getCurrentVersion", "getLatestVersion", "handleRemoteError", "e", "", "push", "Lcom/intellij/settingsSync/SettingsSyncPushResult;", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "receiveSnapshotFile", "receiveUpdates", "Lcom/intellij/settingsSync/UpdateResult;", "sendSnapshotFile", "inputStream", "Companion", "VersionContext", "intellij.settingsSync"})
public final class CloudConfigServerCommunicator
implements SettingsSyncRemoteCommunicator {
    private final Lazy<CloudConfigFileClientV2> _client = LazyKt.lazy((Function0)((Function0)new Function0<CloudConfigFileClientV2>(this){
        final /* synthetic */ CloudConfigServerCommunicator this$0;

        @NotNull
        public final CloudConfigFileClientV2 invoke() {
            Configuration conf = CloudConfigServerCommunicator.access$createConfiguration(this.this$0);
            return new CloudConfigFileClientV2(this.this$0.getUrl$intellij_settingsSync(), conf, CloudConfigServerCommunicator.access$getDUMMY_ETAG_STORAGE$cp(), (HeaderStorage)CloudConfigServerCommunicator.access$getClientVersionContext$p(this.this$0));
        }
        {
            this.this$0 = cloudConfigServerCommunicator;
            super(0);
        }
    }));
    private final Lazy<String> _url = LazyKt.lazy((Function0)_url.1.INSTANCE);
    private final Map<String, String> currentVersionOfFiles = new LinkedHashMap();
    private final VersionContext clientVersionContext = new VersionContext();
    private static final Logger LOG;
    private static final ETagStorage DUMMY_ETAG_STORAGE;
    @NotNull
    public static final Companion Companion;

    private final CloudConfigFileClientV2 getClient() {
        return (CloudConfigFileClientV2)this._client.getValue();
    }

    @NotNull
    public final String getUrl$intellij_settingsSync() {
        return (String)this._url.getValue();
    }

    private final Configuration createConfiguration() {
        String userId;
        JBAccountInfoService.JBAData jBAData = SettingsSyncAuthService.Companion.getInstance().getUserData();
        String string = userId = jBAData != null ? jBAData.id : null;
        if (userId == null) {
            throw (Throwable)new SettingsSyncAuthException("Authentication required");
        }
        return new Configuration().connectTimeout(10000).readTimeout(10000).auth((AuthProvider)new JbaTokenAuthProvider(userId));
    }

    private final InputStream receiveSnapshotFile() {
        return (InputStream)this.clientVersionContext.doWithVersion(null, (Function0)new Function0<InputStream>(this){
            final /* synthetic */ CloudConfigServerCommunicator this$0;

            public final InputStream invoke() {
                return CloudConfigServerCommunicator.access$getClient$p(this.this$0).read("settings.sync.snapshot.zip");
            }
            {
                this.this$0 = cloudConfigServerCommunicator;
                super(0);
            }
        });
    }

    private final void sendSnapshotFile(InputStream inputStream) {
        String currentVersion = this.getCurrentVersion();
        LOG.info("Sending settings.sync.snapshot.zip, current version: " + currentVersion);
        this.clientVersionContext.doWithVersion(currentVersion, (Function0)new Function0<Unit>(this, inputStream){
            final /* synthetic */ CloudConfigServerCommunicator this$0;
            final /* synthetic */ InputStream $inputStream;

            public final void invoke() {
                CloudConfigServerCommunicator.access$getClient$p(this.this$0).write("settings.sync.snapshot.zip", this.$inputStream);
            }
            {
                this.this$0 = cloudConfigServerCommunicator;
                this.$inputStream = inputStream;
                super(0);
            }
        });
    }

    private final String getCurrentVersion() {
        String string;
        String string2;
        String rememberedVersion = this.currentVersionOfFiles.get("settings.sync.snapshot.zip");
        if (rememberedVersion != null) {
            return rememberedVersion;
        }
        try {
            FileVersionInfo fileVersionInfo = this.getClient().getLatestVersion("settings.sync.snapshot.zip");
            string2 = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
        }
        catch (FileNotFoundException e) {
            LOG.info("File not found on server");
            string2 = null;
        }
        String serverVersion = string2;
        if (serverVersion != null) {
            LOG.warn("Current version is null, using the version from the server: " + serverVersion);
            string = serverVersion;
        } else {
            LOG.info("No settings file on the server");
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public ServerState checkServerState() {
        try {
            String string;
            FileVersionInfo fileVersionInfo = this.getClient().getLatestVersion("settings.sync.snapshot.zip");
            String string2 = string = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
            if (string == null) {
                return ServerState.FileNotExists.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)string, (Object)this.currentVersionOfFiles.get("settings.sync.snapshot.zip"))) {
                return ServerState.UpToDate.INSTANCE;
            }
            return ServerState.UpdateNeeded.INSTANCE;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            return new ServerState.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public UpdateResult receiveUpdates() {
        LOG.info("Receiving settings snapshot from the cloud config server...");
        try {
            InputStream stream2 = this.receiveSnapshotFile();
            if (stream2 == null) {
                LOG.info("settings.sync.snapshot.zip not found on the server");
                return UpdateResult.NoFileOnServer.INSTANCE;
            }
            File tempFile = FileUtil.createTempFile((String)"settings.sync.snapshot", (String)(UUID.randomUUID().toString() + ".zip"));
            try {
                FileUtil.writeToFile((File)tempFile, (byte[])stream2.readAllBytes());
                SettingsSnapshot snapshot = LocalDirSettingsSyncRemoteCommunicatorKt.extractZipFile(tempFile.toPath());
                UpdateResult updateResult = snapshot.isEmpty() ? (UpdateResult)UpdateResult.NoFileOnServer.INSTANCE : (UpdateResult)new UpdateResult.Success(snapshot);
                return updateResult;
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            return new UpdateResult.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SettingsSyncPushResult push(@NotNull SettingsSnapshot snapshot) {
        Object object;
        LOG.info("Pushing setting snapshot to the cloud config server...");
        try {
            object = LocalDirSettingsSyncRemoteCommunicatorKt.prepareTempZipFile(snapshot);
        }
        catch (Throwable e) {
            LOG.warn(e);
            String string = e.getMessage();
            if (string == null) {
                string = "Couldn't prepare zip file";
            }
            return new SettingsSyncPushResult.Error(string);
        }
        Path zip = object;
        try {
            this.sendSnapshotFile(PathKt.inputStream((Path)zip));
            object = SettingsSyncPushResult.Success.INSTANCE;
            return object;
        }
        catch (InvalidVersionIdException ive) {
            LOG.info("Rejected: version doesn't match the version on server: " + ive.getMessage());
            SettingsSyncPushResult e = SettingsSyncPushResult.Rejected.INSTANCE;
            return e;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            SettingsSyncPushResult settingsSyncPushResult = new SettingsSyncPushResult.Error(message);
            return settingsSyncPushResult;
        }
        finally {
            try {
                PathKt.delete$default((Path)zip, (boolean)false, (int)1, null);
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
    }

    private final String handleRemoteError(Throwable e) {
        String defaultMessage = "Error during communication with server";
        if (e instanceof IOException) {
            LOG.warn(e);
            String string = e.getMessage();
            if (string == null) {
                string = defaultMessage;
            }
            return string;
        }
        LOG.error(e);
        return defaultMessage;
    }

    @Nullable
    public final InputStream downloadSnapshot(@NotNull FileVersionInfo version2) {
        InputStream stream2 = (InputStream)this.clientVersionContext.doWithVersion(version2.getVersionId(), (Function0)new Function0<InputStream>(this){
            final /* synthetic */ CloudConfigServerCommunicator this$0;

            public final InputStream invoke() {
                return CloudConfigServerCommunicator.access$getClient$p(this.this$0).read("settings.sync.snapshot.zip");
            }
            {
                this.this$0 = cloudConfigServerCommunicator;
                super(0);
            }
        });
        if (stream2 == null) {
            LOG.info("settings.sync.snapshot.zip not found on the server");
        }
        return stream2;
    }

    @Nullable
    public final FileVersionInfo getLatestVersion() {
        return this.getClient().getLatestVersion("settings.sync.snapshot.zip");
    }

    @Override
    public void delete() throws IOException {
        this.currentVersionOfFiles.remove("settings.sync.snapshot.zip");
        this.getClient().delete("settings.sync.snapshot.zip");
    }

    @NotNull
    public final List<FileVersionInfo> fetchHistory() throws Exception {
        return this.getClient().getVersions("settings.sync.snapshot.zip");
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CloudConfigServerCommunicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        DUMMY_ETAG_STORAGE = new ETagStorage(){

            @Nullable
            public String get(@NotNull String path) {
                return null;
            }

            public void store(@NotNull String path, @NotNull String value) {
            }

            public void remove(@Nullable String path) {
            }
        };
    }

    public static final /* synthetic */ CloudConfigFileClientV2 access$getClient$p(CloudConfigServerCommunicator $this) {
        return $this.getClient();
    }

    public static final /* synthetic */ Configuration access$createConfiguration(CloudConfigServerCommunicator $this) {
        return $this.createConfiguration();
    }

    public static final /* synthetic */ ETagStorage access$getDUMMY_ETAG_STORAGE$cp() {
        return DUMMY_ETAG_STORAGE;
    }

    public static final /* synthetic */ VersionContext access$getClientVersionContext$p(CloudConfigServerCommunicator $this) {
        return $this.clientVersionContext;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0096\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator$VersionContext;", "Lcom/jetbrains/cloudconfig/HeaderStorage;", "(Lcom/intellij/settingsSync/CloudConfigServerCommunicator;)V", "contextVersionMap", "", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "doWithVersion", "T", "version", "function", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "get", "path", "remove", "", "store", "value", "intellij.settingsSync"})
    private final class VersionContext
    implements HeaderStorage {
        private final Map<String, String> contextVersionMap = new LinkedHashMap();
        private final ReentrantLock lock = new ReentrantLock();

        @Nullable
        public String get(@NotNull String path) {
            return this.contextVersionMap.get(path);
        }

        public void store(@NotNull String path, @NotNull String value) {
            this.contextVersionMap.put(path, value);
        }

        public void remove(@Nullable String path) {
            Map<String, String> map = this.contextVersionMap;
            TypeIntrinsics.asMutableMap(map).remove(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T doWithVersion(@Nullable String version2, @NotNull Function0<? extends T> function) {
            Object object;
            String path = "settings.sync.snapshot.zip";
            Lock lock = this.lock;
            lock.lock();
            try {
                Object object2;
                boolean bl = false;
                try {
                    if (version2 != null) {
                        this.contextVersionMap.put(path, version2);
                    }
                    Object result2 = function.invoke();
                    String actualVersion = this.contextVersionMap.get(path);
                    if (actualVersion == null) {
                        LOG.warn("Version not stored in the context for " + path);
                    } else {
                        CloudConfigServerCommunicator.this.currentVersionOfFiles.put(path, actualVersion);
                    }
                    object2 = result2;
                }
                finally {
                    this.contextVersionMap.clear();
                }
                object = object2;
            }
            finally {
                lock.unlock();
            }
            return (T)object;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator$Companion;", "", "()V", "DUMMY_ETAG_STORAGE", "Lcom/jetbrains/cloudconfig/ETagStorage;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

