/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client.model;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/google/services/firebase/directaccess/client/model/DeviceSessionName;", "", "projectId", "", "sessionId", "(Ljava/lang/String;Ljava/lang/String;)V", "getProjectId", "()Ljava/lang/String;", "resourceName", "getResourceName", "getSessionId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "directaccess-client"})
public final class DeviceSessionName {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectId;
    @NotNull
    private final String sessionId;
    @NotNull
    public static final String PROJECT_FRAGMENT = "projects/([a-z0-9-]+)";
    @NotNull
    public static final String SESSION_FRAGMENT = "deviceSessions/(session-[a-z0-9-]+)";
    @NotNull
    private static final Regex NAME_PATTERN = new Regex("projects/([a-z0-9-]+)/deviceSessions/(session-[a-z0-9-]+)");

    public DeviceSessionName(@NotNull String projectId, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.projectId = projectId;
        this.sessionId = sessionId;
        if (!Companion.matches(this.getResourceName())) {
            boolean bl = false;
            String string = "\"" + this.getResourceName() + "\" does not match pattern \"" + NAME_PATTERN.getPattern() + "\"";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final String getResourceName() {
        return "projects/" + this.projectId + "/deviceSessions/" + this.sessionId;
    }

    @NotNull
    public final String component1() {
        return this.projectId;
    }

    @NotNull
    public final String component2() {
        return this.sessionId;
    }

    @NotNull
    public final DeviceSessionName copy(@NotNull String projectId, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        return new DeviceSessionName(projectId, sessionId);
    }

    public static /* synthetic */ DeviceSessionName copy$default(DeviceSessionName deviceSessionName, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = deviceSessionName.projectId;
        }
        if ((n & 2) != 0) {
            string2 = deviceSessionName.sessionId;
        }
        return deviceSessionName.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "DeviceSessionName(projectId=" + this.projectId + ", sessionId=" + this.sessionId + ")";
    }

    public int hashCode() {
        int result = this.projectId.hashCode();
        result = result * 31 + this.sessionId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeviceSessionName)) {
            return false;
        }
        DeviceSessionName deviceSessionName = (DeviceSessionName)other;
        if (!Intrinsics.areEqual((Object)this.projectId, (Object)deviceSessionName.projectId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sessionId, (Object)deviceSessionName.sessionId);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/google/services/firebase/directaccess/client/model/DeviceSessionName$Companion;", "", "()V", "NAME_PATTERN", "Lkotlin/text/Regex;", "PROJECT_FRAGMENT", "", "SESSION_FRAGMENT", "matches", "", "name", "directaccess-client"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean matches(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return NAME_PATTERN.matches((CharSequence)name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

