/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client.model;

import com.google.services.firebase.directaccess.client.model.DeviceSessionName;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/google/services/firebase/directaccess/client/model/DeviceAssociationName;", "", "parent", "Lcom/google/services/firebase/directaccess/client/model/DeviceSessionName;", "externalDeviceId", "", "(Lcom/google/services/firebase/directaccess/client/model/DeviceSessionName;Ljava/lang/String;)V", "getExternalDeviceId", "()Ljava/lang/String;", "getParent", "()Lcom/google/services/firebase/directaccess/client/model/DeviceSessionName;", "resourceName", "getResourceName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "directaccess-client"})
public final class DeviceAssociationName {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceSessionName parent;
    @NotNull
    private final String externalDeviceId;
    @NotNull
    private static final String DEVICE_ASSOCIATION_FRAGMENT = "devices/(device-[a-z0-9-]+)";
    @NotNull
    private static final Regex ASSOCIATION_NAME_PATTERN = new Regex("projects/([a-z0-9-]+)/deviceSessions/(session-[a-z0-9-]+)/devices/(device-[a-z0-9-]+)");

    public DeviceAssociationName(@NotNull DeviceSessionName parent, @NotNull String externalDeviceId) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)externalDeviceId, (String)"externalDeviceId");
        this.parent = parent;
        this.externalDeviceId = externalDeviceId;
        if (!ASSOCIATION_NAME_PATTERN.matches((CharSequence)this.getResourceName())) {
            boolean bl = false;
            String string = "\"" + this.getResourceName() + "\" does not match pattern \"" + ASSOCIATION_NAME_PATTERN.getPattern() + "\"";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final DeviceSessionName getParent() {
        return this.parent;
    }

    @NotNull
    public final String getExternalDeviceId() {
        return this.externalDeviceId;
    }

    @NotNull
    public final String getResourceName() {
        return this.parent.getResourceName() + "/devices/" + this.externalDeviceId;
    }

    @NotNull
    public final DeviceSessionName component1() {
        return this.parent;
    }

    @NotNull
    public final String component2() {
        return this.externalDeviceId;
    }

    @NotNull
    public final DeviceAssociationName copy(@NotNull DeviceSessionName parent, @NotNull String externalDeviceId) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)externalDeviceId, (String)"externalDeviceId");
        return new DeviceAssociationName(parent, externalDeviceId);
    }

    public static /* synthetic */ DeviceAssociationName copy$default(DeviceAssociationName deviceAssociationName, DeviceSessionName deviceSessionName, String string, int n, Object object) {
        if ((n & 1) != 0) {
            deviceSessionName = deviceAssociationName.parent;
        }
        if ((n & 2) != 0) {
            string = deviceAssociationName.externalDeviceId;
        }
        return deviceAssociationName.copy(deviceSessionName, string);
    }

    @NotNull
    public String toString() {
        return "DeviceAssociationName(parent=" + this.parent + ", externalDeviceId=" + this.externalDeviceId + ")";
    }

    public int hashCode() {
        int result = this.parent.hashCode();
        result = result * 31 + this.externalDeviceId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeviceAssociationName)) {
            return false;
        }
        DeviceAssociationName deviceAssociationName = (DeviceAssociationName)other;
        if (!Intrinsics.areEqual((Object)this.parent, (Object)deviceAssociationName.parent)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.externalDeviceId, (Object)deviceAssociationName.externalDeviceId);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/services/firebase/directaccess/client/model/DeviceAssociationName$Companion;", "", "()V", "ASSOCIATION_NAME_PATTERN", "Lkotlin/text/Regex;", "DEVICE_ASSOCIATION_FRAGMENT", "", "parseFrom", "Lcom/google/services/firebase/directaccess/client/model/DeviceAssociationName;", "name", "directaccess-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeviceAssociationName parseFrom(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            MatchResult matchResult = ASSOCIATION_NAME_PATTERN.matchEntire((CharSequence)name);
            if (matchResult == null) {
                throw new IllegalArgumentException("Could not parse device from " + name + ". Should match " + ASSOCIATION_NAME_PATTERN.getPattern());
            }
            MatchResult m = matchResult;
            MatchGroup matchGroup = m.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            MatchGroup project = matchGroup;
            MatchGroup matchGroup2 = m.getGroups().get(2);
            Intrinsics.checkNotNull((Object)matchGroup2);
            MatchGroup session = matchGroup2;
            MatchGroup matchGroup3 = m.getGroups().get(3);
            Intrinsics.checkNotNull((Object)matchGroup3);
            MatchGroup device = matchGroup3;
            return new DeviceAssociationName(new DeviceSessionName(project.getValue(), session.getValue()), device.getValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

