/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon;

import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.CloseCommand;
import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.OkayCommand;
import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.WriteCommand;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u0006J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/ResponseWriter;", "", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "toHexString", "", "int", "", "writeFailResponse", "", "streamId", "failureReason", "writeOkayResponse", "output", "writeResponse", "responseType", "adb-proxy"})
public final class ResponseWriter {
    @NotNull
    private final OutputStream outputStream;

    public ResponseWriter(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.outputStream = outputStream;
    }

    public final void writeOkayResponse(int streamId, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.writeResponse(streamId, "OKAY", output);
    }

    public static /* synthetic */ void writeOkayResponse$default(ResponseWriter responseWriter, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        responseWriter.writeOkayResponse(n, string);
    }

    public final void writeFailResponse(int streamId, @NotNull String failureReason) {
        Intrinsics.checkNotNullParameter((Object)failureReason, (String)"failureReason");
        this.writeResponse(streamId, "FAIL", failureReason);
    }

    private final void writeResponse(int streamId, String responseType, String output) {
        String outputString = responseType + (String)(((CharSequence)output).length() == 0 ? "" : this.toHexString(output.length()) + output);
        new OkayCommand(streamId, streamId).writeTo(this.outputStream);
        String string = outputString;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        new WriteCommand(streamId, streamId, byArray).writeTo(this.outputStream);
        new CloseCommand(streamId, streamId).writeTo(this.outputStream);
    }

    private final String toHexString(int n) {
        String string = "%04X";
        Object[] objectArray = new Object[]{n};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }
}

