/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon;

import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.CloseCommand;
import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.ConnectCommand;
import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.OkayCommand;
import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.OpenCommand;
import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.WriteCommand;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/Command;", "", "type", "", "firstArg", "secondArg", "payload", "", "(III[B)V", "writeTo", "", "outputStream", "Ljava/io/OutputStream;", "Companion", "UnknownCommandTypeException", "Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/ConnectCommand;", "Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/StreamCommand;", "adb-proxy"})
public abstract class Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int type;
    private final int firstArg;
    private final int secondArg;
    @NotNull
    private final byte[] payload;
    @NotNull
    private static final Object readLock = new Object();

    private Command(int type, int firstArg, int secondArg, byte[] payload) {
        this.type = type;
        this.firstArg = firstArg;
        this.secondArg = secondArg;
        this.payload = payload;
    }

    public /* synthetic */ Command(int n, int n2, int n3, byte[] byArray, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            byArray = new byte[]{};
        }
        this(n, n2, n3, byArray, null);
    }

    public final void writeTo(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        CRC32 crc = new CRC32();
        crc.update(this.payload, 0, this.payload.length);
        ByteBuffer buf = ByteBuffer.allocate(24).order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(this.type).putInt(this.firstArg).putInt(this.secondArg).putInt(this.payload.length).putInt((int)crc.getValue()).putInt(~this.type);
        buf.flip();
        byte[] byteArray = new byte[buf.remaining() + this.payload.length];
        buf.get(byteArray, 0, 24);
        System.arraycopy(this.payload, 0, byteArray, 24, this.payload.length);
        outputStream.write(byteArray);
    }

    public /* synthetic */ Command(int type, int firstArg, int secondArg, byte[] payload, DefaultConstructorMarker $constructor_marker) {
        this(type, firstArg, secondArg, payload);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/Command$Companion;", "", "()V", "readLock", "readFrom", "Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/Command;", "inputStream", "Ljava/io/InputStream;", "adb-proxy"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Command readFrom(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            ByteBuffer byteBuffer = ByteBuffer.allocate(24).order(ByteOrder.LITTLE_ENDIAN);
            Object object = readLock;
            synchronized (object) {
                Command command;
                boolean bl = false;
                inputStream.readNBytes(byteBuffer.array(), 0, 24);
                int commandId = byteBuffer.getInt(0);
                int firstArg = byteBuffer.getInt(4);
                int secondArg = byteBuffer.getInt(8);
                int payloadSize = byteBuffer.getInt(12);
                byte[] payload = new byte[payloadSize];
                inputStream.readNBytes(payload, 0, payloadSize);
                switch (commandId) {
                    case 1314410051: {
                        command = new ConnectCommand(firstArg, secondArg, new String(payload, Charsets.UTF_8));
                        break;
                    }
                    case 1313165391: {
                        command = new OpenCommand(firstArg, new String(payload, Charsets.UTF_8));
                        break;
                    }
                    case 1497451343: {
                        command = new OkayCommand(firstArg, secondArg);
                        break;
                    }
                    case 1163086915: {
                        command = new CloseCommand(firstArg, secondArg);
                        break;
                    }
                    case 1163154007: {
                        command = new WriteCommand(firstArg, secondArg, payload);
                        break;
                    }
                    default: {
                        throw new UnknownCommandTypeException(commandId);
                    }
                }
                Command command2 = command;
                return command2;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/Command$UnknownCommandTypeException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "commandType", "", "(I)V", "adb-proxy"})
    public static final class UnknownCommandTypeException
    extends Exception {
        public UnknownCommandTypeException(int commandType) {
            String string = "Unexpected command type: '%08X'";
            Object[] objectArray = new Object[]{commandType};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            super(string2);
        }
    }
}

