/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess.ui;

import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.devicemanager.DeviceManagerTab;
import com.android.tools.idea.devicemanager.DevicePanel;
import com.android.tools.idea.flags.StudioFlags;
import com.google.gct.directaccess.provisioner.NotLoggedInException;
import com.google.gct.directaccess.ui.FirebaseDevicePanel;
import com.google.gct.directaccess.ui.FirebaseDeviceTab;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.LoginState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import icons.DirectAccessIcons;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0015\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016\u00a8\u0006\u0019"}, d2={"Lcom/google/gct/directaccess/ui/FirebaseDeviceTab;", "Lcom/android/tools/idea/devicemanager/DeviceManagerTab;", "()V", "createNotLoggedInComponent", "Ljavax/swing/JComponent;", "getErrorComponent", "throwable", "", "getName", "", "getPanel", "Lcom/android/tools/idea/devicemanager/DevicePanel;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "isApplicable", "", "kotlin.jvm.PlatformType", "()Ljava/lang/Boolean;", "setRecreateCallback", "", "r", "Ljava/lang/Runnable;", "disposable", "directaccess"})
public final class FirebaseDeviceTab
implements DeviceManagerTab {
    public Boolean isApplicable() {
        return (Boolean)StudioFlags.DIRECT_ACCESS.get();
    }

    @NotNull
    public String getName() {
        return "Firebase";
    }

    @NotNull
    public DevicePanel getPanel(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        if (!GoogleLogin.Companion.getInstance().isLoggedIn()) {
            throw new NotLoggedInException();
        }
        return new FirebaseDevicePanel(project, parentDisposable);
    }

    @NotNull
    public JComponent getErrorComponent(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (throwable instanceof NotLoggedInException) {
            return this.createNotLoggedInComponent();
        }
        JComponent jComponent = super.getErrorComponent(throwable);
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"super.getErrorComponent(throwable)");
        return jComponent;
    }

    private final JComponent createNotLoggedInComponent() {
        StatusText statusText;
        StatusText $this$createNotLoggedInComponent_u24lambda_u2d0 = statusText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };
        boolean bl = false;
        $this$createNotLoggedInComponent_u24lambda_u2d0.appendLine(DirectAccessIcons.INSTANCE.getFIREBASE_LOGO(), "", SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        $this$createNotLoggedInComponent_u24lambda_u2d0.appendLine("");
        $this$createNotLoggedInComponent_u24lambda_u2d0.appendLine("Log in to Firebase Test Lab for direct access", SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        $this$createNotLoggedInComponent_u24lambda_u2d0.appendLine("to a variety of Android physical devices.", SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        $this$createNotLoggedInComponent_u24lambda_u2d0.appendLine("Log in", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)createNotLoggedInComponent.loggedOutText.2.1.INSTANCE);
        $this$createNotLoggedInComponent_u24lambda_u2d0.appendLine("");
        $this$createNotLoggedInComponent_u24lambda_u2d0.appendLine(AllIcons.General.ContextHelp, "Learn about Firebase Test Lab", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)createNotLoggedInComponent.loggedOutText.2.2.INSTANCE);
        StatusText loggedOutText2 = statusText;
        return new JPanel(loggedOutText2){
            final /* synthetic */ createNotLoggedInComponent.loggedOutText.1 $loggedOutText;
            {
                this.$loggedOutText = $loggedOutText;
                $loggedOutText.attachTo(this);
            }

            public void paint(@Nullable Graphics g) {
                super.paint(g);
                this.$loggedOutText.paint(this, g);
            }
        };
    }

    public void setRecreateCallback(@NotNull Runnable r, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        BuildersKt.launch$default((CoroutineScope)CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)disposable, null, (int)2, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(r, null){
            int label;
            final /* synthetic */ Runnable $r;
            {
                this.$r = $r;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Flow flow = LoginState.INSTANCE.getLoggedIn();
                        Runnable runnable = this.$r;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<Boolean>(runnable){
                            final /* synthetic */ Runnable $r$inlined;
                            {
                                this.$r$inlined = runnable;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @Nullable
                            public Object emit(Object value, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                boolean it = (Boolean)value;
                                boolean bl = false;
                                this.$r$inlined.run();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

