/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.devicemanager.ConnectionType;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.SerialNumber;
import com.google.gct.directaccess.provisioner.DeviceInfo;
import com.google.services.firebase.directaccess.client.DirectAccessConnection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/gct/directaccess/FirebaseDevice;", "Lcom/android/tools/idea/devicemanager/Device;", "device", "Lcom/google/gct/directaccess/provisioner/DeviceInfo;", "connectionState", "Lcom/google/services/firebase/directaccess/client/DirectAccessConnection$State;", "(Lcom/google/gct/directaccess/provisioner/DeviceInfo;Lcom/google/services/firebase/directaccess/client/DirectAccessConnection$State;)V", "builder", "Lcom/google/gct/directaccess/FirebaseDevice$Builder;", "(Lcom/google/gct/directaccess/FirebaseDevice$Builder;)V", "myState", "getIcon", "Ljavax/swing/Icon;", "isOnline", "", "Builder", "directaccess"})
public final class FirebaseDevice
extends Device {
    @NotNull
    private final DirectAccessConnection.State myState;

    private FirebaseDevice(Builder builder) {
        super((Device.Builder)builder);
        this.myState = builder.getMyState();
    }

    /*
     * WARNING - void declaration
     */
    public FirebaseDevice(@NotNull DeviceInfo device, @NotNull DirectAccessConnection.State connectionState) {
        String string;
        void $this$_init__u24lambda_u2d0;
        Builder builder;
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
        Builder builder2 = builder = new Builder();
        FirebaseDevice firebaseDevice = this;
        boolean bl = false;
        $this$_init__u24lambda_u2d0.setName(device.getManufacturer() + " " + device.getName());
        $this$_init__u24lambda_u2d0.setApi(device.getApi());
        $this$_init__u24lambda_u2d0.setType(device.getType());
        $this$_init__u24lambda_u2d0.setConnectionState(connectionState);
        switch (WhenMappings.$EnumSwitchMapping$0[connectionState.ordinal()]) {
            case 1: {
                string = "Reserving a device...";
                break;
            }
            case 2: {
                string = "Connecting to device...";
                break;
            }
            case 3: 
            case 4: {
                string = device.getCodename();
                break;
            }
            default: {
                string = device.getCodename();
            }
        }
        $this$_init__u24lambda_u2d0.setTarget(string);
        firebaseDevice(builder);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myType.getPhysicalIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"myType.physicalIcon");
        return icon;
    }

    public boolean isOnline() {
        return this.myState == DirectAccessConnection.State.CONNECTED;
    }

    public /* synthetic */ FirebaseDevice(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0014J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/google/gct/directaccess/FirebaseDevice$Builder;", "Lcom/android/tools/idea/devicemanager/Device$Builder;", "()V", "<set-?>", "Lcom/google/services/firebase/directaccess/client/DirectAccessConnection$State;", "myState", "getMyState", "()Lcom/google/services/firebase/directaccess/client/DirectAccessConnection$State;", "build", "Lcom/google/gct/directaccess/FirebaseDevice;", "setApi", "api", "", "setConnectionState", "connectionState", "setName", "name", "", "setTarget", "setType", "type", "Lcom/android/tools/idea/devicemanager/DeviceType;", "directaccess"})
    private static final class Builder
    extends Device.Builder {
        @NotNull
        private DirectAccessConnection.State myState = DirectAccessConnection.State.CLOSED;

        public Builder() {
            this.myKey = new Key(){

                @NotNull
                public ConnectionType getConnectionType() {
                    return ConnectionType.UNKNOWN;
                }

                @NotNull
                public SerialNumber getSerialNumber() {
                    return new SerialNumber("none");
                }

                public boolean isPersistent() {
                    return true;
                }
            };
        }

        @NotNull
        protected FirebaseDevice build() {
            return new FirebaseDevice(this, null);
        }

        @NotNull
        public final DirectAccessConnection.State getMyState() {
            return this.myState;
        }

        @NotNull
        public final Builder setName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.myName = name;
            return this;
        }

        @NotNull
        public final Builder setTarget(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.myTarget = name;
            return this;
        }

        @NotNull
        public final Builder setApi(int api) {
            this.myAndroidVersion = new AndroidVersion(api);
            return this;
        }

        @NotNull
        public final Builder setType(@NotNull DeviceType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.myType = type;
            return this;
        }

        @NotNull
        public final Builder setConnectionState(@NotNull DirectAccessConnection.State connectionState) {
            Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
            this.myState = connectionState;
            return this;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DirectAccessConnection.State.values().length];
            nArray[DirectAccessConnection.State.RESERVING.ordinal()] = 1;
            nArray[DirectAccessConnection.State.RESERVED.ordinal()] = 2;
            nArray[DirectAccessConnection.State.CONNECTED.ordinal()] = 3;
            nArray[DirectAccessConnection.State.STREAMING.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

