/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;

public final class PsiUtil {
    private static final Key<Boolean> IDEA_PROJECT = Key.create((String)"idea.internal.inspections.enabled");
    @NonNls
    private static final String IDE_PROJECT_MARKER_CLASS = JBList.class.getName();
    @NonNls
    private static final String[] IDEA_PROJECT_MARKER_FILES = new String[]{"idea.iml", "community-main.iml", "intellij.idea.community.main.iml", "intellij.idea.ultimate.main.iml"};
    private static final List<String> IDEA_PROJECT_MARKER_MODULE_NAMES = List.of("intellij.idea.community.main", "intellij.platform.commercial");

    private PsiUtil() {
    }

    public static boolean isInstantiable(@NotNull PsiClass psiClass) {
        if (psiClass instanceof PsiTypeParameter || psiClass.hasModifierProperty("private") || psiClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (psiClass.getContainingClass() != null && !psiClass.hasModifierProperty("static")) {
            return false;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            int parametersCount = constructor.getParameterList().getParametersCount();
            if (parametersCount > 1) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiMethod findNearestMethod(String name, @Nullable PsiClass cls) {
        if (cls == null) {
            return null;
        }
        for (PsiMethod method : cls.findMethodsByName(name, false)) {
            if (!method.getParameterList().isEmpty()) continue;
            return method.getModifierList().hasModifierProperty("abstract") ? null : method;
        }
        return PsiUtil.findNearestMethod(name, cls.getSuperClass());
    }

    @Nullable
    public static PsiAnnotation findAnnotation(Class<?> annotationClass, PsiMember ... members) {
        for (PsiMember member : members) {
            PsiAnnotation annotation;
            if (member == null || (annotation = member.getAnnotation(annotationClass.getName())) == null) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static String getAnnotationStringAttribute(PsiAnnotation annotation, String name, String defaultValueIfEmpty) {
        String value = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)name);
        return StringUtil.defaultIfEmpty((String)value, (String)defaultValueIfEmpty);
    }

    public static boolean getAnnotationBooleanAttribute(PsiAnnotation annotation, String name) {
        return (Boolean)ObjectUtils.notNull((Object)AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)name), (Object)Boolean.FALSE);
    }

    public static boolean isIdeaProject(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        Boolean flag = (Boolean)project.getUserData(IDEA_PROJECT);
        if (flag == null) {
            flag = PsiUtil.checkIdeaProject(project);
            project.putUserData(IDEA_PROJECT, (Object)flag);
        }
        return flag;
    }

    @Nullable
    public static UExpression getReturnedExpression(PsiMethod method) {
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class);
        if (uMethod == null) {
            return null;
        }
        UExpression uBody = uMethod.getUastBody();
        if (!(uBody instanceof UBlockExpression)) {
            return null;
        }
        List expressions = ((UBlockExpression)uBody).getExpressions();
        UExpression singleExpression = (UExpression)ContainerUtil.getOnlyItem((Collection)expressions);
        if (singleExpression == null) {
            return null;
        }
        if (!(singleExpression instanceof UReturnExpression)) {
            return null;
        }
        UReturnExpression uReturnExpression = (UReturnExpression)singleExpression;
        UExpression returnValue = uReturnExpression.getReturnExpression();
        if (returnValue == null) {
            return null;
        }
        if (returnValue instanceof UReferenceExpression) {
            UReferenceExpression referenceExpression = (UReferenceExpression)returnValue;
            UElement uElement = UResolvableKt.resolveToUElement((UResolvable)referenceExpression);
            UField uField = (UField)ObjectUtils.tryCast((Object)uElement, UField.class);
            if (uField != null && uField.isFinal()) {
                return uField.getUastInitializer();
            }
            return (UExpression)ObjectUtils.tryCast((Object)uElement, UExpression.class);
        }
        if (returnValue instanceof UCallExpression) {
            UCallExpression uCallExpression = (UCallExpression)returnValue;
            PsiMethod psiMethod = uCallExpression.resolve();
            if (psiMethod == null) {
                return null;
            }
            return PsiUtil.getReturnedExpression(psiMethod);
        }
        return returnValue;
    }

    public static boolean isPluginProject(@NotNull Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass(IDE_PROJECT_MARKER_CLASS, GlobalSearchScope.allScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    public static boolean isPluginModule(@NotNull Module module) {
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(IDE_PROJECT_MARKER_CLASS, GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)module.getProject()));
        });
    }

    @TestOnly
    public static void markAsIdeaProject(@NotNull Project project, boolean value) {
        project.putUserData(IDEA_PROJECT, (Object)value);
    }

    private static boolean checkIdeaProject(@NotNull Project project) {
        for (String moduleName : IDEA_PROJECT_MARKER_MODULE_NAMES) {
            if (ModuleManager.getInstance((Project)project).findModuleByName(moduleName) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isPluginXmlPsiElement(@NotNull PsiElement element) {
        return PsiUtil.isPluginProject(element.getProject()) && DescriptorUtil.isPluginXml(element.getContainingFile());
    }

    public static boolean isPathToIntelliJIdeaSources(String path) {
        for (String file : IDEA_PROJECT_MARKER_FILES) {
            if (!new File(path, file).isFile()) continue;
            return true;
        }
        return false;
    }
}

