/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionByExtensionPointLocator;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocator;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006\u001a,\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000e\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a<\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00170\u0019H\u0000\u001a5\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001a\b\u0004\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u0019H\u0080\b\u00a8\u0006\u001d"}, d2={"findExtensionsByClassName", "", "Lorg/jetbrains/idea/devkit/util/ExtensionCandidate;", "project", "Lcom/intellij/openapi/project/Project;", "className", "", "locateExtensionsByExtensionPoint", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "locateExtensionsByExtensionPointAndId", "Lorg/jetbrains/idea/devkit/util/ExtensionLocator;", "extensionId", "extensionIdFunction", "Lkotlin/Function1;", "Lorg/jetbrains/idea/devkit/dom/Extension;", "locateExtensionsByPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "processExtensionDeclarations", "", "name", "strictMatch", "", "callback", "Lkotlin/Function2;", "Lcom/intellij/psi/xml/XmlTag;", "processExtensionsByClassName", "processor", "intellij.devkit.core"})
public final class ExtensionLocatorKt {
    @NotNull
    public static final List<ExtensionCandidate> locateExtensionsByPsiClass(@NotNull PsiClass psiClass) {
        String string = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        return ExtensionLocatorKt.findExtensionsByClassName(psiClass.getProject(), string);
    }

    @NotNull
    public static final List<ExtensionCandidate> locateExtensionsByExtensionPoint(@NotNull ExtensionPoint extensionPoint) {
        return new ExtensionByExtensionPointLocator(extensionPoint.getXmlTag().getProject(), extensionPoint, null, null, 8, null).findCandidates();
    }

    @NotNull
    public static final ExtensionLocator locateExtensionsByExtensionPointAndId(@NotNull ExtensionPoint extensionPoint, @NotNull String extensionId) {
        return new ExtensionByExtensionPointLocator(extensionPoint.getXmlTag().getProject(), extensionPoint, extensionId, null, 8, null);
    }

    @NotNull
    public static final ExtensionLocator locateExtensionsByExtensionPointAndId(@NotNull ExtensionPoint extensionPoint, @NotNull String extensionId, @NotNull Function1<? super Extension, String> extensionIdFunction) {
        return new ExtensionByExtensionPointLocator(extensionPoint.getXmlTag().getProject(), extensionPoint, extensionId, extensionIdFunction);
    }

    public static final void processExtensionDeclarations(@NotNull String name, @NotNull Project project, boolean strictMatch, @NotNull Function2<? super Extension, ? super XmlTag, Boolean> callback) {
        GlobalSearchScope scope = PluginRelatedLocatorsUtils.getCandidatesScope(project);
        String searchWord = StringsKt.substringBeforeLast$default((String)name, (char)'$', null, (int)2, null);
        CharSequence charSequence = searchWord;
        if (charSequence.length() == 0) {
            return;
        }
        PsiSearchHelper.getInstance((Project)project).processElementsWithWord(new TextOccurenceProcessor(strictMatch, name, project, callback){
            final /* synthetic */ boolean $strictMatch;
            final /* synthetic */ String $name;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function2 $callback;

            public final boolean execute(@NotNull PsiElement element, int offsetInElement) {
                XmlTag xmlTag;
                PsiElement psiElement = element;
                if (!(psiElement instanceof XmlTag)) {
                    psiElement = null;
                }
                if ((xmlTag = (XmlTag)psiElement) == null || (xmlTag = xmlTag.findElementAt(offsetInElement)) == null) {
                    return true;
                }
                XmlTag elementAtOffset = xmlTag;
                if (this.$strictMatch ? !elementAtOffset.textMatches((CharSequence)this.$name) : !StringUtil.contains((CharSequence)elementAtOffset.getText(), (CharSequence)this.$name)) {
                    return true;
                }
                DomElement domElement = DomManager.getDomManager((Project)this.$project).getDomElement((XmlTag)element);
                if (!(domElement instanceof Extension)) {
                    domElement = null;
                }
                Extension extension = (Extension)domElement;
                if (extension == null) {
                    return true;
                }
                Extension extension2 = extension;
                return (Boolean)this.$callback.invoke((Object)extension2, (Object)element);
            }
            {
                this.$strictMatch = bl;
                this.$name = string;
                this.$project = project;
                this.$callback = function2;
            }
        }, (SearchScope)scope, searchWord, (short)8, true);
    }

    public static /* synthetic */ void processExtensionDeclarations$default(String string, Project project, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        ExtensionLocatorKt.processExtensionDeclarations(string, project, bl, (Function2<? super Extension, ? super XmlTag, Boolean>)function2);
    }

    private static final List<ExtensionCandidate> findExtensionsByClassName(Project project, String className) {
        List<ExtensionCandidate> result = Collections.synchronizedList((List)new SmartList());
        KProperty kProperty = null;
        Lazy smartPointerManager2 = LazyKt.lazy((Function0)((Function0)new Function0<SmartPointerManager>(project){
            final /* synthetic */ Project $project;

            public final SmartPointerManager invoke() {
                return SmartPointerManager.getInstance((Project)this.$project);
            }
            {
                this.$project = project;
                super(0);
            }
        }));
        boolean $i$f$processExtensionsByClassName = false;
        ExtensionLocatorKt.processExtensionDeclarations$default(className, project, false, (Function2)new Function2<Extension, XmlTag, Boolean>(result, smartPointerManager2, kProperty){
            final /* synthetic */ List $result$inlined;
            final /* synthetic */ Lazy $smartPointerManager$inlined;
            final /* synthetic */ KProperty $smartPointerManager$metadata$inlined;
            {
                this.$result$inlined = list2;
                this.$smartPointerManager$inlined = lazy;
                this.$smartPointerManager$metadata$inlined = kProperty;
                super(2);
            }

            public final boolean invoke(@NotNull Extension extension, @NotNull XmlTag tag) {
                boolean bl;
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint != null) {
                    ExtensionPoint extensionPoint2;
                    ExtensionPoint it = extensionPoint2 = extensionPoint;
                    boolean bl2 = false;
                    ExtensionPoint extensionPoint3 = it;
                    XmlTag tag2 = tag;
                    boolean bl3 = false;
                    Lazy lazy = this.$smartPointerManager$inlined;
                    Object var10_10 = null;
                    KProperty kProperty = this.$smartPointerManager$metadata$inlined;
                    this.$result$inlined.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)((SmartPointerManager)lazy.getValue()).createSmartPsiElementPointer((PsiElement)tag2)));
                    bl = true;
                } else {
                    bl = true;
                }
                return bl;
            }
        }, 4, null);
        return result;
    }

    public static final void processExtensionsByClassName(@NotNull Project project, @NotNull String className, @NotNull Function2<? super XmlTag, ? super ExtensionPoint, Boolean> processor) {
        int $i$f$processExtensionsByClassName = 0;
        ExtensionLocatorKt.processExtensionDeclarations$default(className, project, false, (Function2)new Function2<Extension, XmlTag, Boolean>(processor){
            final /* synthetic */ Function2 $processor;

            public final boolean invoke(@NotNull Extension extension, @NotNull XmlTag tag) {
                boolean bl;
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint != null) {
                    ExtensionPoint extensionPoint2;
                    ExtensionPoint it = extensionPoint2 = extensionPoint;
                    boolean bl2 = false;
                    bl = (Boolean)this.$processor.invoke((Object)tag, (Object)it);
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$processor = function2;
                super(2);
            }
        }, 4, null);
    }
}

