/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;

public final class DescriptorUtil {
    private DescriptorUtil() {
    }

    public static void processComponents(XmlTag root, ComponentType.Processor processor) {
        ComponentType[] types;
        for (ComponentType type2 : types = ComponentType.values()) {
            type2.process(root, processor);
        }
    }

    public static void processActions(XmlTag root, ActionType.Processor processor) {
        ActionType[] types;
        for (ActionType type2 : types = ActionType.values()) {
            type2.process(root, processor);
        }
    }

    public static void patchPluginXml(Patcher patcher, PsiClass klass, XmlFile pluginXml) throws IncorrectOperationException {
        DescriptorUtil.checkPluginXmlsWritable(klass.getProject(), pluginXml);
        WriteAction.run(() -> patcher.patchPluginXml(pluginXml, klass));
    }

    public static void checkPluginXmlsWritable(Project project, XmlFile pluginXml) {
        VirtualFile file = pluginXml.getVirtualFile();
        ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)project);
        ReadonlyStatusHandler.OperationStatus status = readonlyStatusHandler.ensureFilesWritable(Collections.singletonList(file));
        if (status.hasReadonlyFiles()) {
            throw new IncorrectOperationException(DevKitBundle.message("error.plugin.xml.readonly", status.getReadonlyFiles()[0]));
        }
    }

    public static List<String> getPluginAndOptionalDependenciesIds(Module module) {
        XmlFile xml = PluginModuleType.getPluginXml(module);
        if (xml == null) {
            return Collections.emptyList();
        }
        IdeaPlugin plugin = DescriptorUtil.getIdeaPlugin(xml);
        if (plugin == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        ContainerUtil.addIfNotNull(result, (Object)plugin.getPluginId());
        for (Dependency dependency : plugin.getDepends()) {
            if (!Boolean.TRUE.equals(dependency.getOptional().getValue())) continue;
            ContainerUtil.addIfNotNull(result, (Object)dependency.getRawText());
        }
        return result;
    }

    public static boolean isPluginXml(@Nullable PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return DescriptorUtil.getIdeaPluginFileElement((XmlFile)file) != null;
    }

    @Nullable
    public static DomFileElement<IdeaPlugin> getIdeaPluginFileElement(@NotNull XmlFile file) {
        return DomManager.getDomManager((Project)file.getProject()).getFileElement(file, IdeaPlugin.class);
    }

    @Nullable
    public static IdeaPlugin getIdeaPlugin(@NotNull XmlFile file) {
        DomFileElement<IdeaPlugin> plugin = DescriptorUtil.getIdeaPluginFileElement(file);
        return plugin != null ? (IdeaPlugin)plugin.getRootElement() : null;
    }

    @NotNull
    public static Collection<IdeaPlugin> getPlugins(Project project, GlobalSearchScope scope) {
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyList();
        }
        List files = DomService.getInstance().getFileElements(IdeaPlugin.class, project, scope);
        return ContainerUtil.map((Collection)files, ideaPluginDomFileElement -> (IdeaPlugin)ideaPluginDomFileElement.getRootElement());
    }

    public static interface Patcher {
        public void patchPluginXml(XmlFile var1, PsiClass var2) throws IncorrectOperationException;
    }
}

