/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.uiDesigner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwHSpacer;
import com.intellij.uiDesigner.lw.LwVSpacer;
import com.intellij.uiDesigner.lw.StringDescriptor;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.uiDesigner.ConvertFormToDslActionKt;
import org.jetbrains.idea.devkit.uiDesigner.FormCall;
import org.jetbrains.idea.devkit.uiDesigner.PropertyBinding;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastVisibility;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u0017\u001a\u00020\u0018*\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e*\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cH\u0002J\u0014\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/idea/devkit/uiDesigner/FormToDslConverter;", "", "module", "Lcom/intellij/openapi/module/Module;", "boundInstanceUClass", "Lorg/jetbrains/uast/UClass;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/uast/UClass;)V", "convertBinding", "Lorg/jetbrains/idea/devkit/uiDesigner/PropertyBinding;", "binding", "", "convertComponent", "Lorg/jetbrains/idea/devkit/uiDesigner/FormCall;", "component", "Lcom/intellij/uiDesigner/lw/IComponent;", "convertComponentOrContainer", "convertComponentText", "convertContainer", "container", "Lcom/intellij/uiDesigner/lw/LwContainer;", "convertStringDescriptor", "text", "Lcom/intellij/uiDesigner/lw/StringDescriptor;", "appendGridRow", "", "layoutManager", "Lcom/intellij/uiDesigner/core/GridLayoutManager;", "rowIndex", "", "collectComponentsInRow", "", "row", "columnCount", "matchesBinding", "", "Lcom/intellij/psi/PsiNamedElement;", "intellij.devkit.uiDesigner"})
public final class FormToDslConverter {
    private final Module module;
    private final UClass boundInstanceUClass;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FormCall convertContainer(@NotNull LwContainer container) {
        FormCall row = null;
        StringDescriptor borderTitle = container.getBorderTitle();
        if (borderTitle != null) {
            row = new FormCall("titledRow", null, null, (IComponent)container, null, null, false, 118, null);
            row.getArgs().add(this.convertStringDescriptor(borderTitle));
        } else {
            row = new FormCall("row", null, null, (IComponent)container, null, null, false, 118, null);
        }
        LayoutManager layoutManager = container.getLayout();
        if (layoutManager instanceof GridLayoutManager) {
            int n = 0;
            int n2 = ((GridLayoutManager)layoutManager).getRowCount();
            while (n < n2) {
                void rowIndex;
                this.appendGridRow(row, container, (GridLayoutManager)layoutManager, (int)rowIndex);
                ++rowIndex;
            }
        } else {
            int rowIndex = 0;
            int n = container.getComponentCount();
            while (rowIndex < n) {
                void index;
                row.getContents().add(this.convertComponentOrContainer(container.getComponent((int)index)));
                ++index;
            }
        }
        return row;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendGridRow(FormCall $this$appendGridRow, LwContainer container, GridLayoutManager layoutManager, int rowIndex) {
        void $this$filterTo$iv$iv;
        List<IComponent> allComponents = this.collectComponentsInRow(container, rowIndex, layoutManager.getColumnCount());
        Iterable $this$filter$iv = allComponents;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IComponent it = (IComponent)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof LwHSpacer) && !(it instanceof LwVSpacer))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List components = (List)destination$iv$iv;
        if (components.isEmpty()) {
            return;
        }
        FormCall row = new FormCall("row", null, null, (IComponent)container, null, null, false, 118, null);
        $this$appendGridRow.getContents().add(row);
        if (Intrinsics.areEqual((Object)((IComponent)CollectionsKt.first((List)components)).getComponentClassName(), (Object)"javax.swing.JLabel")) {
            row.getArgs().add(this.convertComponentText((IComponent)CollectionsKt.first((List)components)));
            for (IComponent component : CollectionsKt.drop((Iterable)components, (int)1)) {
                row.getContents().add(this.convertComponentOrContainer(component));
            }
        } else {
            for (IComponent component : components) {
                row.getContents().add(this.convertComponentOrContainer(component));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IComponent> collectComponentsInRow(LwContainer $this$collectComponentsInRow, int row, int columnCount) {
        Object[] result = new IComponent[columnCount];
        int n = 0;
        int n2 = $this$collectComponentsInRow.getComponentCount();
        while (n < n2) {
            void i;
            IComponent component = $this$collectComponentsInRow.getComponent((int)i);
            GridConstraints constraints = component.getConstraints();
            if (constraints.getRow() == row) {
                result[constraints.getColumn()] = component;
            }
            ++i;
        }
        return CollectionsKt.filterNotNull((Iterable)ArraysKt.toList((Object[])result));
    }

    private final FormCall convertComponentOrContainer(IComponent component) {
        if (component instanceof LwContainer) {
            return this.convertContainer((LwContainer)component);
        }
        FormCall result = this.convertComponent(component);
        result.setOrigin(component);
        result.setBinding(component.getBinding());
        result.setBindingType(component.getComponentClassName());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final FormCall convertComponent(IComponent component) {
        FormCall formCall;
        PropertyBinding propertyBinding = this.convertBinding(component.getBinding());
        String string = component.getComponentClassName();
        if (string != null) {
            switch (string) {
                case "com.intellij.ui.components.JBCheckBox": 
                case "javax.swing.JCheckBox": {
                    PropertyBinding propertyBinding2 = propertyBinding;
                    formCall = new FormCall("checkBox", this.convertComponentText(component)).addArgIfPresent((String[])(propertyBinding2 != null ? propertyBinding2.getBindingCallParameters() : null));
                    return formCall;
                }
                case "javax.swing.JTextField": {
                    PropertyBinding propertyBinding3 = propertyBinding;
                    String methodName = Intrinsics.areEqual((Object)(propertyBinding3 != null && (propertyBinding3 = propertyBinding3.getType()) != null ? propertyBinding3.getCanonicalText() : null), (Object)"int") ? "intTextField" : "textField";
                    PropertyBinding propertyBinding4 = propertyBinding;
                    formCall = new FormCall(methodName, null, null, null, null, null, false, 126, null).addArgOrDefault((String[])(propertyBinding4 != null ? propertyBinding4.getBindingCallParameters() : null), "{ \"\" }", "{}");
                    return formCall;
                }
                case "com.intellij.openapi.ui.TextFieldWithBrowseButton": {
                    PropertyBinding propertyBinding5 = propertyBinding;
                    formCall = new FormCall("textFieldWithBrowseButton", null, null, null, null, null, false, 126, null).addArgOrDefault((String[])(propertyBinding5 != null ? propertyBinding5.getBindingCallParameters() : null), "{ \"\" }", "{}");
                    return formCall;
                }
                case "com.intellij.ui.components.JBRadioButton": 
                case "javax.swing.JRadioButton": {
                    formCall = new FormCall("radioButton", this.convertComponentText(component));
                    return formCall;
                }
                case "javax.swing.JButton": {
                    formCall = new FormCall("button", this.convertComponentText(component), "actionListener = { TODO() }");
                    return formCall;
                }
                case "javax.swing.JLabel": 
                case "com.intellij.ui.components.JBLabel": {
                    formCall = new FormCall("label", this.convertComponentText(component));
                    return formCall;
                }
                case "com.intellij.openapi.ui.ComboBox": 
                case "javax.swing.JComboBox": {
                    formCall = new FormCall("comboBox", "TODO()");
                    return formCall;
                }
            }
        }
        String typeParameters = ConvertFormToDslActionKt.access$buildTypeParametersString(this.module, component.getComponentClassName());
        String classShortName = StringsKt.substringAfterLast$default((String)component.getComponentClassName(), (char)'.', null, (int)2, null);
        formCall = new FormCall(classShortName + typeParameters + "()", null, null, null, null, null, true, 62, null);
        return formCall;
    }

    private final PropertyBinding convertBinding(String binding) {
        UField setter;
        UField getter;
        block8: {
            UField uField;
            UField uField2;
            int n;
            UField[] uFieldArray;
            block7: {
                UField field;
                int n2;
                UField[] uFieldArray2;
                block6: {
                    UField uField3;
                    UField[] uFieldArray3;
                    if (binding == null || this.boundInstanceUClass == null) {
                        return null;
                    }
                    uFieldArray2 = uFieldArray3 = this.boundInstanceUClass.getFields();
                    n2 = uFieldArray2.length;
                    for (int i = 0; i < n2; ++i) {
                        UField uField4;
                        UField it = uField4 = uFieldArray2[i];
                        boolean bl = false;
                        if (!this.matchesBinding((PsiNamedElement)it, binding)) continue;
                        uField3 = uField4;
                        break block6;
                    }
                    uField3 = field = null;
                }
                if (field != null && !field.isStatic() && field.getVisibility() != UastVisibility.PRIVATE) {
                    return new PropertyBinding(field.getType(), new String[]{"model::" + field.getName()});
                }
                uFieldArray = uFieldArray2 = this.boundInstanceUClass.getMethods();
                n = uFieldArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    UField uField5;
                    UField it = uField5 = uFieldArray[n2];
                    boolean bl = false;
                    if (!(!StringsKt.startsWith$default((String)it.getName(), (String)"set", (boolean)false, (int)2, null) && this.matchesBinding((PsiNamedElement)it, binding))) continue;
                    uField2 = uField5;
                    break block7;
                }
                uField2 = null;
            }
            getter = uField2;
            UField[] uFieldArray4 = uFieldArray = this.boundInstanceUClass.getMethods();
            int n3 = uFieldArray4.length;
            for (n = 0; n < n3; ++n) {
                UField uField6;
                UField it = uField6 = uFieldArray4[n];
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it.getName(), (String)"set", (boolean)false, (int)2, null) && this.matchesBinding((PsiNamedElement)it, binding))) continue;
                uField = uField6;
                break block8;
            }
            uField = setter = null;
        }
        if (getter != null && setter != null) {
            return new PropertyBinding(getter.getReturnType(), new String[]{"model::" + getter.getName(), "model::" + setter.getName()});
        }
        return null;
    }

    private final boolean matchesBinding(PsiNamedElement $this$matchesBinding, String binding) {
        int n;
        List bindingWords = NameUtil.nameToWordsLowerCase((String)StringsKt.removePrefix((String)binding, (CharSequence)"my"));
        String string = $this$matchesBinding.getName();
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"my")) == null) {
            string = "";
        }
        List elementWords = NameUtil.nameToWordsLowerCase((String)string);
        if (bindingWords.size() == 1 && elementWords.size() == 1) {
            return Intrinsics.areEqual((Object)((String)bindingWords.get(0)), (Object)((String)elementWords.get(0)));
        }
        Iterable $this$count$iv = bindingWords;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                int n2;
                String it = (String)element$iv;
                boolean bl = false;
                if (!elementWords.contains(it) || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > 1;
    }

    private final String convertComponentText(IComponent component) {
        Object propertyValue;
        Object object = ConvertFormToDslActionKt.access$getPropertyValue(component, "text");
        if (object == null) {
            return "";
        }
        Object object2 = propertyValue = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.uiDesigner.lw.StringDescriptor");
        }
        return this.convertStringDescriptor((StringDescriptor)object2);
    }

    private final String convertStringDescriptor(StringDescriptor text2) {
        String string = text2.getValue();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            return "\"" + StringUtil.escapeQuotes((String)it) + "\"";
        }
        return StringsKt.substringAfterLast$default((String)text2.getBundleName(), (char)'/', null, (int)2, null) + ".message(\"" + text2.getKey() + "\")";
    }

    public FormToDslConverter(@NotNull Module module, @Nullable UClass boundInstanceUClass) {
        this.module = module;
        this.boundInstanceUClass = boundInstanceUClass;
    }
}

