/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.uiDesigner;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.ProjectScope;
import com.intellij.uiDesigner.PsiPropertiesProvider;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.uiDesigner.ComponentBinding;
import org.jetbrains.idea.devkit.uiDesigner.ConvertFormDialog;
import org.jetbrains.idea.devkit.uiDesigner.FormCall;
import org.jetbrains.idea.devkit.uiDesigner.FormToDslConverter;
import org.jetbrains.idea.devkit.uiDesigner.UiForm;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0002\u001a\u001d\u0010\u001b\u001a\u00020\u0006*\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d\u00a2\u0006\u0002\u0010\u001e\u001a\u0016\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020!2\u0006\u0010\"\u001a\u00020\u0001H\u0002\u001a\u001f\u0010#\u001a\u00020$*\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"buildTypeParametersString", "", "module", "Lcom/intellij/openapi/module/Module;", "className", "convertFormToUiDsl", "", "boundClass", "Lcom/intellij/psi/PsiClass;", "formFile", "Lcom/intellij/psi/PsiFile;", "convertRootContainer", "Lorg/jetbrains/idea/devkit/uiDesigner/UiForm;", "rootContainer", "Lcom/intellij/uiDesigner/lw/LwRootContainer;", "boundInstanceUClass", "Lorg/jetbrains/uast/UClass;", "findBoundInstanceUClass", "project", "Lcom/intellij/openapi/project/Project;", "boundInstanceType", "generateOptionDescriptors", "call", "Lorg/jetbrains/idea/devkit/uiDesigner/FormCall;", "optionDescriptors", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "checkConvertButtonGroup", "ids", "", "(Lorg/jetbrains/idea/devkit/uiDesigner/FormCall;[Ljava/lang/String;)V", "getPropertyValue", "", "Lcom/intellij/uiDesigner/lw/IComponent;", "name", "isRadioButtonRow", "", "(Lorg/jetbrains/idea/devkit/uiDesigner/FormCall;[Ljava/lang/String;)Z", "intellij.devkit.uiDesigner"})
public final class ConvertFormToDslActionKt {
    public static final void convertFormToUiDsl(@NotNull PsiClass boundClass, @NotNull PsiFile formFile) {
        StringBuilder stringBuilder;
        String string;
        Object it;
        Project project = boundClass.getProject();
        PsiFile psiFile = boundClass.getContainingFile();
        if (psiFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
        }
        PsiJavaFile psiFile2 = (PsiJavaFile)psiFile;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return;
        }
        Module module2 = module;
        ConvertFormDialog dialog = new ConvertFormDialog(project, boundClass.getName() + "Ui");
        if (!dialog.showAndGet()) {
            return;
        }
        UClass boundInstanceUClass = ConvertFormToDslActionKt.findBoundInstanceUClass(project, dialog.getBoundInstanceType());
        LwRootContainer rootContainer = Utils.getRootContainer((String)formFile.getText(), (PropertiesProvider)((PropertiesProvider)new PsiPropertiesProvider(module2)));
        UiForm form = ConvertFormToDslActionKt.convertRootContainer(module2, rootContainer, boundInstanceUClass);
        LinkedHashSet<String> imports = new LinkedHashSet<String>(form.getImports());
        Object object = boundInstanceUClass;
        if (object != null && (object = object.getQualifiedName()) != null) {
            Object object2 = object;
            it = object2;
            boolean bl = false;
            imports.add((String)it);
        }
        if (dialog.getGenerateDescriptors()) {
            imports.add("com.intellij.application.options.editor.*");
        }
        if (dialog.getBaseClass() == ConvertFormDialog.FormBaseClass.Configurable) {
            imports.add("com.intellij.openapi.options.BoundConfigurable");
            imports.add("com.intellij.openapi.ui.DialogPanel");
        }
        if (dialog.getGenerateDescriptors()) {
            Object $this$buildString = it = new StringBuilder();
            boolean bl = false;
            ConvertFormToDslActionKt.generateOptionDescriptors(form.getRoot(), (StringBuilder)$this$buildString);
            String string2 = ((StringBuilder)it).toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string = "";
        }
        String optionDescriptors = string;
        String uiName = dialog.getClassName();
        FileType ktFileType = FileTypeRegistry.getInstance().getFileTypeByExtension("kt");
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharSequence charSequence = psiFile2.getPackageName();
        if (charSequence.length() > 0) {
            $this$buildString.append("package " + psiFile2.getPackageName() + "\n\n");
        }
        $this$buildString.append("import com.intellij.ui.layout.*\n");
        for (String string3 : imports) {
            $this$buildString.append("import " + string3 + "\n");
        }
        $this$buildString.append("\n");
        CharSequence charSequence2 = optionDescriptors;
        if (charSequence2.length() > 0) {
            $this$buildString.append("private val model = " + dialog.getBoundInstanceExpression());
            $this$buildString.append(optionDescriptors);
            $this$buildString.append("\n");
        }
        $this$buildString.append("class " + uiName);
        if (dialog.getBaseClass() == ConvertFormDialog.FormBaseClass.Configurable) {
            $this$buildString.append(" : BoundConfigurable(TODO(), TODO())");
        } else if (boundInstanceUClass != null) {
            $this$buildString.append("(val model: " + StringsKt.substringAfterLast$default((String)dialog.getBoundInstanceType(), (char)'.', null, (int)2, null) + ")");
        }
        $this$buildString.append(" {");
        for (ComponentBinding componentBinding : form.getComponentBindings()) {
            String typeParameters = ConvertFormToDslActionKt.buildTypeParametersString(module2, componentBinding.getType());
            $this$buildString.append("lateinit var " + componentBinding.getName() + ": " + StringsKt.substringAfterLast$default((String)componentBinding.getType(), (char)'.', null, (int)2, null) + typeParameters + "\n");
        }
        if (dialog.getBaseClass() == ConvertFormDialog.FormBaseClass.Configurable) {
            $this$buildString.append("override fun createPanel(): DialogPanel {\n");
            CharSequence charSequence3 = dialog.getBoundInstanceExpression();
            if (charSequence3.length() > 0) {
                $this$buildString.append("val model = " + dialog.getBoundInstanceExpression() + "\n");
            } else if (boundInstanceUClass != null) {
                $this$buildString.append("val model: " + StringsKt.substringAfterLast$default((String)dialog.getBoundInstanceType(), (char)'.', null, (int)2, null) + " = TODO()\n");
            }
            $this$buildString.append("return panel {\n");
            form.getRoot().render($this$buildString);
            $this$buildString.append("}\n");
        } else {
            $this$buildString.append("val panel = panel {\n");
            form.getRoot().render($this$buildString);
            $this$buildString.append("}\n");
        }
        $this$buildString.append("}");
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String ktFileText = string4;
        PsiFile ktFile = PsiFileFactory.getInstance((Project)project).createFileFromText(uiName + ".kt", ktFileType, (CharSequence)ktFileText);
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(psiFile2, ktFile, project){
            final /* synthetic */ PsiJavaFile $psiFile;
            final /* synthetic */ PsiFile $ktFile;
            final /* synthetic */ Project $project;

            public final void run() {
                PsiElement psiElement = this.$psiFile.getContainingDirectory().add((PsiElement)this.$ktFile);
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
                }
                PsiFile ktFileReal = (PsiFile)psiElement;
                CodeStyleManager.getInstance((Project)this.$project).reformat((PsiElement)ktFileReal);
                ktFileReal.navigate(true);
            }
            {
                this.$psiFile = psiJavaFile;
                this.$ktFile = psiFile;
                this.$project = project;
            }
        });
    }

    private static final UClass findBoundInstanceUClass(Project project, String boundInstanceType) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(boundInstanceType, ProjectScope.getAllScope((Project)project));
        if (psiClass == null) {
            return null;
        }
        return (UClass)UastContextKt.toUElement((PsiElement)psiClass.getNavigationElement(), UClass.class);
    }

    private static final UiForm convertRootContainer(Module module, LwRootContainer rootContainer, UClass boundInstanceUClass) {
        FormCall call = new FormToDslConverter(module, boundInstanceUClass).convertContainer((LwContainer)rootContainer);
        for (IButtonGroup buttonGroup : rootContainer.getButtonGroups()) {
            ConvertFormToDslActionKt.checkConvertButtonGroup(call, buttonGroup.getComponentIds());
        }
        return new UiForm(module, call);
    }

    private static final void generateOptionDescriptors(FormCall call, StringBuilder optionDescriptors) {
        String propertyName = call.getBinding();
        int size = call.getArgs().size();
        if (Intrinsics.areEqual((Object)call.getCallee(), (Object)"checkBox") && propertyName != null && size >= 1) {
            optionDescriptors.append("val " + propertyName + " = CheckboxDescriptor(" + call.getArgs().get(0) + ", ");
            String propertyBindingArg = size == 1 ? "TODO()" : (size == 2 ? call.getArgs().get(1) + ".toBinding()" : "PropertyBinding(" + call.getArgs().get(1) + ", " + call.getArgs().get(2) + ")");
            optionDescriptors.append(propertyBindingArg).append(")\n");
            call.getArgs().clear();
            call.getArgs().add(propertyName);
        }
        for (FormCall content : call.getContents()) {
            ConvertFormToDslActionKt.generateOptionDescriptors(content, optionDescriptors);
        }
    }

    private static final String buildTypeParametersString(Module module, String className) {
        String string;
        PsiTypeParameter[] psiTypeParameterArray;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass componentClass = javaPsiFacade.findClass(className, module.getModuleWithDependenciesScope());
        if (componentClass != null && !((psiTypeParameterArray = componentClass.getTypeParameters()).length == 0)) {
            int n = componentClass.getTypeParameters().length;
            Object[] objectArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                String string2;
                int n3 = n2;
                int n4 = n2++;
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                objectArray2[n4] = string2 = "Any";
            }
            Object[] objectArray3 = objectArray;
            Function1 function1 = null;
            objectArray = null;
            n2 = 0;
            CharSequence charSequence = ", ";
            CharSequence charSequence2 = ">";
            CharSequence charSequence3 = "<";
            string = ArraysKt.joinToString$default((Object[])objectArray3, (CharSequence)charSequence, (CharSequence)charSequence3, (CharSequence)charSequence2, (int)n2, (CharSequence)objectArray, function1, (int)56, null);
        } else {
            string = "";
        }
        return string;
    }

    private static final Object getPropertyValue(IComponent $this$getPropertyValue, String name) {
        IProperty iProperty;
        block2: {
            IProperty[] iPropertyArray;
            IProperty[] iPropertyArray2 = iPropertyArray = $this$getPropertyValue.getModifiedProperties();
            int n = iPropertyArray2.length;
            for (int i = 0; i < n; ++i) {
                IProperty iProperty2;
                IProperty it = iProperty2 = iPropertyArray2[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                iProperty = iProperty2;
                break block2;
            }
            iProperty = null;
        }
        if (iProperty == null) {
            return null;
        }
        IProperty prop = iProperty;
        return prop.getPropertyValue($this$getPropertyValue);
    }

    public static final void checkConvertButtonGroup(@NotNull FormCall $this$checkConvertButtonGroup, @NotNull String[] ids) {
        boolean bl;
        block8: {
            Iterable $this$any$iv = $this$checkConvertButtonGroup.getContents();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FormCall it = (FormCall)element$iv;
                    boolean bl2 = false;
                    if (!ConvertFormToDslActionKt.isRadioButtonRow(it, ids)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            int n;
            int firstIndex;
            block10: {
                int n2;
                block9: {
                    List<FormCall> $this$indexOfFirst$iv = $this$checkConvertButtonGroup.getContents();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object e : $this$indexOfFirst$iv) {
                        FormCall it = (FormCall)e;
                        boolean bl3 = false;
                        if (ConvertFormToDslActionKt.isRadioButtonRow(it, ids)) {
                            n2 = index$iv;
                            break block9;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                firstIndex = n2;
                List<FormCall> $this$indexOfLast$iv = $this$checkConvertButtonGroup.getContents();
                boolean $i$f$indexOfLast = false;
                ListIterator<FormCall> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    FormCall formCall = iterator$iv.previous();
                    boolean bl4 = false;
                    if (!ConvertFormToDslActionKt.isRadioButtonRow(formCall, ids)) continue;
                    n = iterator$iv.nextIndex();
                    break block10;
                }
                n = -1;
            }
            int lastIndex = n;
            FormCall buttonGroupNode = new FormCall("buttonGroup", null, null, null, null, null, false, 126, null);
            List<FormCall> buttonGroupControls = $this$checkConvertButtonGroup.getContents().subList(firstIndex, lastIndex + 1);
            buttonGroupNode.getContents().addAll((Collection<FormCall>)buttonGroupControls);
            $this$checkConvertButtonGroup.getContents().removeAll((Collection)buttonGroupControls);
            $this$checkConvertButtonGroup.getContents().add(firstIndex, buttonGroupNode);
            return;
        }
        for (FormCall content : $this$checkConvertButtonGroup.getContents()) {
            ConvertFormToDslActionKt.checkConvertButtonGroup(content, ids);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRadioButtonRow(FormCall $this$isRadioButtonRow, String[] ids) {
        Object object;
        if (!Intrinsics.areEqual((Object)$this$isRadioButtonRow.getCallee(), (Object)"row")) return false;
        FormCall formCall = (FormCall)CollectionsKt.singleOrNull($this$isRadioButtonRow.getContents());
        Object object2 = formCall;
        if (formCall == null) return false;
        IComponent iComponent = ((FormCall)object2).getOrigin();
        object2 = iComponent;
        if (iComponent == null) return false;
        String string = object2.getId();
        object2 = string;
        if (string == null) return false;
        Object it = object = object2;
        boolean bl = false;
        if (!ArraysKt.contains((Object[])ids, (Object)it)) return false;
        return true;
    }

    public static final /* synthetic */ String access$buildTypeParametersString(Module module, String className) {
        return ConvertFormToDslActionKt.buildTypeParametersString(module, className);
    }

    public static final /* synthetic */ Object access$getPropertyValue(IComponent $this$access_u24getPropertyValue, String name) {
        return ConvertFormToDslActionKt.getPropertyValue($this$access_u24getPropertyValue, name);
    }
}

