/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

public final class ThemeEditorToolbar
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"ThemeEditorToolbar");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (ThemeJsonUtil.isThemeFilename(file.getName())) {
            JBColor bg = JBColor.lazy(() -> ExperimentalUI.isNewUI() ? EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground() : JBColor.PanelBackground);
            EditorNotificationPanel panel2 = new EditorNotificationPanel((Color)bg);
            panel2.removeAll();
            panel2.setBorder(null);
            DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("DevKit.ThemeEditorToolbar");
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ThemeEditor", (ActionGroup)group, true);
            actionToolbar.setTargetComponent((JComponent)panel2);
            JComponent toolbarComponent = actionToolbar.getComponent();
            toolbarComponent.setBackground((Color)bg);
            panel2.add((Component)toolbarComponent);
            DataManager.registerDataProvider((JComponent)panel2, dataId -> CommonDataKeys.VIRTUAL_FILE.is(dataId) ? fileEditor.getFile() : null);
            return panel2;
        }
        return null;
    }
}

