/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

public class ThemeJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NonNls
    private static final String THEME_SCHEMA = "/schemes/theme.schema.json";

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        return Collections.singletonList(new JsonSchemaFileProvider(){

            public boolean isAvailable(@NotNull VirtualFile file) {
                return ThemeJsonUtil.isThemeFilename(file.getName());
            }

            @NotNull
            public String getName() {
                return DevKitThemesBundle.message("theme.json.display.name", new Object[0]);
            }

            @Nullable
            public VirtualFile getSchemaFile() {
                return JsonSchemaProviderFactory.getResourceFile(this.getClass(), (String)ThemeJsonSchemaProviderFactory.THEME_SCHEMA);
            }

            @NotNull
            public SchemaType getSchemaType() {
                return SchemaType.embeddedSchema;
            }
        });
    }
}

