/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.ui.UIThemeMetadata;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;
import org.jetbrains.idea.devkit.themes.metadata.UIThemeMetadataService;

public class ThemeJsonCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement position = parameters.getPosition();
        if (!(position instanceof LeafPsiElement)) {
            return;
        }
        if (!ThemeJsonCompletionContributor.isThemeJsonFile(parameters.getOriginalFile())) {
            return;
        }
        PsiElement parent = position.getParent();
        if (parent instanceof JsonStringLiteral || parent instanceof JsonReferenceExpression) {
            PsiElement parentParent = parent.getParent();
            if (!(parentParent instanceof JsonProperty)) {
                return;
            }
            ThemeJsonCompletionContributor.handleJsonProperty(position, (JsonProperty)parentParent, parameters, result);
        } else if (parent instanceof JsonProperty) {
            ThemeJsonCompletionContributor.handleJsonProperty(position, (JsonProperty)parent, parameters, result);
        }
    }

    private static boolean isThemeJsonFile(@Nullable PsiFile file) {
        return file instanceof JsonFile && ThemeJsonUtil.isThemeFilename(file.getName());
    }

    private static void handleJsonProperty(@NotNull PsiElement element, @NotNull JsonProperty property, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        if (!ThemeJsonUtil.isInsideUiProperty(property)) {
            return;
        }
        if (!ThemeJsonCompletionContributor.isPropertyKey(element)) {
            return;
        }
        String presentNamePart = ThemeJsonUtil.getParentNames(property);
        boolean shouldSurroundWithQuotes = !element.getText().startsWith("\"");
        Iterable<LookupElement> lookupElements = ThemeJsonCompletionContributor.getLookupElements(presentNamePart, shouldSurroundWithQuotes);
        result.addAllElements(lookupElements);
    }

    private static boolean isPropertyKey(@NotNull PsiElement element) {
        PsiElement sibling = element.getParent();
        while ((sibling = sibling.getPrevSibling()) != null) {
            if (!":".equals(sibling.getText())) continue;
            return false;
        }
        return true;
    }

    private static Iterable<LookupElement> getLookupElements(@NotNull String presentNamePart, boolean shouldSurroundWithQuotes) {
        Function<String, String> mapFunction;
        Predicate<String> conditionFilter;
        if (presentNamePart.startsWith("*")) {
            String tail = presentNamePart.substring(1);
            conditionFilter = key -> key.endsWith(tail);
            mapFunction = key -> key.substring(presentNamePart.length() - 1);
        } else if (presentNamePart.isEmpty()) {
            conditionFilter = key -> true;
            mapFunction = key -> key;
        } else {
            conditionFilter = key -> StringUtil.startsWithConcatenation((String)key, (String[])new String[]{presentNamePart, "."});
            mapFunction = key -> key.substring(presentNamePart.length() + 1);
        }
        SmartList variants = new SmartList();
        PairProcessor processor = (arg_0, arg_1) -> ThemeJsonCompletionContributor.lambda$getLookupElements$6(conditionFilter, mapFunction, shouldSurroundWithQuotes, (List)variants, arg_0, arg_1);
        UIThemeMetadataService.getInstance().processAllKeys((PairProcessor<? super UIThemeMetadata, ? super UIThemeMetadata.UIKeyMetadata>)processor);
        return variants;
    }

    private static /* synthetic */ boolean lambda$getLookupElements$6(Predicate conditionFilter, Function mapFunction, boolean shouldSurroundWithQuotes, List variants, UIThemeMetadata themeMetadata, UIThemeMetadata.UIKeyMetadata uiKeyMetadata) {
        String key = uiKeyMetadata.getKey();
        if (!conditionFilter.test(key)) {
            return true;
        }
        String completionKey = (String)mapFunction.apply(key);
        String description2 = uiKeyMetadata.getDescription();
        boolean deprecated = uiKeyMetadata.isDeprecated();
        String source = uiKeyMetadata.getSource();
        String since = uiKeyMetadata.getSince();
        LookupElementBuilder builder2 = LookupElementBuilder.create((String)completionKey).withPresentableText(key).withStrikeoutness(deprecated).appendTailText((String)(StringUtil.isEmpty((String)since) ? "" : " [" + since + "]"), true).appendTailText((String)(StringUtil.isEmpty((String)description2) ? "" : " (" + description2 + ")"), true).appendTailText((String)(StringUtil.isEmpty((String)source) ? "" : " " + source), true).withTypeText("[" + (String)ObjectUtils.chooseNotNull((Object)themeMetadata.getName(), (Object)themeMetadata.getPluginId()) + "]").withInsertHandler((InsertHandler)(shouldSurroundWithQuotes ? MyInsertHandler.SURROUND_WITH_QUOTES : MyInsertHandler.INSTANCE));
        variants.add(deprecated ? PrioritizedLookupElement.withPriority((LookupElement)builder2, (double)-100.0) : builder2);
        return true;
    }

    private static final class MyInsertHandler
    implements InsertHandler<LookupElement> {
        private static final MyInsertHandler INSTANCE = new MyInsertHandler(false);
        private static final MyInsertHandler SURROUND_WITH_QUOTES = new MyInsertHandler(true);
        private final boolean mySurroundWithQuotes;

        private MyInsertHandler(boolean surroundWithQuotes) {
            this.mySurroundWithQuotes = surroundWithQuotes;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (this.mySurroundWithQuotes) {
                String quoted = "\"" + item.getLookupString() + "\"";
                context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)quoted);
            }
        }
    }
}

