/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant.vfs;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataUtil;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupFileSystem;

@Presentation(icon="AllIcons.Nodes.TestSourceFolder")
public class TestDataGroupVirtualFile
extends VirtualFile {
    private final VirtualFile myBeforeFile;
    private final VirtualFile myAfterFile;

    public TestDataGroupVirtualFile(@NotNull VirtualFile beforeFile, @NotNull VirtualFile afterFile) {
        this.myBeforeFile = beforeFile;
        this.myAfterFile = afterFile;
    }

    @NotNull
    public String getName() {
        return TestDataUtil.getGroupDisplayName(this.myBeforeFile.getName(), this.myAfterFile.getName());
    }

    @NotNull
    public VirtualFile getBeforeFile() {
        return this.myBeforeFile;
    }

    @NotNull
    public VirtualFile getAfterFile() {
        return this.myAfterFile;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return TestDataGroupFileSystem.getTestDataGroupFileSystem();
    }

    @NotNull
    public String getPath() {
        return TestDataGroupFileSystem.getPath(this.myBeforeFile, this.myAfterFile);
    }

    public boolean isWritable() {
        return this.myBeforeFile.isWritable();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return this.myBeforeFile.isValid() && this.myAfterFile.isValid();
    }

    public VirtualFile getParent() {
        return this.myBeforeFile.getParent();
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    public long getTimeStamp() {
        return this.myBeforeFile.getTimeStamp();
    }

    public long getLength() {
        return this.myBeforeFile.getLength();
    }

    public long getModificationStamp() {
        return this.myBeforeFile.getModificationStamp();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public FileType getFileType() {
        return this.myBeforeFile.getFileType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TestDataGroupVirtualFile file = (TestDataGroupVirtualFile)((Object)o);
        if (!this.myAfterFile.equals(file.myAfterFile)) {
            return false;
        }
        return this.myBeforeFile.equals(file.myBeforeFile);
    }

    public int hashCode() {
        int result = this.myBeforeFile.hashCode();
        result = 31 * result + this.myAfterFile.hashCode();
        return result;
    }
}

