/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

public class TestDataReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)UastPatterns.injectionHostUExpression().annotationParam("com.intellij.testFramework.TestDataPath", "value"), (UastReferenceProvider)new TestDataReferenceProvider(), (double)0.0);
    }

    public static class TestDataReference
    extends FileReference {
        public TestDataReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text2) {
            super(fileReferenceSet, range, index, text2);
        }

        public Object @NotNull [] getVariants() {
            if (this.getIndex() == 0 && !StringUtil.startsWithChar((CharSequence)this.getFileReferenceSet().getPathString(), (char)'/')) {
                PsiDirectory contentPsiRoot;
                HashSet variants = ContainerUtil.newHashSet((Object[])super.getVariants());
                PsiDirectory projectPsiRoot = this.getProjectPsiRoot();
                if (projectPsiRoot != null) {
                    variants.add(FileInfoManager.getFileLookupItem((PsiElement)projectPsiRoot, (String)"$PROJECT_ROOT", (Icon)projectPsiRoot.getIcon(0)).withTypeText(projectPsiRoot.getVirtualFile().getPath(), true));
                }
                if ((contentPsiRoot = this.getContentPsiRoot()) != null) {
                    variants.add(FileInfoManager.getFileLookupItem((PsiElement)contentPsiRoot, (String)"$CONTENT_ROOT", (Icon)contentPsiRoot.getIcon(0)).withTypeText(contentPsiRoot.getVirtualFile().getPath(), true));
                }
                return ArrayUtil.toObjectArray((Collection)variants);
            }
            return super.getVariants();
        }

        protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
            if (this.getIndex() == 0 && StringUtil.startsWithChar((CharSequence)this.getText(), (char)'$')) {
                PsiDirectory contentPsiRoot;
                if ("$PROJECT_ROOT".equals(this.getText())) {
                    PsiDirectory projectPsiRoot = this.getProjectPsiRoot();
                    if (projectPsiRoot != null) {
                        return new ResolveResult[]{new PsiElementResolveResult((PsiElement)projectPsiRoot)};
                    }
                } else if ("$CONTENT_ROOT".equals(this.getText()) && (contentPsiRoot = this.getContentPsiRoot()) != null) {
                    return new ResolveResult[]{new PsiElementResolveResult((PsiElement)contentPsiRoot)};
                }
            }
            return super.innerResolve(caseSensitive, containingFile);
        }

        @Nullable
        private PsiDirectory getProjectPsiRoot() {
            Project project = this.getElement().getProject();
            VirtualFile projectDir = project.getBaseDir();
            if (projectDir != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return psiManager.findDirectory(projectDir);
            }
            return null;
        }

        @Nullable
        private PsiDirectory getContentPsiRoot() {
            VirtualFile contentRoot;
            Project project = this.getElement().getProject();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile file = this.getElement().getContainingFile().getOriginalFile().getVirtualFile();
            if (file != null && (contentRoot = fileIndex.getContentRootForFile(file)) != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return psiManager.findDirectory(contentRoot);
            }
            return null;
        }
    }

    private static class TestDataReferenceSet
    extends FileReferenceSet {
        TestDataReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
            super(str, element, startInElement, provider, isCaseSensitive, true);
        }

        public boolean isEmptyPathAllowed() {
            return false;
        }

        public boolean isAbsolutePathReference() {
            return super.isAbsolutePathReference() || StringUtil.startsWithChar((CharSequence)this.getPathString(), (char)'$');
        }

        public FileReference createFileReference(TextRange range, int index, String text2) {
            return new TestDataReference(this, range, index, text2);
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            return this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
        }

        protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
            return DIRECTORY_FILTER;
        }
    }

    private static class TestDataReferenceProvider
    extends UastInjectionHostReferenceProvider {
        private TestDataReferenceProvider() {
        }

        public boolean acceptsTarget(@NotNull PsiElement target) {
            return target instanceof PsiFileSystemItem;
        }

        public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
            TextRange range = ElementManipulators.getValueTextRange((PsiElement)host);
            String stringValue = UastUtils.evaluateString((UExpression)uExpression);
            if (stringValue == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            TestDataReferenceSet referenceSet = new TestDataReferenceSet(stringValue, (PsiElement)host, range.getStartOffset(), null, false);
            referenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, FileReferenceSet.ABSOLUTE_TOP_LEVEL);
            return referenceSet.getAllReferences();
        }
    }
}

