/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByTestDiscoveryUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataLineMarkerProvider;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.evaluation.SimpleEvaluatorExtension;
import org.jetbrains.uast.evaluation.UEvaluationContextKt;
import org.jetbrains.uast.evaluation.UEvaluatorExtension;
import org.jetbrains.uast.values.UBooleanConstant;
import org.jetbrains.uast.values.UConstant;
import org.jetbrains.uast.values.UStringConstant;
import org.jetbrains.uast.values.UValue;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class TestDataReferenceCollector {
    private final String myTestDataPath;
    private final String myTestName;
    private final List<String> myLogMessages = new ArrayList<String>();
    private PsiClass myContainingClass;
    private boolean myFoundTestDataParameters = false;

    public TestDataReferenceCollector(@Nullable String testDataPath, String testName) {
        if (StringUtil.isNotEmpty((String)testDataPath) && !StringUtil.endsWithChar((CharSequence)testDataPath, (char)'/')) {
            testDataPath = (String)testDataPath + "/";
        }
        this.myTestDataPath = testDataPath;
        this.myTestName = testName;
    }

    @NotNull
    List<TestDataFile> collectTestDataReferences(@NotNull PsiMethod method) {
        return this.collectTestDataReferences(method, true);
    }

    @NotNull
    List<TestDataFile> collectTestDataReferences(@NotNull PsiMethod method, boolean collectByExistingFiles) {
        this.myContainingClass = (PsiClass)ReadAction.compute(() -> method.getContainingClass());
        List<TestDataFile> result = this.collectTestDataReferences(method, new HashMap<String, Computable<UValue>>(), new HashSet<Pair<PsiMethod, Set<UExpression>>>());
        if (!this.myFoundTestDataParameters) {
            this.myLogMessages.add("Found no parameters annotated with @TestDataFile");
        }
        if (collectByExistingFiles && result.isEmpty()) {
            result = new ArrayList<TestDataFile>();
            result.addAll(TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(method, this.myTestDataPath));
            result.addAll(TestDataGuessByTestDiscoveryUtil.collectTestDataByExistingFiles(method));
        }
        return result;
    }

    private List<TestDataFile> collectTestDataReferences(PsiMethod method, final Map<String, Computable<UValue>> argumentMap, final HashSet<Pair<PsiMethod, Set<UExpression>>> proceed) {
        final ArrayList<TestDataFile> result = new ArrayList<TestDataFile>();
        return this.myTestDataPath == null ? result : (List)ReadAction.compute(() -> {
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method);
            if (uMethod == null) {
                return result;
            }
            String testMetaData = TestDataLineMarkerProvider.annotationValue((PsiModifierListOwner)uMethod, "org.jetbrains.kotlin.test.TestMetadata");
            if (testMetaData != null) {
                result.add(new TestDataFile.LazyResolved(this.myTestDataPath + testMetaData));
                return result;
            }
            uMethod.accept((UastVisitor)new AbstractUastVisitor(){

                public boolean visitCallExpression(@NotNull UCallExpression expression) {
                    UMethod implementation;
                    PsiClass calleeContainingClass;
                    String callText = expression.getMethodName();
                    if (callText == null) {
                        return true;
                    }
                    UMethod callee = (UMethod)UastContextKt.toUElement((PsiElement)expression.resolve(), UMethod.class);
                    if (callee != null && callee.hasModifierProperty("abstract") && (calleeContainingClass = callee.getContainingClass()) != null && TestDataReferenceCollector.this.myContainingClass.isInheritor(calleeContainingClass, true) && (implementation = (UMethod)UastContextKt.toUElement((PsiElement)TestDataReferenceCollector.this.myContainingClass.findMethodBySignature((PsiMethod)callee, true), UMethod.class)) != null) {
                        callee = implementation;
                    }
                    Pair methodWithArguments = new Pair((Object)callee, new HashSet(expression.getValueArguments()));
                    if (callee != null && proceed.add(methodWithArguments)) {
                        boolean haveAnnotatedParameters = false;
                        PsiParameter[] psiParameters = callee.getParameterList().getParameters();
                        int psiParametersLength = psiParameters.length;
                        for (int i = 0; i < psiParametersLength; ++i) {
                            PsiParameter psiParameter = psiParameters[i];
                            PsiModifierList modifierList = psiParameter.getModifierList();
                            if (modifierList == null || !modifierList.hasAnnotation("com.intellij.testFramework.TestDataFile")) continue;
                            TestDataReferenceCollector.this.myFoundTestDataParameters = true;
                            if (psiParameter.isVarArgs()) {
                                this.processVarargCallArgument(expression, argumentMap, result);
                            } else {
                                this.processCallArgument(expression, argumentMap, result, i);
                            }
                            haveAnnotatedParameters = true;
                        }
                        if (expression.getReceiver() == null && !haveAnnotatedParameters) {
                            result.addAll(TestDataReferenceCollector.this.collectTestDataReferences((PsiMethod)callee, TestDataReferenceCollector.this.buildArgumentMap(expression, (PsiMethod)callee), proceed));
                        }
                    }
                    return true;
                }

                private void processCallArgument(UCallExpression expression, Map<String, Computable<UValue>> argumentMap2, Collection<TestDataFile> result2, int index) {
                    List arguments = expression.getValueArguments();
                    if (arguments.size() > index) {
                        this.handleArgument((UExpression)arguments.get(index), argumentMap2, result2);
                    }
                }

                private void processVarargCallArgument(UCallExpression expression, Map<String, Computable<UValue>> argumentMap2, Collection<TestDataFile> result2) {
                    List arguments = expression.getValueArguments();
                    for (UExpression argument : arguments) {
                        this.handleArgument(argument, argumentMap2, result2);
                    }
                }

                private void handleArgument(UExpression argument, Map<String, Computable<UValue>> argumentMap2, Collection<TestDataFile> result2) {
                    UValue testDataFileValue = UEvaluationContextKt.uValueOf((UExpression)argument, (UEvaluatorExtension[])new UEvaluatorExtension[]{new TestDataEvaluatorExtension(argumentMap2)});
                    if (testDataFileValue instanceof UStringConstant) {
                        result2.add(new TestDataFile.LazyResolved(TestDataReferenceCollector.this.myTestDataPath + ((UStringConstant)testDataFileValue).getValue()));
                    }
                }
            });
            return result;
        });
    }

    private Map<String, Computable<UValue>> buildArgumentMap(UCallExpression expression, PsiMethod method) {
        HashMap<String, Computable<UValue>> result = new HashMap<String, Computable<UValue>>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        List arguments = expression.getValueArguments();
        for (int i = 0; i < arguments.size() && i < parameters.length; ++i) {
            UExpression arg = (UExpression)arguments.get(i);
            TestDataEvaluatorExtension extension = new TestDataEvaluatorExtension(Collections.emptyMap());
            result.put(parameters[i].getName(), (Computable<UValue>)((NullableComputable)() -> UEvaluationContextKt.uValueOf((UExpression)arg, (UEvaluatorExtension[])new UEvaluatorExtension[]{extension})));
        }
        return result;
    }

    public String getLog() {
        return StringUtil.join(this.myLogMessages, (String)"\n");
    }

    private final class TestDataEvaluatorExtension
    extends SimpleEvaluatorExtension {
        private final Map<String, Computable<UValue>> myArguments;

        private TestDataEvaluatorExtension(Map<String, Computable<UValue>> arguments) {
            this.myArguments = arguments;
        }

        public Object evaluateMethodCall(@NotNull PsiMethod target, @NotNull List<? extends UValue> argumentValues) {
            if (target.getName().equals("getTestName") && argumentValues.size() == 1) {
                UValue lowercaseArg = argumentValues.get(0);
                boolean lowercaseArgValue = lowercaseArg instanceof UBooleanConstant && ((UBooleanConstant)lowercaseArg).getValue() != false;
                return lowercaseArgValue && !TestDataReferenceCollector.this.myTestName.isEmpty() ? this.lowercaseFirstLetter(TestDataReferenceCollector.this.myTestName) : TestDataReferenceCollector.this.myTestName;
            }
            return super.evaluateMethodCall(target, argumentValues);
        }

        public Object evaluateVariable(@NotNull UVariable variable) {
            Computable<UValue> value;
            if (variable instanceof UParameter && (value = this.myArguments.get(variable.getName())) != null) {
                UValue computedValue = (UValue)value.compute();
                UConstant constant = computedValue.toConstant();
                return constant != null ? constant.getValue() : super.evaluateVariable(variable);
            }
            return super.evaluateVariable(variable);
        }

        private String lowercaseFirstLetter(String name) {
            boolean lowercaseChars = false;
            int uppercaseChars = 0;
            for (int i = 0; i < name.length(); ++i) {
                if (Character.isLowerCase(name.charAt(i))) {
                    lowercaseChars = true;
                    break;
                }
                if (!Character.isUpperCase(name.charAt(i))) continue;
                ++uppercaseChars;
            }
            return !lowercaseChars && uppercaseChars >= 3 ? name : Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
    }
}

