/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataHighlightingPass;

final class TestDataHighlightingPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    public static final List<String> SUPPORTED_FILE_TYPES = Collections.singletonList(JavaFileType.INSTANCE.getDefaultExtension());
    public static final List<@NonNls String> SUPPORTED_IN_TEST_DATA_FILE_TYPES = ContainerUtil.immutableList((Object[])new String[]{"js", "php", "css", "html", "xhtml", "jsp", "test", "py", "aj"});
    private static final int MAX_HOPES = 3;
    @NonNls
    private static final String TEST_DATA = "testdata";

    TestDataHighlightingPassFactory() {
    }

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            Project project = file.getProject();
            Document document = file.getViewProvider().getDocument();
            if (TestDataHighlightingPassFactory.isSupported(virtualFile, project) && document != null) {
                return new TestDataHighlightingPass(project, document);
            }
        }
        return null;
    }

    private static boolean isSupported(@NotNull VirtualFile file, @NotNull Project project) {
        if (ScratchUtil.isScratch((VirtualFile)file)) {
            return false;
        }
        String ext = file.getExtension();
        if (SUPPORTED_FILE_TYPES.contains(ext)) {
            return ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file) == null;
        }
        if (SUPPORTED_IN_TEST_DATA_FILE_TYPES.contains(ext)) {
            int i = 0;
            for (VirtualFile parent = file.getParent(); parent != null && i < 3; ++i, parent = parent.getParent()) {
                if (!StringUtil.toLowerCase((String)parent.getName()).contains(TEST_DATA)) continue;
                return true;
            }
        }
        return false;
    }
}

