/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;

public final class TestDataGuessByTestDiscoveryUtil {
    @NonNls
    public static final String COMMUNITY_PREFIX = "/community";

    @NotNull
    static List<TestDataFile> collectTestDataByExistingFiles(@NotNull PsiMethod method) {
        if (!TestDataGuessByTestDiscoveryUtil.isEnabled()) {
            return Collections.emptyList();
        }
        PsiClass testClass = (PsiClass)ReadAction.compute(() -> method.getContainingClass());
        if (testClass == null) {
            return Collections.emptyList();
        }
        String testClassQualifiedName = (String)ReadAction.compute(() -> testClass.getQualifiedName());
        if (testClassQualifiedName == null) {
            return Collections.emptyList();
        }
        List<Couple> testQName = Collections.singletonList(Couple.of((Object)testClassQualifiedName, (Object)((String)ReadAction.compute(() -> method.getName()))));
        Project project = (Project)ReadAction.compute(() -> method.getProject());
        AffectedPathConsumer consumer = new AffectedPathConsumer(project);
        TestDiscoveryProducer.consumeAffectedPaths((Project)project, testQName, (Consumer)consumer, (byte)0);
        return consumer.getTestData();
    }

    @NotNull
    static List<TestDataFile> collectTestDataByExistingFiles(@NotNull PsiClass parametrizedTestClass) {
        if (!TestDataGuessByTestDiscoveryUtil.isEnabled()) {
            return Collections.emptyList();
        }
        String testClassQualifiedName = (String)ReadAction.compute(() -> parametrizedTestClass.getQualifiedName());
        if (testClassQualifiedName == null) {
            return Collections.emptyList();
        }
        Project project = (Project)ReadAction.compute(() -> parametrizedTestClass.getProject());
        AffectedPathConsumer consumer = new AffectedPathConsumer(project);
        TestDiscoveryProducer.consumeAffectedPaths((Project)project, (String)testClassQualifiedName, (Consumer)consumer, (byte)0);
        return consumer.getTestData();
    }

    private static boolean isEnabled() {
        return Registry.is((String)"testDiscovery.enabled") || ApplicationManager.getApplication().isInternal();
    }

    private static final class AffectedPathConsumer
    implements Consumer<String> {
        private final List<String> myTestData = new ArrayList<String>();
        private final String myBasePath;

        private AffectedPathConsumer(Project project) {
            this.myBasePath = project.getBasePath();
        }

        public void consume(String path) {
            String fullPath = this.myBasePath + path;
            if (FileUtil.exists((String)fullPath)) {
                this.myTestData.add(fullPath);
                return;
            }
            fullPath = this.myBasePath + (path = StringUtil.trimStart((String)path, (String)TestDataGuessByTestDiscoveryUtil.COMMUNITY_PREFIX));
            if (FileUtil.exists((String)fullPath)) {
                this.myTestData.add(fullPath);
            }
        }

        @NotNull
        List<TestDataFile> getTestData() {
            return ContainerUtil.mapNotNull(this.myTestData, f -> new TestDataFile.LazyResolved((String)f));
        }
    }
}

